/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DefaultXmlManager;
import zigen.plugin.db.core.Condition;

public class ConditionManager
extends DefaultXmlManager {
    private Map map = this.load();

    public ConditionManager(IPath path) {
        super(path, "condition_history.xml");
        if (this.map == null) {
            this.map = new HashMap();
        }
    }

    public Condition getCondition(String connectionUrl, String schema, String table) {
        String key = schema != null ? String.valueOf(connectionUrl) + "." + schema + "." + table : String.valueOf(connectionUrl) + "." + table;
        if (this.map.containsKey(key)) {
            return (Condition)this.map.get(key);
        }
        return null;
    }

    public void setCondition(Condition condition) {
        String key = condition.getSchema() != null ? String.valueOf(condition.getConnectionUrl()) + "." + condition.getSchema() + "." + condition.getTable() : String.valueOf(condition.getConnectionUrl()) + "." + condition.getTable();
        this.map.put(key, condition);
    }

    public Map load() {
        try {
            Object obj = super.loadXml();
            if (obj instanceof Map) {
                return (Map)obj;
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
        return null;
    }

    public void save() {
        try {
            super.saveXml(this.map);
        }
        catch (IOException e) {
            DbPlugin.log(e);
        }
    }
}

