/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.math.BigDecimal;
import java.util.Date;

public class TimeWatcher {
    private Date startTime = null;
    private Date stopTime = null;
    private boolean isStart = false;

    public void reset() {
        this.isStart = false;
        this.startTime = null;
        this.stopTime = null;
    }

    public void start() {
        if (this.isStart) {
            throw new IllegalStateException("The response is being measured now.");
        }
        this.isStart = true;
        this.startTime = new Date();
    }

    public void stop() {
        if (!this.isStart) {
            throw new IllegalStateException("Please begin measuring.");
        }
        this.isStart = false;
        this.stopTime = new Date();
    }

    public String getTotalTime() {
        if (this.startTime == null) {
            throw new IllegalStateException("Please begin measuring. ");
        }
        if (this.stopTime == null) {
            throw new IllegalStateException("Please end measuring. ");
        }
        return this.getString((double)(this.stopTime.getTime() - this.startTime.getTime()) / 1000.0);
    }

    private String getString(double second) {
        StringBuffer sb = new StringBuffer();
        if ((int)(second / 3600.0) > 0) {
            sb.append(String.valueOf((int)(second / 3600.0)) + "h");
        }
        if ((int)(second % 3600.0 / 60.0) > 0) {
            sb.append(String.valueOf((int)(second % 3600.0) / 60) + "min");
        }
        sb.append(String.valueOf(TimeWatcher.formart(second % 60.0)) + "sec");
        return sb.toString();
    }

    private static String formart(double time) {
        BigDecimal decimal = new BigDecimal(time);
        decimal = decimal.setScale(1, 0);
        return decimal.toString();
    }

    public boolean isStart() {
        return this.isStart;
    }
}

