/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule.oracle;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.JDBCUnicodeConvertor;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.core.rule.DefaultMappingFactory;
import zigen.plugin.db.core.rule.IMappingFactory;

public class OracleMappingFactory
extends DefaultMappingFactory
implements IMappingFactory {
    public static final int ORACLE_TIMESTAMP = -100;
    public static final int ORACLE_XMLTYPE = 2007;

    public OracleMappingFactory(boolean convertUnicode) {
        super(convertUnicode);
    }

    public Object getObject(ResultSet rs, int icol) throws SQLException {
        ResultSetMetaData rmd = rs.getMetaData();
        int type = rmd.getColumnType(icol);
        switch (type) {
            case 1: {
                return this.getChar(rs, icol);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(rs, icol);
            }
        }
        return super.getObject(rs, icol);
    }

    protected String getChar(ResultSet rs, int icol) throws SQLException {
        String value = rs.getString(icol);
        if (rs.wasNull()) {
            return this.nullSymbol;
        }
        if (this.convertUnicode) {
            value = JDBCUnicodeConvertor.convert(value);
        }
        if (value != null) {
            value = StringUtil.padding(value.trim(), rs.getMetaData().getColumnDisplaySize(icol));
        }
        return value;
    }

    protected String getDate(ResultSet rs, int icol) throws SQLException {
        Timestamp value = rs.getTimestamp(icol);
        if (rs.wasNull()) {
            return this.nullSymbol;
        }
        return this.timeStampFormat.format(new Date(value.getTime()));
    }

    protected String getTimestamp(ResultSet rs, int icol) throws SQLException {
        Timestamp value = rs.getTimestamp(icol);
        if (rs.wasNull()) {
            return this.nullSymbol;
        }
        return this.timeStampFormat2.format(new Date(value.getTime()));
    }

    protected void setDate(PreparedStatement pst, int icol, String str) throws Exception {
        if (this.nullSymbol.equals(str)) {
            pst.setNull(icol, 93);
        } else {
            pst.setTimestamp(icol, this.toTimestamp(str));
        }
    }

    protected void setTimestamp(PreparedStatement pst, int icol, String str) throws Exception {
        if (this.nullSymbol.equals(str)) {
            pst.setNull(icol, 93);
        } else {
            pst.setTimestamp(icol, this.toTimestamp2(str));
        }
    }

    protected void setBlob(PreparedStatement pst, int icol, Object value) throws SQLException {
        if (value == null) {
            pst.setNull(icol, 2004);
            return;
        }
        int size = 0;
        try {
            if (value instanceof File) {
                File file = (File)value;
                size = (int)file.length();
                pst.setBinaryStream(icol, (InputStream)new FileInputStream(file), size);
            } else if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                size = bytes.length;
                pst.setBinaryStream(icol, (InputStream)new ByteArrayInputStream(bytes), size);
            } else if (value instanceof String) {
                String str = (String)value;
                if (this.nullSymbol.equals(str)) {
                    pst.setNull(icol, 2004);
                    return;
                }
                byte[] bytes = str.getBytes();
                size = bytes.length;
                pst.setBinaryStream(icol, (InputStream)new ByteArrayInputStream(bytes), size);
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    protected Object getBlob(ResultSet rs, int icol) throws SQLException {
        String obj = null;
        try {
            rs.getBlob(icol);
            if (rs.wasNull()) {
                return this.nullSymbol;
            }
            obj = "<<BLOB>>";
        }
        catch (Exception e) {
            DbPlugin.log(e);
            throw new SQLException(e.getMessage());
        }
        return obj;
    }

    protected void setClob(PreparedStatement pst, int icol, Object value) throws SQLException {
        if (value == null) {
            pst.setNull(icol, 2005);
            return;
        }
        int size = 0;
        try {
            if (value instanceof File) {
                File file = (File)value;
                size = (int)file.length();
                pst.setCharacterStream(icol, (Reader)new FileReader(file), size);
            } else if (value instanceof char[]) {
                char[] chars = (char[])value;
                size = chars.length;
                pst.setCharacterStream(icol, (Reader)new CharArrayReader(chars), size);
            } else if (value instanceof String) {
                String str = (String)value;
                if (this.nullSymbol.equals(str)) {
                    pst.setNull(icol, 2005);
                    return;
                }
                size = str.getBytes().length;
                pst.setCharacterStream(icol, (Reader)new StringReader(str), size);
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    protected Object getClob(ResultSet rs, int icol) throws SQLException {
        String obj = null;
        try {
            rs.getClob(icol);
            if (rs.wasNull()) {
                return this.nullSymbol;
            }
            obj = "<<CLOB>>";
        }
        catch (Exception e) {
            DbPlugin.log(e);
            throw new SQLException(e.getMessage());
        }
        return obj;
    }

    protected boolean canModify_BLOB() {
        return true;
    }

    protected boolean canModify_CLOB() {
        return true;
    }

    protected void setVarchar(PreparedStatement pst, int icol, String str) throws SQLException {
        this.setLonvarchar(pst, icol, str);
    }
}

