/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule.oracle;

import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.rule.DefaultSQLCreatorFactory;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class OracleSQLCreatorFactory
extends DefaultSQLCreatorFactory {
    public OracleSQLCreatorFactory(ITable table) {
        super(table);
    }

    protected String getColumnLabel(TableColumn column) {
        StringBuffer sb = new StringBuffer();
        sb.append("    ");
        sb.append(StringUtil.padding(column.getColumnName(), 28));
        String typeName = column.getTypeName().toUpperCase();
        sb.append(typeName);
        if (this.isVisibleColumnSize(typeName) && !column.isWithoutParam()) {
            if (column.getDecimalDigits() == 0) {
                sb.append("(" + column.getColumnSize() + ")");
            } else {
                sb.append("(" + column.getColumnSize() + "," + column.getDecimalDigits() + ")");
            }
        }
        if (column.getDefaultValue() != null && !"".equals(column.getDefaultValue())) {
            sb.append(" DEFAULT ");
            sb.append(column.getDefaultValue().trim());
        }
        return sb.toString();
    }

    public String createSelect(String _condition, int limit) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        String[] conditions = SQLFormatter.splitOrderCause(_condition);
        String condition = conditions[0];
        String orderBy = conditions[1];
        if (condition != null && !"".equals(condition.trim())) {
            sb.append(" WHERE " + condition);
            if (limit > 0) {
                sb.append(" AND ROWNUM <= " + ++limit);
            }
        } else if (limit > 0) {
            sb.append(" WHERE ROWNUM <= " + ++limit);
        }
        if (orderBy != null && !"".equals(orderBy)) {
            sb.append(" " + orderBy);
        }
        return sb.toString();
    }

    private void addColumnName(StringBuffer sb) {
        Column[] cols = this.table.getColumns();
        int i = 0;
        while (i < cols.length) {
            Column column = cols[i];
            if (i == 0) {
                sb.append("\"");
                sb.append(column.getName());
                sb.append("\"");
            } else {
                sb.append(", ");
                sb.append("\"");
                sb.append(column.getName());
                sb.append("\"");
            }
            ++i;
        }
    }

    public boolean isSupportPager() {
        return true;
    }

    public String createSelectForPager(String _condition, int offset, int limit) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT");
        this.addColumnName(sb);
        sb.append(" FROM (SELECT W.*, ROWNUM LINE FROM (");
        sb.append(" SELECT * FROM ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        String[] conditions = SQLFormatter.splitOrderCause(_condition);
        String condition = conditions[0];
        String orderBy = conditions[1];
        if (condition != null && !"".equals(condition.trim())) {
            sb.append(" WHERE " + condition);
        }
        if (orderBy != null && !"".equals(orderBy)) {
            sb.append(" " + orderBy);
        }
        sb.append(") W ) T WHERE line BETWEEN ").append(offset).append(" AND ").append(offset + limit - 1);
        return sb.toString();
    }

    public String VisibleColumnSizePattern() {
        return "^CHAR|^NCHAR|^VARCHAR.*|^NVARCHAR.*|^NUMBER";
    }

    public String[] getSupportColumnType() {
        return new String[]{"CHAR", "VARCHAR2", "NUMBER", "DATE", "TIMESTAMP(6)", "FLOAT", "RAW", "NCHAR", "NVARCHAR2", "LONG", "CLOB", "BLOB", "BFILE", "RAW"};
    }

    public boolean supportsRemarks() {
        return true;
    }

    public boolean supportsModifyColumnType() {
        return true;
    }

    public boolean supportsModifyColumnSize(String columnType) {
        return this.isVisibleColumnSize(columnType);
    }

    public boolean supportsDropColumnCascadeConstraints() {
        return true;
    }

    public boolean supportsRollbackDDL() {
        return false;
    }

    public String createCommentOnTableDDL(String commnets) {
        StringBuffer sb = new StringBuffer();
        sb.append("COMMENT ON TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(" IS ");
        sb.append("'" + SQLUtil.encodeQuotation(commnets) + "'");
        return sb.toString();
    }

    public String createCommentOnColumnDDL(Column column) {
        StringBuffer sb = new StringBuffer();
        sb.append("COMMENT ON COLUMN ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(".");
        sb.append(SQLUtil.enclose(column.getName(), this.encloseChar));
        sb.append(" IS");
        sb.append(" '" + SQLUtil.encodeQuotation(column.getRemarks()) + "'");
        return sb.toString();
    }

    public String createRenameTableDDL(String newTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        sb.append(" RENAME TO ");
        sb.append(SQLUtil.enclose(newTableName, this.encloseChar));
        return sb.toString();
    }

    public String createRenameColumnDDL(Column from, Column to) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(" RENAME COLUMN ");
        sb.append(SQLUtil.enclose(from.getName(), this.encloseChar));
        sb.append(" TO ");
        sb.append(SQLUtil.enclose(to.getName(), this.encloseChar));
        return sb.toString();
    }

    public String[] createAddColumnDDL(Column column) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(" ADD (");
        sb.append(SQLUtil.enclose(column.getName(), this.encloseChar));
        sb.append(" ");
        sb.append(column.getTypeName());
        if (this.isVisibleColumnSize(column.getTypeName()) && !column.getColumn().isWithoutParam()) {
            sb.append("(");
            sb.append(column.getSize());
            sb.append(")");
        }
        if (column.getDefaultValue() != null && !"".equals(column.getDefaultValue())) {
            sb.append(" DEFAULT ");
            sb.append(SQLUtil.enclose(column.getDefaultValue(), this.encloseChar));
        }
        if (column.isNotNull()) {
            sb.append(" NOT NULL");
        } else {
            sb.append(" NULL");
        }
        sb.append(")");
        return new String[]{sb.toString()};
    }

    public String[] createModifyColumnDDL(Column from, Column to) {
        StringBuffer sb = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        StringBuffer sb3 = new StringBuffer();
        if (!from.getTypeName().equals(to.getTypeName()) || !from.getSize().equals(to.getSize())) {
            sb.append("ALTER TABLE ");
            sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
            sb.append(" MODIFY (");
            sb.append(SQLUtil.enclose(to.getName(), this.encloseChar));
            sb.append(" ");
            sb.append(to.getTypeName());
            if (this.isVisibleColumnSize(to.getTypeName()) && !to.getColumn().isWithoutParam()) {
                sb.append("(");
                sb.append(to.getSize());
                sb.append(")");
            }
            sb.append(")");
        }
        if (!from.getDefaultValue().equals(to.getDefaultValue())) {
            sb2.append("ALTER TABLE ");
            sb2.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
            sb2.append(" MODIFY (");
            sb2.append(SQLUtil.enclose(to.getName(), this.encloseChar));
            sb2.append(" ");
            sb2.append("DEFAULT ");
            if ("".equals(to.getDefaultValue())) {
                sb2.append("NULL");
            } else {
                sb2.append(SQLUtil.enclose(to.getDefaultValue(), this.encloseChar));
            }
            sb2.append(")");
        }
        if (from.isNotNull() != to.isNotNull()) {
            sb3.append("ALTER TABLE ");
            sb3.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
            sb3.append(" MODIFY (");
            sb3.append(SQLUtil.enclose(to.getName(), this.encloseChar));
            sb3.append(" ");
            if (to.isNotNull()) {
                sb3.append("NOT NULL");
            } else {
                sb3.append("NULL");
            }
            sb3.append(")");
        }
        return new String[]{sb.toString(), sb2.toString(), sb3.toString()};
    }

    public String[] createDropColumnDDL(Column column, boolean cascadeConstraints) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        sb.append(" DROP COLUMN ");
        sb.append(SQLUtil.enclose(column.getName(), this.encloseChar));
        if (cascadeConstraints) {
            sb.append(" CASCADE CONSTRAINTS");
        }
        return new String[]{sb.toString()};
    }

    public String createCreateIndexDDL(String indexName, Column[] columns, int indexType) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE");
        if (1 == indexType) {
            sb.append(" UNIQUE");
        } else if (2 == indexType) {
            sb.append(" BITMAP");
        }
        sb.append(" INDEX ");
        sb.append(SQLUtil.enclose(this.table.getSchemaName(), this.encloseChar));
        sb.append(".");
        sb.append(SQLUtil.enclose(indexName, this.encloseChar));
        sb.append(" ON ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(SQLUtil.enclose(column.getName(), this.encloseChar));
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String createDropIndexDDL(String indexName) {
        StringBuffer sb = new StringBuffer();
        sb.append("DROP INDEX ");
        sb.append(SQLUtil.enclose(this.table.getSchemaName(), this.encloseChar));
        sb.append(".");
        sb.append(SQLUtil.enclose(indexName, this.encloseChar));
        return sb.toString();
    }

    public String createCreateConstraintPKDDL(String constraintName, Column[] columns) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(" ADD CONSTRAINT ");
        sb.append(SQLUtil.enclose(constraintName, this.encloseChar));
        sb.append(" PRIMARY KEY");
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(SQLUtil.enclose(column.getColumn().getColumnName(), this.encloseChar));
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String createCreateConstraintUKDDL(String constraintName, Column[] columns) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(" ADD CONSTRAINT ");
        sb.append(SQLUtil.enclose(constraintName, this.encloseChar));
        sb.append(" UNIQUE ");
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(SQLUtil.enclose(column.getColumn().getColumnName(), this.encloseChar));
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String createCreateConstraintFKDDL(String constraintName, Column[] columns, ITable refTable, Column[] refColumns, boolean onDeleteCascade) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(" ADD CONSTRAINT ");
        sb.append(SQLUtil.enclose(constraintName, this.encloseChar));
        sb.append(" FOREIGN KEY");
        sb.append("(");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(SQLUtil.enclose(column.getColumn().getColumnName(), this.encloseChar));
            ++i;
        }
        sb.append(")");
        sb.append(" REFERENCES ");
        sb.append(this.getTableNameWithSchemaForSQL(refTable, this.isVisibleSchemaName));
        sb.append("(");
        i = 0;
        while (i < refColumns.length) {
            Column refColumn = refColumns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(SQLUtil.enclose(refColumn.getColumn().getColumnName(), this.encloseChar));
            ++i;
        }
        sb.append(")");
        if (onDeleteCascade) {
            sb.append(" ON DELETE CASCADE");
        }
        return sb.toString();
    }

    public String createCreateConstraintCheckDDL(String constraintName, String check) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(" ADD CONSTRAINT ");
        sb.append(SQLUtil.enclose(constraintName, this.encloseChar));
        sb.append(" CHECK");
        sb.append("(");
        sb.append(check);
        sb.append(")");
        return sb.toString();
    }

    public String createDropConstraintDDL(String constraintName, String type) {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        sb.append(" DROP CONSTRAINT ");
        sb.append(SQLUtil.enclose(constraintName, this.encloseChar));
        return sb.toString();
    }

    protected String getViewDDL_SQL(String dbName, String owner, String view) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT TEXT");
        sb.append(" FROM ALL_VIEWS");
        sb.append(" WHERE OWNER = '" + SQLUtil.enclose(owner, this.encloseChar) + "'");
        sb.append(" AND VIEW_NAME = '" + SQLUtil.enclose(view, this.encloseChar) + "'");
        return sb.toString();
    }
}

