/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.csv;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.csv.DefaultCsvMappingFactory;
import zigen.plugin.db.csv.ICsvMappingFactory;
import zigen.plugin.db.csv.OracleCsvMappingFactory;

public abstract class AbstractCsvMappingFactory
implements ICsvMappingFactory {
    protected SimpleDateFormat timeStampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected SimpleDateFormat timeStampFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected boolean convertUnicode;
    protected static final String NULL = "";
    protected String nullSymbol = DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol");
    protected boolean nonDoubleQuate;

    public static ICsvMappingFactory getFactory(IDBConfig config, boolean nonDoubleQuate) {
        return AbstractCsvMappingFactory.getFactory(config.getDriverName(), config.isConvertUnicode(), nonDoubleQuate);
    }

    public static ICsvMappingFactory getFactory(DatabaseMetaData objMet, boolean isConvertUnicode, boolean nonDoubleQuate) {
        try {
            return AbstractCsvMappingFactory.getFactory(objMet.getDriverName(), isConvertUnicode, nonDoubleQuate);
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("Failed get DriverName");
        }
    }

    public static ICsvMappingFactory getFactory(String driverName, boolean isConvertUnicode, boolean nonDoubleQuate) {
        switch (DBType.getType(driverName)) {
            case 1: {
                return new OracleCsvMappingFactory(isConvertUnicode, nonDoubleQuate);
            }
        }
        return new DefaultCsvMappingFactory(isConvertUnicode, nonDoubleQuate);
    }

    protected String convertLineSep(String value) {
        if (value != null && value.length() > 0) {
            if (value.indexOf("\r\n") != -1) {
                value = value.replaceAll("\r\n", "\\\\n");
            } else if (value.indexOf("\n") != -1) {
                value = value.replaceAll("\n", "\\\\n");
            } else if (value.indexOf("\r") != -1) {
                value = value.replaceAll("\r", "\\\\n");
            }
        }
        return value;
    }

    public abstract String getCsvValue(ResultSet var1, int var2) throws Exception;

    protected java.sql.Date toDate(String s) throws Exception {
        return java.sql.Date.valueOf(s);
    }

    protected Time toTime(String s) throws Exception {
        return Time.valueOf(s);
    }

    protected Timestamp toTimestamp(String str) throws Exception {
        SimpleDateFormat df = null;
        Date date = null;
        df = str.length() <= 10 ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        date = df.parse(str);
        return new Timestamp(date.getTime());
    }

    protected Timestamp toTimestamp2(String str) throws Exception {
        SimpleDateFormat df = null;
        Date date = null;
        df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        date = df.parse(str);
        return new Timestamp(date.getTime());
    }

    protected byte[] toBytes(Object obj) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
        bos.close();
        return bos.toByteArray();
    }

    protected String toBinary(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            String hx = Integer.toHexString(bytes[i] & 0xFF);
            String prefix = NULL;
            int j = hx.length();
            while (j < 2) {
                prefix = String.valueOf(prefix) + '0';
                ++j;
            }
            sb.append(prefix);
            sb.append(hx);
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    /*
     * Exception decompiling
     */
    protected byte[] toByteArray(InputStream is) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 93->96)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

