/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.tablespace;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleColumnSizeUtil;
import zigen.plugin.db.ext.oracle.internal.OracleDbBlockSizeSearcher;
import zigen.plugin.db.ext.oracle.internal.OracleTableColumnSearcher;
import zigen.plugin.db.ext.oracle.tablespace.CalcTableSpaceException;
import zigen.plugin.db.ext.oracle.tablespace.IColumn;
import zigen.plugin.db.ui.internal.Table;

public class CalcTableSpace {
    int block_header = 100;
    double safeCoefficient = 1.2;
    private final long maxRecord;
    private final Table table;
    private final String ownerName;
    private final String tableName;
    private final int pctFree;
    private int blockSize;
    private BigDecimal tableSpaceSize;
    private BigDecimal tableSpaceSafeSize;

    public BigDecimal getTableSpaceSafeSize() {
        return this.tableSpaceSafeSize;
    }

    public BigDecimal getTableSpaceSize() {
        return this.tableSpaceSize;
    }

    public CalcTableSpace(Table table, int pctFree, long maxRecord) {
        this.table = table;
        this.pctFree = pctFree;
        this.ownerName = table.getSchemaName();
        this.tableName = table.getName();
        this.maxRecord = maxRecord;
    }

    public CalcTableSpace(Table table, int blockSize, int pctFree, long maxRecord) {
        this.table = table;
        this.blockSize = blockSize;
        this.pctFree = pctFree;
        this.ownerName = table.getSchemaName();
        this.tableName = table.getName();
        this.maxRecord = maxRecord;
    }

    public void calcurate() throws CalcTableSpaceException {
        try {
            IDBConfig config = this.table.getDbConfig();
            Connection con = Transaction.getInstance(config).getConnection();
            if (this.blockSize == 0) {
                this.blockSize = OracleDbBlockSizeSearcher.execute(con);
            }
            double necessaryBlock = this.getNecessaryBlockSize(con, this.maxRecord);
            this.tableSpaceSize = new BigDecimal(necessaryBlock * (double)this.blockSize / 1048576.0);
            this.tableSpaceSize = this.tableSpaceSize.setScale(3, 0);
            this.tableSpaceSafeSize = this.tableSpaceSize.multiply(new BigDecimal(this.safeCoefficient));
            this.tableSpaceSafeSize = this.tableSpaceSafeSize.setScale(3, 0);
        }
        catch (CalcTableSpaceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CalcTableSpaceException("The error occurred by the estimate processing in the table area.", e.getCause());
        }
    }

    public int getBlockHeaderSize() {
        return this.block_header;
    }

    private final double getRiyouKanouArea() {
        double d = Math.ceil((double)(this.blockSize - this.getBlockHeaderSize()) * (1.0 - (double)this.pctFree / 100.0));
        return d;
    }

    private final int getRowLength(Connection con) {
        int columnAreaSize = -1;
        try {
            boolean convertUnicode = false;
            IColumn[] columns = OracleTableColumnSearcher.execute(con, this.table, convertUnicode);
            OracleColumnSizeUtil cs = new OracleColumnSizeUtil();
            columnAreaSize = cs.getRowLength(con, columns);
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
        return columnAreaSize;
    }

    private final double getAverageRowCountOfBlock(Connection con) throws CalcTableSpaceException {
        double rowLen;
        double d = 0.0;
        double riyoukanou = this.getRiyouKanouArea();
        d = riyoukanou >= (rowLen = (double)this.getRowLength(con)) ? Math.floor(riyoukanou / rowLen) : 1.0 / Math.ceil(rowLen / riyoukanou);
        return d;
    }

    private final double getNecessaryBlockSize(Connection con, long totalRow) throws CalcTableSpaceException {
        double d = Math.ceil((double)totalRow / this.getAverageRowCountOfBlock(con));
        return d;
    }

    public void setBlock_header(int block_header) {
        this.block_header = block_header;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public void setSafeCoefficient(double safeCoefficient) {
        this.safeCoefficient = safeCoefficient;
    }

    public double getSafeCoefficient() {
        return this.safeCoefficient;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public String getCalcResult() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(" [TABLE]:" + this.tableName + " ");
        sb.append("\n");
        sb.append("   TABLE SPACE:");
        sb.append("  " + this.getTableSpaceSize() + " MB");
        sb.append("\n");
        sb.append("   TABLE SPACE :" + this.getSafeCoefficient() + ":");
        sb.append("  " + this.getTableSpaceSafeSize() + " MB");
        sb.append("\n");
        return sb.toString();
    }

    public List getCsvRow() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.ownerName);
        list.add(this.tableName);
        list.add("");
        list.add(String.valueOf(this.blockSize));
        list.add(String.valueOf(this.pctFree));
        list.add(String.valueOf(this.maxRecord));
        list.add(String.valueOf(this.tableSpaceSize));
        list.add(String.valueOf(this.safeCoefficient));
        list.add(String.valueOf(this.tableSpaceSafeSize));
        return list;
    }

    public String csvString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.ownerName);
        sb.append(",");
        sb.append(this.tableName);
        sb.append(",");
        sb.append("");
        sb.append(",");
        sb.append(this.maxRecord);
        sb.append(",");
        sb.append(this.tableSpaceSize);
        sb.append(",");
        sb.append(this.safeCoefficient);
        sb.append(",");
        sb.append(this.tableSpaceSafeSize);
        sb.append("\n");
        return sb.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CalcTableSpace:");
        buffer.append(" block_header: ");
        buffer.append(this.block_header);
        buffer.append(" safeCoefficient: ");
        buffer.append(this.safeCoefficient);
        buffer.append(" maxRecord: ");
        buffer.append(this.maxRecord);
        buffer.append(" table: ");
        buffer.append(this.table);
        buffer.append(" ownerName: ");
        buffer.append(this.ownerName);
        buffer.append(" tableName: ");
        buffer.append(this.tableName);
        buffer.append(" pctFree: ");
        buffer.append(this.pctFree);
        buffer.append(" blockSize: ");
        buffer.append(this.blockSize);
        buffer.append(" tableSpaceSize: ");
        buffer.append(this.tableSpaceSize);
        buffer.append(" tableSpaceSafeSize: ");
        buffer.append(this.tableSpaceSafeSize);
        buffer.append("]");
        return buffer.toString();
    }
}

