/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.dialogs;

import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ColumnLayout;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.PatternUtil;
import zigen.plugin.db.core.SchemaInfo;
import zigen.plugin.db.core.SchemaSearcher;
import zigen.plugin.db.ui.actions.AutoDelayListener;
import zigen.plugin.db.ui.dialogs.DBConfigWizard;
import zigen.plugin.db.ui.dialogs.DefaultWizardPage;
import zigen.plugin.db.ui.dialogs.Messages;
import zigen.plugin.db.ui.dialogs.WizardPage2;
import zigen.plugin.db.ui.editors.event.TextSelectionListener;
import zigen.plugin.db.ui.util.WidgetUtil;

public class WizardPage3
extends DefaultWizardPage {
    public static final String MSG = Messages.getString("WizardPage3.0");
    Group symfowareOptionGrp;
    Text charsetText;
    Button unicodeCheck;
    Button commitModeCheck;
    Button symfowareOptionCheck;
    Composite container;
    Group group4;
    TreeMap settingSchemaMap = new TreeMap();
    SchemaInfo[] settingSchemas = null;
    SchemaInfo[] filterSchemas = null;
    private CheckboxTableViewer fTableViewer;
    private final String DISPLAY_TXT = Messages.getString("WizardPage3.12");
    private IDBConfig config = null;
    private Button selectedCheckOn = null;
    private Button selectedCheckOff = null;
    private Text filterText;
    private Button regularExpressions = null;
    private Button caseSensitive = null;
    private Button visibleCheck;
    boolean checkFilterPattern;
    String filterPattern = "";

    public WizardPage3(ISelection selection) {
        super(Messages.getString("WizardPage3.1"));
        this.setTitle(Messages.getString("WizardPage3.2"));
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        this.container = this.createDefaultComposite(parent);
        this.group4 = new Group(this.container, 0);
        this.group4.setText(Messages.getString("WizardPage3.6"));
        this.group4.setLayoutData((Object)new GridData(1808));
        this.group4.setLayout((Layout)new GridLayout(1, false));
        Group group3 = new Group(this.container, 0);
        group3.setText(Messages.getString("WizardPage3.5"));
        group3.setLayoutData((Object)new GridData(768));
        group3.setLayout((Layout)new GridLayout(1, false));
        this.addAutoCommitSection((Composite)group3);
        Group group1 = new Group(this.container, 0);
        group1.setText(Messages.getString("WizardPage3.3"));
        group1.setLayoutData((Object)new GridData(768));
        group1.setLayout((Layout)new GridLayout(1, false));
        this.addCharsetSection((Composite)group1);
        Group group2 = new Group(this.container, 0);
        group2.setText(Messages.getString("WizardPage3.4"));
        group2.setLayoutData((Object)new GridData(768));
        group2.setLayout((Layout)new GridLayout(1, false));
        this.addConvertUnicodeSection((Composite)group2);
        this.setControl((Control)this.container);
    }

    private void addCharsetSection(Composite group) {
        this.charsetText = new Text(group, 2052);
        this.charsetText.setLayoutData((Object)new GridData(768));
        this.charsetText.addFocusListener((FocusListener)new TextSelectionListener());
        if (this.getOldConfig() != null) {
            if (this.getOldConfig().getCharset() != null) {
                this.charsetText.setText(this.getOldConfig().getCharset());
            }
        } else {
            this.charsetText.setText(this.DEFAULT_CHARSET);
        }
    }

    private void addConvertUnicodeSection(Composite group) {
        this.unicodeCheck = new Button(group, 32);
        this.unicodeCheck.setText(Messages.getString("WizardPage3.8"));
        if (this.getOldConfig() != null) {
            this.unicodeCheck.setSelection(this.getOldConfig().isConvertUnicode());
        } else {
            this.unicodeCheck.setSelection(this.DEFAULT_CONVERTUNICODE);
        }
    }

    private void addAutoCommitSection(Composite group) {
        this.commitModeCheck = new Button(group, 32);
        this.commitModeCheck.setText(Messages.getString("WizardPage3.9"));
        if (this.getOldConfig() != null) {
            this.commitModeCheck.setSelection(this.getOldConfig().isAutoCommit());
        } else {
            this.commitModeCheck.setSelection(this.DEFAULT_AUTOCOMMIT);
        }
    }

    private void addNoLockModeSection(Composite group) {
        this.symfowareOptionCheck = new Button(group, 32);
        this.symfowareOptionCheck.setText(Messages.getString("WizardPage3.11"));
        this.symfowareOptionCheck.setSelection(true);
        if (this.getOldConfig() != null) {
            this.symfowareOptionCheck.setSelection(this.getOldConfig().isNoLockMode());
        } else {
            this.symfowareOptionCheck.setSelection(this.DEFAULT_NO_LOCK_MODE);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setDescription(MSG);
            DBConfigWizard wiz = (DBConfigWizard)this.getWizard();
            IWizardPage page = wiz.getPreviousPage((IWizardPage)this);
            if (page instanceof WizardPage2) {
                WizardPage2 page2 = (WizardPage2)page;
                page2.searchDriverFlg = false;
                String driver = page2.driverCombox.getText();
                if (driver != null && !"".equals(driver)) {
                    try {
                        if (DBType.getType(driver) == 3 && this.symfowareOptionGrp == null) {
                            this.symfowareOptionGrp = new Group(this.container, 0);
                            this.symfowareOptionGrp.setText(Messages.getString("WizardPage3.7"));
                            this.symfowareOptionGrp.setLayoutData((Object)new GridData(768));
                            this.symfowareOptionGrp.setLayout((Layout)new GridLayout(1, false));
                            this.addNoLockModeSection((Composite)this.symfowareOptionGrp);
                            this.resize();
                        }
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                if (this.getOldConfig() != null) {
                    this.settingSchemas = this.getOldConfig().getDisplayedSchemas();
                    if (this.settingSchemas != null) {
                        int i = 0;
                        while (i < this.settingSchemas.length) {
                            SchemaInfo info = this.settingSchemas[i];
                            this.settingSchemaMap.put(info.getName(), info);
                            ++i;
                        }
                    }
                }
                this.filterSchemas = this.loadSchemas();
                if (this.fTableViewer == null) {
                    this.addSchemaFilterSection((Composite)this.group4);
                    this.resize();
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    private void addSchemaFilterSection(Composite group) {
        Composite innerPanel1 = new Composite(group, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        innerPanel1.setLayout((Layout)gridLayout);
        innerPanel1.setLayoutData((Object)new GridData(1808));
        this.visibleCheck = new Button(innerPanel1, 32);
        this.visibleCheck.setText(Messages.getString("WizardPage3.21"));
        this.visibleCheck.setSelection(false);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.visibleCheck.setLayoutData((Object)data);
        this.visibleCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardPage3.this.checkFilterPattern = WizardPage3.this.visibleCheck.getSelection();
                if (WizardPage3.this.checkFilterPattern) {
                    WizardPage3.this.filter(WizardPage3.this.filterText.getText());
                } else {
                    WizardPage3.this.filter("");
                }
                WizardPage3.this.setEnabled(WizardPage3.this.checkFilterPattern);
            }
        });
        this.filterText = new Text(innerPanel1, 2052);
        this.filterText.setEnabled(false);
        this.filterText.addFocusListener((FocusListener)new TextSelectionListener());
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.filterText.setLayoutData((Object)data);
        final Label label = new Label(innerPanel1, 0);
        label.setText(Messages.getString("WizardPage3.23"));
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        Composite innerPanel3 = new Composite(group, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        innerPanel3.setLayout((Layout)gridLayout);
        data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 3;
        innerPanel3.setLayoutData((Object)data);
        this.regularExpressions = new Button(innerPanel3, 32);
        this.regularExpressions.setEnabled(false);
        this.regularExpressions.setText(Messages.getString("WizardPage3.14"));
        this.regularExpressions.setSelection(false);
        data = new GridData();
        data.horizontalAlignment = 3;
        this.regularExpressions.setLayoutData((Object)data);
        this.regularExpressions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                label.setVisible(!WizardPage3.this.regularExpressions.getSelection());
            }
        });
        this.caseSensitive = new Button(innerPanel3, 32);
        this.caseSensitive.setEnabled(false);
        this.caseSensitive.setText(Messages.getString("WizardPage3.15"));
        this.caseSensitive.setSelection(false);
        data = new GridData();
        data.horizontalAlignment = 3;
        this.caseSensitive.setLayoutData((Object)data);
        Composite innerPanel2 = new Composite(group, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        innerPanel2.setLayout((Layout)gridLayout);
        innerPanel2.setLayoutData((Object)new GridData(1808));
        Composite tableComposite = new Composite(innerPanel2, 0);
        data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = 120;
        tableComposite.setLayoutData((Object)data);
        ColumnLayout columnLayout = new ColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        Table table = new Table(tableComposite, 2850);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GC gc = new GC((Drawable)this.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(this.DISPLAY_TXT);
        int minWidth = this.computeMinimumColumnWidth(gc, this.DISPLAY_TXT);
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, minWidth, true));
        gc.dispose();
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new SchemaLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new SchemaContentProvider());
        this.fTableViewer.setInput((Object)this.filterSchemas);
        if (this.filterSchemas != null) {
            int i = 0;
            while (i < this.filterSchemas.length) {
                SchemaInfo info = this.filterSchemas[i];
                this.fTableViewer.setChecked((Object)info, info.isChecked());
                ++i;
            }
        }
        Composite buttonComposite = new Composite(tableComposite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(768);
        data.minimumHeight = 0;
        data.minimumWidth = 0;
        data.horizontalIndent = 0;
        data.verticalIndent = 0;
        buttonComposite.setLayoutData((Object)data);
        Composite buttons = new Composite(innerPanel2, 0);
        buttons.setLayoutData((Object)new GridData(2));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        this.selectedCheckOn = WidgetUtil.createButton(buttons, 8, Messages.getString("WizardPage3.16"), this.BUTTON_WIDTH2, new GridData());
        this.selectedCheckOn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < WizardPage3.this.fTableViewer.getTable().getItemCount()) {
                    SchemaInfo schema = (SchemaInfo)WizardPage3.this.fTableViewer.getElementAt(i);
                    schema.setChecked(true);
                    WizardPage3.this.fTableViewer.setChecked((Object)schema, true);
                    ++i;
                }
            }
        });
        this.selectedCheckOff = WidgetUtil.createButton(buttons, 8, Messages.getString("WizardPage3.17"), this.BUTTON_WIDTH2, new GridData());
        this.selectedCheckOff.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < WizardPage3.this.fTableViewer.getTable().getItemCount()) {
                    SchemaInfo schema = (SchemaInfo)WizardPage3.this.fTableViewer.getElementAt(i);
                    schema.setChecked(false);
                    WizardPage3.this.fTableViewer.setChecked((Object)schema, false);
                    ++i;
                }
            }
        });
        Button onlyDefaultSchema = WidgetUtil.createButton(buttons, 8, Messages.getString("WizardPage3.18"), this.BUTTON_WIDTH2, new GridData());
        onlyDefaultSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardPage3.this.config = ((DBConfigWizard)WizardPage3.this.getWizard()).createNewConfig();
                int i = 0;
                while (i < WizardPage3.this.filterSchemas.length) {
                    SchemaInfo info = WizardPage3.this.filterSchemas[i];
                    if (info.getName().equalsIgnoreCase(WizardPage3.this.config.getSchema())) {
                        info.setChecked(true);
                    } else {
                        info.setChecked(false);
                    }
                    WizardPage3.this.fTableViewer.setChecked((Object)info, info.isChecked());
                    ++i;
                }
                WizardPage3.this.fTableViewer.setInput((Object)WizardPage3.this.filterSchemas);
            }
        });
        Button reload = WidgetUtil.createButton(buttons, 8, Messages.getString("WizardPage3.19"), this.BUTTON_WIDTH2, new GridData());
        reload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardPage3.this.config = ((DBConfigWizard)WizardPage3.this.getWizard()).createNewConfig();
                WizardPage3.this.filterSchemas = WizardPage3.this.loadSchemas();
                WizardPage3.this.fTableViewer.setInput((Object)WizardPage3.this.filterSchemas);
            }
        });
        this.filterText.addKeyListener((KeyListener)new FilterListener());
        this.regularExpressions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.caseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SchemaInfo schema = (SchemaInfo)event.getElement();
                schema.setChecked(event.getChecked());
            }
        });
        this.filterText.setText(this.filterPattern);
        this.visibleCheck.setSelection(this.checkFilterPattern);
        this.setEnabled(this.checkFilterPattern);
    }

    private void setEnabled(boolean b) {
        this.filterText.setEnabled(b);
        this.regularExpressions.setEnabled(b);
        this.caseSensitive.setEnabled(b);
    }

    private void filter(String condition) {
        int i = 0;
        while (i < this.fTableViewer.getTable().getItemCount()) {
            SchemaInfo info = (SchemaInfo)this.fTableViewer.getElementAt(i);
            info.setChecked(this.filter(info, condition));
            this.fTableViewer.setChecked((Object)info, info.isChecked());
            ++i;
        }
        this.fTableViewer.refresh();
    }

    boolean filter(SchemaInfo info, String text) {
        if (text != null && !"".equals(text)) {
            String name = info.getName();
            if (this.regularExpressions.getSelection()) {
                try {
                    Pattern pattern = null;
                    pattern = !this.caseSensitive.getSelection() ? Pattern.compile(text, 2) : Pattern.compile(text);
                    Matcher mc = pattern.matcher(name);
                    return mc.matches();
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
            }
            if (text != null && text.trim().length() > 0) {
                try {
                    Pattern pattern = PatternUtil.getPattern(text, this.caseSensitive.getSelection());
                    Matcher mc = pattern.matcher(name);
                    return mc.matches();
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private SchemaInfo[] loadSchemas() {
        SchemaInfo[] schemas = null;
        boolean isSetting = !this.settingSchemaMap.isEmpty();
        try {
            this.config = ((DBConfigWizard)this.getWizard()).createNewConfig();
            String[] names = SchemaSearcher.execute(this.config);
            if (!isSetting) {
                schemas = new SchemaInfo[names.length];
                int i = 0;
                while (i < names.length) {
                    schemas[i] = new SchemaInfo(this.config, names[i], true);
                    ++i;
                }
            } else {
                schemas = new SchemaInfo[names.length];
                int i = 0;
                while (i < names.length) {
                    SchemaInfo info;
                    schemas[i] = this.settingSchemaMap.containsKey(names[i]) ? ((info = (SchemaInfo)this.settingSchemaMap.get(names[i])).isChecked() ? new SchemaInfo(this.config, names[i], true) : new SchemaInfo(this.config, names[i], false)) : new SchemaInfo(this.config, names[i], false);
                    ++i;
                }
            }
            return schemas;
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer(Messages.getString("WizardPage3.20"));
            sb.append("\n").append(e.getMessage());
            super.setMessage(sb.toString(), 3);
            return this.settingSchemas;
        }
    }

    class FilterListener
    extends AutoDelayListener {
        private static final int delayTime = 300;

        public FilterListener() {
            super(300);
        }

        public Runnable createExecutAction() {
            return new Runnable(this){
                final /* synthetic */ FilterListener this$1;
                {
                    this.this$1 = filterListener;
                }

                public void run() {
                    try {
                        FilterListener.access$0((FilterListener)this.this$1).filterPattern = WizardPage3.access$0(FilterListener.access$0(this.this$1)).getText();
                        WizardPage3.access$1(FilterListener.access$0(this.this$1), FilterListener.access$0((FilterListener)this.this$1).filterPattern);
                    }
                    catch (Exception e) {
                        DbPlugin.log(e);
                    }
                }
            };
        }

        static /* synthetic */ WizardPage3 access$0(FilterListener filterListener) {
            return filterListener.WizardPage3.this;
        }
    }

    class SchemaContentProvider
    implements IStructuredContentProvider {
        SchemaContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof SchemaInfo[]) {
                return (SchemaInfo[])input;
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class SchemaLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        SchemaLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SchemaInfo data = (SchemaInfo)element;
            switch (columnIndex) {
                case 0: {
                    return data.getName();
                }
            }
            return "";
        }
    }
}

