/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.Connection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSourceTypeSearcher;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.OracleSource;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.jobs.RefreshTreeNodeAction;

public class SourceTypeSearchJob
extends AbstractJob {
    private TreeViewer viewer;
    private Schema schema;

    public SourceTypeSearchJob(TreeViewer viewer, Schema schema) {
        super(Messages.getString("SourceTypeSearchJob.0"));
        this.viewer = viewer;
        this.schema = schema;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            Connection con = Transaction.getInstance(this.schema.getDbConfig()).getConnection();
            this.schema.removeChildAll();
            this.showResults(new RefreshTreeNodeAction(this.viewer, this.schema));
            String owner = this.schema.getName();
            String[] sourceTypes = OracleSourceTypeSearcher.execute(con, owner);
            this.schema.setSourceType(sourceTypes);
            int i = 0;
            while (i < sourceTypes.length) {
                String stype = sourceTypes[i];
                Folder folder = new Folder(stype);
                OracleSource source = new OracleSource();
                source.setName(DbPluginConstant.TREE_LEAF_LOADING);
                folder.addChild(source);
                this.schema.addChild(folder);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                ++i;
            }
            this.showResults(new RefreshTreeNodeAction(this.viewer, this.schema, 1));
        }
        catch (Exception e) {
            this.showErrorMessage(Messages.getString("SourceTypeSearchJob.1"), e);
        }
        return Status.OK_STATUS;
    }
}

