/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import zigen.plugin.db.core.FolderInfo;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.TreeLeaf;

public class FolderFilter
extends ViewerFilter {
    FolderInfo[] infos;
    Pattern pattern;

    public FolderFilter(FolderInfo[] infos) {
        this.infos = infos;
        this.createPattern();
    }

    private void createPattern() {
        try {
            StringBuffer sb = new StringBuffer();
            int cnt = 0;
            int i = 0;
            while (i < this.infos.length) {
                FolderInfo info = this.infos[i];
                if (info.isChecked()) {
                    if (cnt == 0) {
                        sb.append(info.getName());
                    } else {
                        sb.append("|");
                        sb.append(info.getName());
                    }
                    ++cnt;
                }
                ++i;
            }
            this.pattern = Pattern.compile(sb.toString());
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (this.infos != null) {
            if (element instanceof Folder) {
                TreeLeaf leaf = (TreeLeaf)element;
                if (this.pattern != null) {
                    Matcher mc = this.pattern.matcher(leaf.getName());
                    return !mc.matches();
                }
                return true;
            }
            return true;
        }
        return true;
    }
}

