/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule.mysql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.JDBCUnicodeConvertor;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.rule.DefaultColumnSearcherFactory;

public class MySQLColumnSearcharFactory
extends DefaultColumnSearcherFactory {
    static Map typeMap = new TreeMap();

    static {
        typeMap.put("BIT", new Integer(-7));
        typeMap.put("TINYINT", new Integer(-6));
        typeMap.put("SMALLINT", new Integer(5));
        typeMap.put("MEDIUMINT", new Integer(4));
        typeMap.put("INT", new Integer(4));
        typeMap.put("INTEGER", new Integer(4));
        typeMap.put("BIGINT", new Integer(-5));
        typeMap.put("INT24", new Integer(4));
        typeMap.put("REAL", new Integer(8));
        typeMap.put("FLOAT", new Integer(7));
        typeMap.put("DECIMAL", new Integer(3));
        typeMap.put("NUMERIC", new Integer(3));
        typeMap.put("DOUBLE", new Integer(8));
        typeMap.put("CHAR", new Integer(1));
        typeMap.put("VARCHAR", new Integer(12));
        typeMap.put("DATE", new Integer(91));
        typeMap.put("TIME", new Integer(92));
        typeMap.put("YEAR", new Integer(91));
        typeMap.put("TIMESTAMP", new Integer(93));
        typeMap.put("DATETIME", new Integer(93));
        typeMap.put("TINYBLOB", new Integer(-2));
        typeMap.put("BLOB", new Integer(-4));
        typeMap.put("MEDIUMBLOB", new Integer(-4));
        typeMap.put("LONGBLOB", new Integer(-4));
        typeMap.put("TINYTEXT", new Integer(12));
        typeMap.put("TEXT", new Integer(-1));
        typeMap.put("MEDIUMTEXT", new Integer(-1));
        typeMap.put("LONGTEXT", new Integer(-1));
        typeMap.put("ENUM", new Integer(1));
        typeMap.put("SET", new Integer(1));
        typeMap.put("GEOMETRY", new Integer(-2));
    }

    public MySQLColumnSearcharFactory(DatabaseMetaData meta, boolean convertUnicode) {
        super(meta, convertUnicode);
    }

    private int getJavaType(String typeName) {
        String key = typeName.toUpperCase();
        if (typeMap.containsKey(key)) {
            Integer i = (Integer)typeMap.get(key);
            return i;
        }
        return 1111;
    }

    public TableColumn[] execute(Connection con, String schemaPattern, String tableName) throws Exception {
        Statement st;
        ResultSet rs;
        block7: {
            TableColumn[] tableColumnArray;
            ArrayList<TableColumn> list = new ArrayList<TableColumn>();
            rs = null;
            st = null;
            try {
                DatabaseMetaData objMet = con.getMetaData();
                if (DBType.getType(objMet) != 2 || objMet.getDatabaseMajorVersion() < 5) break block7;
                st = con.createStatement();
                rs = st.executeQuery(this.getColumnsSQL(schemaPattern, tableName));
                int seq = 1;
                while (rs.next()) {
                    TableColumn column = new TableColumn();
                    column.setSeq(seq);
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                    column.setTypeName(rs.getString("TYPE_NAME"));
                    column.setColumnSize(rs.getInt("COLUMN_SIZE"));
                    column.setDecimalDigits(rs.getInt("DECIMAL_DIGITS"));
                    column.setDefaultValue(rs.getString("COLUMN_DEF"));
                    column.setDataType(this.getJavaType(column.getTypeName()));
                    String remarks = rs.getString("REMARKS");
                    if (this.convertUnicode) {
                        remarks = JDBCUnicodeConvertor.convert(remarks);
                    }
                    column.setRemarks(remarks);
                    if (rs.getInt("NULLABLE") == 0) {
                        column.setNotNull(true);
                    } else {
                        column.setNotNull(false);
                    }
                    list.add(column);
                    ++seq;
                }
                tableColumnArray = list.toArray(new TableColumn[0]);
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                StatementUtil.close(st);
                ResultSetUtil.close(rs);
                throw throwable;
            }
            StatementUtil.close(st);
            ResultSetUtil.close(rs);
            return tableColumnArray;
        }
        TableColumn[] tableColumnArray = super.execute(con, schemaPattern, tableName);
        Object var11_14 = null;
        StatementUtil.close(st);
        ResultSetUtil.close(rs);
        return tableColumnArray;
    }

    private String getColumnsSQL(String schemaPattern, String tableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT");
        sb.append("        COLUMN_NAME");
        sb.append("        ,0 DATA_TYPE");
        sb.append("        ,CASE");
        sb.append("            WHEN LOCATE('unsigned', COLUMN_TYPE) != 0 AND LOCATE('unsigned', DATA_TYPE) = 0 THEN CONCAT(DATA_TYPE, ' unsigned')");
        sb.append("            ELSE DATA_TYPE");
        sb.append("        END AS TYPE_NAME");
        sb.append("        ,CASE");
        sb.append("            WHEN CHARACTER_MAXIMUM_LENGTH IS NULL THEN NUMERIC_PRECISION");
        sb.append("            ELSE CASE");
        sb.append("                WHEN CHARACTER_MAXIMUM_LENGTH > 2147483647 THEN 2147483647");
        sb.append("                ELSE CHARACTER_MAXIMUM_LENGTH");
        sb.append("            END");
        sb.append("        END AS COLUMN_SIZE");
        sb.append("        ,NUMERIC_SCALE AS DECIMAL_DIGITS");
        sb.append("        ,COLUMN_COMMENT AS REMARKS");
        sb.append("        ,CASE");
        sb.append("            WHEN IS_NULLABLE = 'NO' THEN 0");
        sb.append("            ELSE 1");
        sb.append("        END NULLABLE");
        sb.append("        ,COLUMN_DEFAULT AS COLUMN_DEF");
        sb.append("    FROM");
        sb.append("        information_schema.COLUMNS");
        sb.append("    WHERE");
        sb.append("        TABLE_SCHEMA = '" + SQLUtil.encodeQuotation(schemaPattern) + "'");
        sb.append("        AND TABLE_NAME = '" + SQLUtil.encodeQuotation(tableName) + "'");
        sb.append("    ORDER BY");
        sb.append("        TABLE_SCHEMA");
        sb.append("        ,TABLE_NAME");
        sb.append("        ,ORDINAL_POSITION");
        return sb.toString();
    }
}

