/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import zigen.plugin.db.core.PatternUtil;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.OracleSequence;
import zigen.plugin.db.ui.internal.OracleSource;
import zigen.plugin.db.ui.internal.Synonym;

public class TableFilter
extends ViewerFilter {
    boolean caseSensitive = false;
    String text;
    Pattern pattern;

    public TableFilter(String text) {
        this(text, false);
    }

    public TableFilter(String text, boolean canSensitive) {
        this.text = text;
        this.caseSensitive = canSensitive;
        this.createPattern();
    }

    private void createPattern() {
        try {
            this.pattern = PatternUtil.getPattern(this.text, this.caseSensitive);
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (this.text != null && !"".equals(this.text)) {
            if (element instanceof Bookmark) {
                return true;
            }
            if (element instanceof ITable) {
                try {
                    ITable table = (ITable)element;
                    Matcher mc = this.pattern.matcher(table.getName());
                    Matcher mc2 = this.pattern.matcher(table.getRemarks());
                    return mc.matches() || mc2.matches();
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
            }
            if (element instanceof Synonym) {
                try {
                    Synonym synonym = (Synonym)element;
                    Matcher mc = this.pattern.matcher(synonym.getName());
                    Matcher mc2 = this.pattern.matcher(synonym.getRemarks());
                    return mc.matches() || mc2.matches();
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
            }
            if (element instanceof OracleSequence) {
                try {
                    OracleSequence seq = (OracleSequence)element;
                    Matcher mc = this.pattern.matcher(seq.getName());
                    return mc.matches();
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
            }
            if (element instanceof OracleSource) {
                try {
                    OracleSource source = (OracleSource)element;
                    Matcher mc = this.pattern.matcher(source.getName());
                    return mc.matches();
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
            }
            return true;
        }
        return true;
    }
}

