/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.csv;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.InputStreamUtil;
import zigen.plugin.db.core.JDBCUnicodeConvertor;
import zigen.plugin.db.csv.AbstractCsvMappingFactory;
import zigen.plugin.db.csv.ICsvMappingFactory;
import zigen.plugin.db.csv.Messages;

public class DefaultCsvMappingFactory
extends AbstractCsvMappingFactory
implements ICsvMappingFactory {
    public DefaultCsvMappingFactory(boolean convertUnicode, boolean nonDoubleQuate) {
        this.convertUnicode = convertUnicode;
        this.nonDoubleQuate = nonDoubleQuate;
    }

    public String getCsvValue(ResultSet rs, int icol) throws SQLException {
        ResultSetMetaData rmd = rs.getMetaData();
        String obj = null;
        int type = rmd.getColumnType(icol);
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                obj = this.getString(rs, icol);
                break;
            }
            case -7: 
            case 16: {
                obj = this.getBoolean(rs, icol);
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                obj = this.getLong(rs, icol);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                obj = this.getDouble(rs, icol);
                break;
            }
            case 2: 
            case 3: {
                obj = this.getBigDecimal(rs, icol);
                break;
            }
            case 91: {
                obj = this.getDate(rs, icol);
                break;
            }
            case 92: {
                obj = this.getTime(rs, icol);
                break;
            }
            case 93: {
                obj = this.getTimestamp(rs, icol);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                obj = this.getBinary(rs, icol);
                break;
            }
            case 2005: {
                obj = this.getCLOB(rs, icol);
                break;
            }
            case 2004: {
                obj = this.getBLOB(rs, icol);
                break;
            }
            case 1111: {
                obj = this.getOTHER(rs, icol);
                break;
            }
            default: {
                obj = String.valueOf(Messages.getString("DefaultCsvMappingFactory.0")) + type + ")>>";
            }
        }
        return obj;
    }

    protected String getString(ResultSet rs, int icol) throws SQLException {
        String value = rs.getString(icol);
        if (rs.wasNull()) {
            return "";
        }
        if (this.convertUnicode) {
            value = JDBCUnicodeConvertor.convert(value);
        }
        value = this.convertLineSep(value);
        if (!this.nonDoubleQuate) {
            value = value.replaceAll("\"", "\"\"");
            return "\"" + value + "\"";
        }
        return value;
    }

    protected String getBoolean(ResultSet rs, int icol) throws SQLException {
        boolean value = rs.getBoolean(icol);
        if (rs.wasNull()) {
            return "";
        }
        if (!this.nonDoubleQuate) {
            return "\"" + String.valueOf(value) + "\"";
        }
        return String.valueOf(value);
    }

    protected String getBigDecimal(ResultSet rs, int icol) throws SQLException {
        BigDecimal value = rs.getBigDecimal(icol);
        if (rs.wasNull()) {
            return "";
        }
        return value.toString();
    }

    protected String getLong(ResultSet rs, int icol) throws SQLException {
        long value = rs.getLong(icol);
        if (rs.wasNull()) {
            return "";
        }
        return String.valueOf(value);
    }

    protected String getDouble(ResultSet rs, int icol) throws SQLException {
        double value = rs.getDouble(icol);
        if (rs.wasNull()) {
            return "";
        }
        return String.valueOf(value);
    }

    protected String getDate(ResultSet rs, int icol) throws SQLException {
        java.sql.Date value = rs.getDate(icol);
        if (rs.wasNull()) {
            return "";
        }
        String temp = this.dateFormat.format(value);
        if (!this.nonDoubleQuate) {
            return "\"" + temp + "\"";
        }
        return temp;
    }

    protected String getTime(ResultSet rs, int icol) throws SQLException {
        Time value = rs.getTime(icol);
        if (rs.wasNull()) {
            return "";
        }
        String temp = this.timeFormat.format(value);
        if (!this.nonDoubleQuate) {
            return "\"" + temp + "\"";
        }
        return temp;
    }

    protected String getTimestamp(ResultSet rs, int icol) throws SQLException {
        Timestamp value = rs.getTimestamp(icol);
        if (rs.wasNull()) {
            return "";
        }
        String temp = this.timeStampFormat.format(new Date(value.getTime()));
        if (!this.nonDoubleQuate) {
            return "\"" + temp + "\"";
        }
        return temp;
    }

    protected String getBinary(ResultSet rs, int icol) throws SQLException {
        String string;
        block15: {
            String temp;
            InputStream in;
            block12: {
                String string2;
                block13: {
                    block9: {
                        block10: {
                            in = null;
                            try {
                                in = rs.getBinaryStream(icol);
                                if (in != null) break block9;
                                Object var5_4 = null;
                                if (in == null) break block10;
                            }
                            catch (Throwable throwable) {
                                block17: {
                                    Object var5_7 = null;
                                    if (in == null) break block17;
                                    try {
                                        in.close();
                                    }
                                    catch (IOException e) {
                                        DbPlugin.log(e);
                                    }
                                    in = null;
                                }
                                throw throwable;
                            }
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                DbPlugin.log(e);
                            }
                            in = null;
                        }
                        return "";
                    }
                    temp = this.toBinary(this.toByteArray(in));
                    if (this.nonDoubleQuate) break block12;
                    string2 = "\"" + temp + "\"";
                    Object var5_5 = null;
                    if (in == null) break block13;
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        DbPlugin.log(e);
                    }
                    in = null;
                }
                return string2;
            }
            string = temp;
            Object var5_6 = null;
            if (in == null) break block15;
            try {
                in.close();
            }
            catch (IOException e) {
                DbPlugin.log(e);
            }
            in = null;
        }
        return string;
    }

    /*
     * Loose catch block
     */
    protected String getCLOB(ResultSet rs, int icol) throws SQLException {
        String string;
        InputStream in;
        block17: {
            String temp;
            block14: {
                String string2;
                block15: {
                    Clob clob;
                    block11: {
                        block12: {
                            in = null;
                            clob = rs.getClob(icol);
                            if (!rs.wasNull()) break block11;
                            Object var6_6 = null;
                            if (in == null) break block12;
                            try {
                                in.close();
                            }
                            catch (IOException e2) {
                                DbPlugin.log(e2);
                            }
                            in = null;
                        }
                        return "";
                    }
                    temp = InputStreamUtil.toString(clob.getCharacterStream());
                    if (this.nonDoubleQuate) break block14;
                    string2 = "\"" + temp + "\"";
                    Object var6_7 = null;
                    if (in == null) break block15;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        DbPlugin.log(e2);
                    }
                    in = null;
                }
                return string2;
            }
            string = temp;
            Object var6_8 = null;
            if (in == null) break block17;
            try {
                in.close();
            }
            catch (IOException e2) {
                DbPlugin.log(e2);
            }
            in = null;
        }
        return string;
        catch (IOException e) {
            try {
                throw new SQLException(e.getMessage());
            }
            catch (Throwable throwable) {
                block19: {
                    Object var6_9 = null;
                    if (in == null) break block19;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        DbPlugin.log(e2);
                    }
                    in = null;
                }
                throw throwable;
            }
        }
    }

    protected String getBLOB(ResultSet rs, int icol) throws SQLException {
        String string;
        block15: {
            String temp;
            InputStream in;
            block12: {
                String string2;
                block13: {
                    Blob blob;
                    block9: {
                        block10: {
                            in = null;
                            try {
                                blob = rs.getBlob(icol);
                                if (!rs.wasNull()) break block9;
                                Object var6_5 = null;
                                if (in == null) break block10;
                            }
                            catch (Throwable throwable) {
                                block17: {
                                    Object var6_8 = null;
                                    if (in == null) break block17;
                                    try {
                                        in.close();
                                    }
                                    catch (IOException e) {
                                        DbPlugin.log(e);
                                    }
                                    in = null;
                                }
                                throw throwable;
                            }
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                DbPlugin.log(e);
                            }
                            in = null;
                        }
                        return "";
                    }
                    in = new BufferedInputStream(blob.getBinaryStream());
                    temp = this.toBinary(this.toByteArray(in));
                    if (this.nonDoubleQuate) break block12;
                    string2 = "\"" + temp + "\"";
                    Object var6_6 = null;
                    if (in == null) break block13;
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        DbPlugin.log(e);
                    }
                    in = null;
                }
                return string2;
            }
            string = temp;
            Object var6_7 = null;
            if (in == null) break block15;
            try {
                in.close();
            }
            catch (IOException e) {
                DbPlugin.log(e);
            }
            in = null;
        }
        return string;
    }

    protected String getOTHER(ResultSet rs, int icol) throws SQLException {
        rs.getObject(icol);
        if (rs.wasNull()) {
            return "";
        }
        return "<<OTHER>>";
    }
}

