/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.preference;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.preference.Messages;
import zigen.plugin.db.preference.URLInputDialog;
import zigen.plugin.db.ui.util.WidgetUtil;

public class URLPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String P_URLDefine = "URLPreferencePage.URLDefine";
    public static final String SEP_ROWS = "|";
    public static final String SEP_COLS = ",";
    protected TableContentProvider contentProvider = new TableContentProvider();
    protected int BUTTON_WIDTH = 100;
    private List properties = null;
    private TableViewer tableViewer;
    private Button envEditButton;
    private Button envRemoveButton;
    protected String[] tableHeader = new String[]{Messages.getString("URLPreferencePage.0"), Messages.getString("URLPreferencePage.1")};
    protected ColumnLayoutData[] columnLayoutDatas = new ColumnLayoutData[]{new ColumnWeightData(1), new ColumnWeightData(1)};

    public void init(IWorkbench workbench) {
    }

    public URLPreferencePage() {
        String desc = String.valueOf(Messages.getString("URLPreferencePage.2")) + Messages.getString("URLPreferencePage.3");
        this.setDescription(desc);
        this.properties = this.getDefaultList();
        super.setPreferenceStore(DbPlugin.getDefault().getPreferenceStore());
    }

    public static List getURLTemplates() {
        URLPreferencePage page = new URLPreferencePage();
        return page.getDefaultList();
    }

    public List getDefaultList() {
        IPreferenceStore store = DbPlugin.getDefault().getPreferenceStore();
        String defaultString = store.getString(P_URLDefine);
        ArrayList<String[]> list = new ArrayList<String[]>();
        String[] wk = defaultString.split("[|]");
        int i = 0;
        while (i < wk.length) {
            list.add(wk[i].split("[,]"));
            ++i;
        }
        return list;
    }

    private void addProperty(String driver, String url) {
        String[] property = new String[]{driver, url};
        this.properties.add(property);
    }

    private void updateProperty(int index, String driver, String url) {
        String[] property = new String[]{driver, url};
        this.properties.set(index, property);
    }

    private void removeProperty(int index) {
        this.properties.remove(index);
    }

    private void saveProperties() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.properties.size()) {
            String[] wk = (String[])this.properties.get(i);
            int j = 0;
            while (j < wk.length) {
                if (j == 0) {
                    sb.append(wk[j]);
                } else {
                    sb.append(SEP_COLS + wk[j]);
                }
                ++j;
            }
            sb.append(SEP_ROWS);
            ++i;
        }
        this.getPreferenceStore().setValue(P_URLDefine, sb.toString());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setFont(font);
        this.createTable(composite);
        this.createButtons(composite);
        return composite;
    }

    private void createTable(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.widthHint = 400;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gridData);
        composite.setFont(font);
        this.tableViewer = new TableViewer(composite, 68354);
        Table table = this.tableViewer.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(font);
        gridData = new GridData(1808);
        this.tableViewer.getControl().setLayoutData((Object)gridData);
        int i = 0;
        while (i < this.tableHeader.length) {
            tableLayout.addColumnData(this.columnLayoutDatas[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(this.columnLayoutDatas[i].resizable);
            tc.setText(this.tableHeader[i]);
            ++i;
        }
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setInput((Object)this.properties);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                URLPreferencePage.this.tableSelectionChangedHandler(event);
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!URLPreferencePage.this.tableViewer.getSelection().isEmpty()) {
                    URLPreferencePage.this.editButtonPressedHandler();
                }
            }
        });
    }

    private void createButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.numColumns = 1;
        GridData gdata = new GridData(2);
        buttonComposite.setLayout((Layout)glayout);
        buttonComposite.setLayoutData((Object)gdata);
        buttonComposite.setFont(parent.getFont());
        Button envAddButton = WidgetUtil.createButton(buttonComposite, 8, Messages.getString("URLPreferencePage.4"), this.BUTTON_WIDTH, new GridData());
        envAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                URLPreferencePage.this.addButtonPressedHandler();
            }
        });
        this.envEditButton = WidgetUtil.createButton(buttonComposite, 8, Messages.getString("URLPreferencePage.5"), this.BUTTON_WIDTH, new GridData());
        this.envEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                URLPreferencePage.this.editButtonPressedHandler();
            }
        });
        this.envEditButton.setEnabled(false);
        this.envRemoveButton = WidgetUtil.createButton(buttonComposite, 8, Messages.getString("URLPreferencePage.6"), this.BUTTON_WIDTH, new GridData());
        this.envRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                URLPreferencePage.this.removeButtonPressedHandler();
            }
        });
        this.envRemoveButton.setEnabled(false);
    }

    protected void tableSelectionChangedHandler(SelectionChangedEvent event) {
        int size = ((IStructuredSelection)event.getSelection()).size();
        this.envEditButton.setEnabled(size == 1);
        this.envRemoveButton.setEnabled(size > 0);
    }

    private void addButtonPressedHandler() {
        URLInputDialog dialog = new URLInputDialog(this.getShell());
        if (dialog.open() != 0) {
            return;
        }
        this.addProperty(dialog.getStringValue("driver"), dialog.getStringValue("url"));
        this.tableViewer.setInput((Object)this.properties);
        this.tableViewer.refresh();
    }

    private void editButtonPressedHandler() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        String[] strs = (String[])selection.getFirstElement();
        URLInputDialog dialog = new URLInputDialog(this.getShell());
        dialog.setStringValue("driver", strs[0]);
        dialog.setStringValue("url", strs[1]);
        if (dialog.open() != 0) {
            return;
        }
        this.updateProperty(this.tableViewer.getTable().getSelectionIndex(), dialog.getStringValue("driver"), dialog.getStringValue("url"));
        this.tableViewer.setInput((Object)this.properties);
        this.tableViewer.refresh();
    }

    private void removeButtonPressedHandler() {
        this.removeProperty(this.tableViewer.getTable().getSelectionIndex());
        this.tableViewer.setInput((Object)this.properties);
        this.tableViewer.refresh();
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        this.saveProperties();
        return super.performOk();
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private List contents = null;

        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List list = (List)inputElement;
                return list.toArray();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.contents = newInput instanceof List ? (List)newInput : null;
        }

        public void dispose() {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String[]) {
                String[] list = (String[])element;
                if (columnIndex < list.length) {
                    return list[columnIndex];
                }
                return "";
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

