/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.util.ArrayList;
import java.util.Collections;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBConfig;
import zigen.plugin.db.core.DBConfigSorter;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Messages;
import zigen.plugin.db.core.SameDbNameException;
import zigen.plugin.db.ui.dialogs.IDBDialogSettings;

public class DBConfigManager {
    private static IDBDialogSettings setting = DbPlugin.getDefault().getDBDialogSettings();
    public static final String KEY_DBNAME = "NAME";
    public static final String KEY_DRIVER = "DRIVER";
    public static final String KEY_URL = "URL";
    public static final String KEY_USERID = "USERID";
    public static final String KEY_SCHEMA = "SCHEMA";
    public static final String KEY_PASS = "PASSWORD";
    public static final String KEY_CLASSPATH = "CLASSPATH";
    public static final String KEY_CHARSET = "CHARSET";
    public static final String KEY_CONVUNICODE = "CONVUNICODE";
    public static final String KEY_AUTOCOMMIT = "AUTOCOMMIT";
    public static final String KEY_ONLYDEFAULTSCHEMA = "ONLYDEFAULTSCHEMA";
    public static final String KEY_JDBC_TYPE = "JDBCTYPE";
    public static final String KEY_NO_LOCK_MODE = "NOLOCKMODE";
    public static final String KEY_CONNECT_AS_SYSDBA = "CONNECT_AS_SYSDBA";
    public static final String KEY_CONNECT_AS_SYSOPEA = "CONNECT_AS_SYSOPEA";
    public static final String KEY_CONNECT_AS_INFORMATION_SCHEMA = "CONNECT_AS_INFORMATION_SCHEMA";
    public static final String KEY_DISPLAYED_SCHEMAS = "KEY_DISPLAYED_SCHEMAS";
    public static final String KEY_IS_FILTER_PATTERN = "KEY_IS_FILTER_PATTERN";
    public static final String KEY_FILTER_PATTERN = "KEY_FILTER_PATTERN";

    public static IDBConfig[] getDBConfigs() {
        IDBDialogSettings[] sections = setting.getSections();
        ArrayList<DBConfig> list = new ArrayList<DBConfig>(sections.length);
        DBConfig[] cfr_ignored_0 = new DBConfig[sections.length];
        int i = 0;
        while (i < sections.length) {
            IDBDialogSettings settings = sections[i];
            DBConfig config = new DBConfig();
            config.setDbName(settings.get(KEY_DBNAME));
            config.setDriverName(settings.get(KEY_DRIVER));
            config.setUrl(settings.get(KEY_URL));
            config.setUserId(settings.get(KEY_USERID));
            config.setSchema(settings.get(KEY_SCHEMA));
            config.setPassword(settings.get(KEY_PASS));
            config.setClassPaths(settings.getArray(KEY_CLASSPATH));
            config.setCharset(settings.get(KEY_CHARSET));
            config.setConvertUnicode(settings.getBoolean(KEY_CONVUNICODE));
            config.setAutoCommit(settings.getBoolean(KEY_AUTOCOMMIT));
            settings.getBoolean(KEY_ONLYDEFAULTSCHEMA);
            config.setOnlyDefaultSchema(settings.getBoolean(KEY_ONLYDEFAULTSCHEMA));
            try {
                config.setJdbcType(settings.getInt(KEY_JDBC_TYPE));
            }
            catch (NumberFormatException numberFormatException) {
                config.setJdbcType(4);
            }
            config.setNoLockMode(settings.getBoolean(KEY_NO_LOCK_MODE));
            config.setConnectAsSYSDBA(settings.getBoolean(KEY_CONNECT_AS_SYSDBA));
            config.setConnectAsSYSOPER(settings.getBoolean(KEY_CONNECT_AS_SYSOPEA));
            config.setConnectAsInformationSchema(settings.getBoolean(KEY_CONNECT_AS_INFORMATION_SCHEMA));
            config.setDisplayedSchemas(settings.getSchemaInfos(KEY_DISPLAYED_SCHEMAS));
            config.setCheckFilterPattern(settings.getBoolean(KEY_IS_FILTER_PATTERN));
            config.setFilterPattern(settings.get(KEY_FILTER_PATTERN));
            list.add(config);
            ++i;
        }
        Collections.sort(list, new DBConfigSorter());
        return list.toArray(new DBConfig[0]);
    }

    public static void save(IDBConfig config) throws SameDbNameException {
        if (setting.hasSection(config.getDbName())) {
            throw new SameDbNameException(Messages.getString("DBConfigManager.13"));
        }
        IDBDialogSettings section = setting.addNewSection(config.getDbName());
        DBConfigManager.setDBConfig(section, config);
        setting.addSection(section);
    }

    public static void modify(IDBConfig oldConfig, IDBConfig newConfig) throws SameDbNameException {
        if (oldConfig.getDbName().equals(newConfig.getDbName())) {
            IDBDialogSettings section = setting.getSection(newConfig.getDbName());
            DBConfigManager.setDBConfig(section, newConfig);
        } else if (!DBConfigManager.hasSection(newConfig.getDbName())) {
            IDBDialogSettings section = setting.addNewSection(newConfig.getDbName());
            DBConfigManager.setDBConfig(section, newConfig);
            setting.addSection(section);
            setting.removeSection(oldConfig.getDbName());
        } else {
            throw new SameDbNameException(Messages.getString("DBConfigManager.13"));
        }
    }

    public static void setAutoCommit(IDBConfig oldConfig, boolean isAutoCommit) {
        IDBDialogSettings section = setting.getSection(oldConfig.getDbName());
        if (section != null) {
            section.put(KEY_AUTOCOMMIT, isAutoCommit);
        }
    }

    public static boolean hasSection(String dbName) {
        return setting.hasSection(dbName);
    }

    public static void remove(IDBConfig config) {
        setting.removeSection(config.getDbName());
    }

    private static void setDBConfig(IDBDialogSettings section, IDBConfig config) {
        if (section == null) {
            throw new IllegalStateException("IDBDialogSetting is NULL");
        }
        section.put(KEY_DBNAME, config.getDbName());
        section.put(KEY_DRIVER, config.getDriverName());
        section.put(KEY_URL, config.getUrl());
        section.put(KEY_USERID, config.getUserId());
        section.put(KEY_SCHEMA, config.getSchema());
        section.put(KEY_PASS, config.getPassword());
        section.put(KEY_CLASSPATH, config.getClassPaths());
        section.put(KEY_CHARSET, config.getCharset());
        section.put(KEY_CONVUNICODE, config.isConvertUnicode());
        section.put(KEY_AUTOCOMMIT, config.isAutoCommit());
        section.put(KEY_ONLYDEFAULTSCHEMA, config.isOnlyDefaultSchema());
        section.put(KEY_JDBC_TYPE, config.getJdbcType());
        section.put(KEY_NO_LOCK_MODE, config.isNoLockMode());
        section.put(KEY_CONNECT_AS_SYSDBA, config.isConnectAsSYSDBA());
        section.put(KEY_CONNECT_AS_SYSOPEA, config.isConnectAsSYSOPER());
        section.put(KEY_CONNECT_AS_INFORMATION_SCHEMA, config.isConnectAsInformationSchema());
        section.put(KEY_DISPLAYED_SCHEMAS, config.getDisplayedSchemas());
        section.put(KEY_IS_FILTER_PATTERN, config.isCheckFilterPattern());
        section.put(KEY_FILTER_PATTERN, config.getFilterPattern());
    }

    public static IDBConfig getDBConfig(String dbName) {
        IDBConfig[] configs = DBConfigManager.getDBConfigs();
        int i = 0;
        while (i < configs.length) {
            IDBConfig config = configs[i];
            if (config.getDbName().equals(dbName)) {
                return config;
            }
            ++i;
        }
        return null;
    }
}

