/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class TabTokenizer
implements Enumeration {
    public static final String DEMILITER = "\t";
    public static final char QUOTE = '\"';
    private String text;
    private int currentPosition;
    private int maxPosition;

    public TabTokenizer(String str) {
        this.text = str;
        this.currentPosition = 0;
        this.maxPosition = this.text.length();
    }

    private int nextDemiliter(int i) {
        boolean flg = false;
        while (i < this.maxPosition) {
            char ch = this.text.charAt(i);
            int pos = -1;
            pos = this.text.indexOf(DEMILITER, i);
            if (!flg && pos == i) break;
            if ('\"' == ch) {
                flg = !flg;
            }
            ++i;
        }
        return i;
    }

    public int getTokenCount() {
        int i = 0;
        int ret = 1;
        while ((i = this.nextDemiliter(i)) < this.maxPosition) {
            ++i;
            ++ret;
        }
        return ret;
    }

    public String nextToken() {
        if (this.currentPosition > this.maxPosition) {
            throw new NoSuchElementException(this.toString());
        }
        int start = this.currentPosition;
        this.currentPosition = this.nextDemiliter(this.currentPosition);
        StringBuffer sb = new StringBuffer();
        while (start < this.currentPosition) {
            char ch = this.text.charAt(start++);
            sb.append(ch);
        }
        this.currentPosition += DEMILITER.length();
        String out = sb.toString();
        if (out.length() == 0) {
            return null;
        }
        return out;
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.nextDemiliter(this.currentPosition) <= this.maxPosition;
    }
}

