/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule;

import java.sql.SQLException;
import zigen.plugin.db.core.JDBCUnicodeConvertor;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.rule.AbstractStatementFactory;
import zigen.plugin.db.core.rule.IStatementFactory;

public class DefaultStatementFactory
extends AbstractStatementFactory
implements IStatementFactory {
    protected String nullSymbol = SQLUtil.getNullSymbol();

    protected DefaultStatementFactory(boolean convertUnicode) {
        this.convertUnicode = convertUnicode;
    }

    public String getString(int DataType, Object value) throws SQLException {
        if (value.equals(this.nullSymbol)) {
            value = null;
        }
        String data = null;
        switch (DataType) {
            case -1: 
            case 1: 
            case 12: {
                data = this.getString(value);
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                data = this.getNumeric(value);
                break;
            }
            case 91: {
                data = this.getDate(value);
                break;
            }
            case 93: {
                data = this.getTimestamp(value);
                break;
            }
            case -7: 
            case 16: {
                data = this.getBoolean(value);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                if (value == null) {
                    return NULL;
                }
                data = "<<BINARY>>";
                break;
            }
            case 2005: {
                data = "<<CLOB>>";
                break;
            }
            case 2004: {
                data = "<<BLOB>>";
                break;
            }
            case 1111: {
                data = "<<OTHER>>";
                break;
            }
            default: {
                data = "<<UNKNOWN>>";
            }
        }
        return data;
    }

    protected String getString(Object value) throws SQLException {
        if (value == null) {
            return NULL;
        }
        String data = String.valueOf(value);
        if (this.convertUnicode) {
            data = JDBCUnicodeConvertor.convert(data);
        }
        return "'" + data + "'";
    }

    protected String getNumeric(Object value) throws SQLException {
        if (value == null) {
            return NULL;
        }
        return String.valueOf(value);
    }

    protected String getBoolean(Object value) throws SQLException {
        if (value == null) {
            return NULL;
        }
        return String.valueOf(value);
    }

    protected String getDate(Object value) throws SQLException {
        if (value == null) {
            return NULL;
        }
        return "'" + String.valueOf(value) + "'";
    }

    protected String getTimestamp(Object value) throws SQLException {
        if (value == null) {
            return NULL;
        }
        return "'" + String.valueOf(value) + "'";
    }

    public char getEncloseChar() {
        return '\"';
    }
}

