/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule.db2;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import zigen.plugin.db.core.rule.DefaultMappingFactory;
import zigen.plugin.db.core.rule.IMappingFactory;

public class DB2MappingFactory
extends DefaultMappingFactory
implements IMappingFactory {
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.");
    private DecimalFormat numberFormatter = new DecimalFormat("000000");

    public DB2MappingFactory(boolean convertUnicode) {
        super(convertUnicode);
    }

    protected String getTimestamp(ResultSet rs, int icol) throws SQLException {
        Timestamp value = rs.getTimestamp(icol);
        if (rs.wasNull()) {
            return this.nullSymbol;
        }
        return String.valueOf(this.dateFormatter.format(value)) + this.numberFormatter.format(value.getNanos() / 1000);
    }

    protected void setTimestamp(PreparedStatement pst, int icol, String str) throws Exception {
        if (this.nullSymbol.equals(str)) {
            pst.setNull(icol, 93);
        } else {
            pst.setTimestamp(icol, this.toTimestamp3(str));
        }
    }

    private Timestamp toTimestamp3(String str) throws Exception {
        SimpleDateFormat df = null;
        Date date = null;
        switch (str.length()) {
            case 10: {
                df = str.indexOf("/") > 0 ? new SimpleDateFormat("yyyy/MM/dd") : new SimpleDateFormat("yyyy-MM-dd");
                date = df.parse(str);
                return new Timestamp(date.getTime());
            }
            case 19: {
                df = str.indexOf("/") > 0 ? new SimpleDateFormat("yyyy/MM/dd HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                date = df.parse(str);
                return new Timestamp(date.getTime());
            }
            case 23: {
                df = str.indexOf("/") > 0 ? new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                date = df.parse(str);
                return new Timestamp(date.getTime());
            }
            case 26: {
                df = str.indexOf("/") > 0 ? new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.");
                Timestamp ts = new Timestamp(df.parse(str.substring(0, 20)).getTime());
                ts.setNanos(this.numberFormatter.parse(str.substring(20)).intValue() * 1000);
                return ts;
            }
        }
        return null;
    }
}

