/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.SQLHistoryManager;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.internal.History;
import zigen.plugin.db.ui.internal.HistoryFolder;
import zigen.plugin.db.ui.views.HistoryContentProvider;
import zigen.plugin.db.ui.views.HistoryView;

public class DeleteHistoryAction
extends Action
implements Runnable {
    StructuredViewer viewer = null;

    public DeleteHistoryAction(StructuredViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("DeleteHistoryAction.0"));
        this.setToolTipText(Messages.getString("DeleteHistoryAction.1"));
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator iter = selection.iterator();
        IContentProvider obj = this.viewer.getContentProvider();
        if (obj instanceof HistoryContentProvider) {
            HistoryContentProvider cfr_ignored_0 = (HistoryContentProvider)obj;
            if (DbPlugin.getDefault().confirmDialog(Messages.getString("DeleteHistoryAction.2"))) {
                SQLHistoryManager mgr = DbPlugin.getDefault().getHistoryManager();
                TimeWatcher tw = new TimeWatcher();
                tw.start();
                while (iter.hasNext()) {
                    Object object = iter.next();
                    if (object instanceof HistoryFolder) {
                        HistoryFolder folder = (HistoryFolder)object;
                        folder.getParent().removeChild(folder);
                        this.viewer.refresh((Object)folder.getParent());
                        List list = folder.getChildren();
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            History history = (History)iterator.next();
                            if (history.getSqlHistory().isBlank()) continue;
                            try {
                                mgr.remove(history.getSqlHistory());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        continue;
                    }
                    if (!(object instanceof History)) continue;
                    History history = (History)object;
                    history.getParent().removeChild(history);
                    this.viewer.refresh((Object)history.getParent());
                    try {
                        mgr.remove(history.getSqlHistory());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                tw.stop();
                tw.start();
                IViewPart part = DbPlugin.findView("zigen.plugin.db.ui.views.HistoryView");
                if (part instanceof HistoryView) {
                    HistoryView hv = (HistoryView)part;
                    DbPlugin.fireStatusChangeListener(hv, 101);
                }
                tw.stop();
            }
        }
    }
}

