/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.rule.DefaultTableInfoSearchFactory;
import zigen.plugin.db.core.rule.ITableInfoSearchFactory;
import zigen.plugin.db.core.rule.oracle.OracleTableInfoSearchFactory;
import zigen.plugin.db.core.rule.symfoware.SymfowareTableInfoSearchFactory;

public abstract class AbstractTableInfoSearchFactory
implements ITableInfoSearchFactory {
    private static Map map = new HashMap();

    public static ITableInfoSearchFactory getFactory(DatabaseMetaData meta) throws SQLException {
        ITableInfoSearchFactory factory = null;
        String key = meta.getDriverName();
        if (map.containsKey(key)) {
            factory = (ITableInfoSearchFactory)map.get(key);
            factory.setDatabaseMetaData(meta);
        } else {
            switch (DBType.getType(key)) {
                case 1: {
                    factory = new OracleTableInfoSearchFactory(meta);
                    break;
                }
                case 3: {
                    factory = new SymfowareTableInfoSearchFactory(meta);
                    break;
                }
                default: {
                    factory = new DefaultTableInfoSearchFactory(meta);
                }
            }
            map.put(key, factory);
        }
        return factory;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getTableInfoAll(Connection con, String owner, String[] types) throws Exception {
        ArrayList<TableInfo> result = null;
        ResultSet rs = null;
        Statement st = null;
        try {
            try {
                st = con.createStatement();
                String query = this.getTableInfoAllSql(owner, types);
                System.out.println(query);
                if (query != null) {
                    result = new ArrayList<TableInfo>();
                    rs = st.executeQuery(query);
                    while (rs.next()) {
                        TableInfo info = new TableInfo();
                        info.setName(rs.getString("TABLE_NAME"));
                        info.setTableType(rs.getString("TABLE_TYPE"));
                        info.setComment(rs.getString("REMARKS"));
                        result.add(info);
                    }
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            ResultSetUtil.close(rs);
            StatementUtil.close(st);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TableInfo getTableInfo(Connection con, String owner, String tableName, String type) throws Exception {
        TableInfo info = null;
        ResultSet rs = null;
        Statement st = null;
        try {
            try {
                st = con.createStatement();
                String query = this.getTableInfoSql(owner, tableName, type);
                if (query != null && (rs = st.executeQuery(query)).next()) {
                    info = new TableInfo();
                    info.setName(rs.getString("TABLE_NAME"));
                    info.setTableType(rs.getString("TABLE_TYPE"));
                    info.setComment(rs.getString("REMARKS"));
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            ResultSetUtil.close(rs);
            StatementUtil.close(st);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return info;
    }

    public abstract String getDbName();

    public abstract String getTableInfoAllSql(String var1, String[] var2);

    public abstract String getTableInfoSql(String var1, String var2, String var3);
}

