/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule.mysql;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.rule.DefaultMappingFactory;
import zigen.plugin.db.core.rule.IMappingFactory;

public class MySQLMappingFactory
extends DefaultMappingFactory
implements IMappingFactory {
    public MySQLMappingFactory(boolean convertUnicode) {
        super(convertUnicode);
    }

    protected String getTimestamp(ResultSet rs, int icol) throws SQLException {
        try {
            Timestamp value = rs.getTimestamp(icol);
            if (rs.wasNull()) {
                return this.nullSymbol;
            }
            return this.timeStampFormat.format(value);
        }
        catch (SQLException e) {
            if ("S1009".equals(e.getSQLState())) {
                return this.nullSymbol;
            }
            throw e;
        }
    }

    protected String getDate(ResultSet rs, int icol) throws SQLException {
        try {
            Date value = rs.getDate(icol);
            if (rs.wasNull()) {
                return this.nullSymbol;
            }
            return this.dateFormat.format(value);
        }
        catch (SQLException e) {
            if ("S1009".equals(e.getSQLState())) {
                return this.nullSymbol;
            }
            throw e;
        }
    }

    protected void setBinary(PreparedStatement pst, int icol, Object value) throws Exception {
        if (value == null) {
            pst.setNull(icol, 2004);
            return;
        }
        int size = 0;
        try {
            if (value instanceof File) {
                File file = (File)value;
                size = (int)file.length();
                pst.setBinaryStream(icol, (InputStream)new FileInputStream(file), size);
            } else if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                size = bytes.length;
                pst.setBinaryStream(icol, (InputStream)new ByteArrayInputStream(bytes), size);
            } else if (value instanceof String) {
                String str = (String)value;
                if (this.nullSymbol.equals(str)) {
                    pst.setNull(icol, 2004);
                    return;
                }
                byte[] bytes = str.getBytes();
                size = bytes.length;
                pst.setBinaryStream(icol, (InputStream)new ByteArrayInputStream(bytes), size);
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }
}

