/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.ChangeColorRecord;
import zigen.plugin.db.ui.views.internal.ColorManager;

public class ChangeColorJob
extends AbstractJob {
    protected IPreferenceStore store;
    protected Table table;
    protected ITable tableNode;
    protected int columnSize;
    protected int rowSize;
    protected Color blue;
    protected Color black;
    protected Color glay;
    protected Color white;
    protected Color lightblue;
    protected Column selectedColumn;

    public ChangeColorJob(Table table) {
        this(table, null);
    }

    public ChangeColorJob(Table table, ITable tableNode) {
        super("Changing ForgoundColor...");
        this.tableNode = tableNode;
        this.setTable(table);
    }

    public void setTable(Table table) {
        this.store = DbPlugin.getDefault().getPreferenceStore();
        this.table = table;
        this.columnSize = table.getColumnCount();
        this.rowSize = table.getItemCount();
        ColorManager colorManager = new ColorManager();
        Display display = Display.getDefault();
        this.blue = new Color((Device)display, 0, 0, 255);
        this.black = new Color((Device)display, 0, 0, 0);
        this.glay = display.getSystemColor(22);
        this.white = display.getSystemColor(1);
        this.lightblue = colorManager.getColor("PreferencePage.BackGround");
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Change Color...", this.rowSize);
            if (this.store.getBoolean("PreferencePage.ChangeNullColor")) {
                String nullSymbol = DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol");
                int i = 0;
                while (i < this.rowSize) {
                    monitor.worked(1);
                    ChangeColorRecord thread = this.tableNode != null ? new ChangeColorRecord(this.table, i, this.columnSize, this.tableNode) : new ChangeColorRecord(this.table, i, this.columnSize);
                    thread.setNullSymbol(nullSymbol);
                    thread.setBlack(this.black);
                    thread.setBlue(this.blue);
                    thread.setGlay(this.glay);
                    thread.setWhite(this.white);
                    thread.setLightblue(this.lightblue);
                    thread.setSelectedColumn(this.selectedColumn);
                    this.showResults(thread);
                    ++i;
                }
            }
            monitor.done();
        }
        catch (SWTException e) {
            DbPlugin.log(e);
        }
        catch (Exception e) {
            this.showErrorMessage("", e);
        }
        return Status.OK_STATUS;
    }

    public void setSelectedColumn(Column selectedColumn) {
        this.selectedColumn = selectedColumn;
    }
}

