/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.Connection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorSearcher;
import zigen.plugin.db.ui.internal.OracleSource;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.jobs.RefreshTreeNodeAction;

public class RefreshOracleSourceJob
extends AbstractJob {
    private TreeViewer viewer;
    private OracleSource source;

    public RefreshOracleSourceJob(TreeViewer viewer, OracleSource source) {
        super("RefreshOracleSource...");
        this.viewer = viewer;
        this.source = source;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Refresh Oracle Source...", 10);
            Connection con = Transaction.getInstance(this.source.getDbConfig()).getConnection();
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Schema schema = this.source.getSchema();
            String owner = schema.getName();
            String type = this.source.getType();
            OracleSourceErrorInfo[] errors = OracleSourceErrorSearcher.execute(con, owner, this.source.getName(), type);
            this.source.setHasError(errors.length > 0);
            this.showResults(new RefreshTreeNodeAction(this.viewer, this.source.getParent(), 0));
            this.showResults(new RefreshTreeNodeAction(this.viewer, this.source, 0));
            monitor.done();
        }
        catch (Exception e) {
            this.showErrorMessage(Messages.getString("OracleSourceSearchJob.1"), e);
        }
        return Status.OK_STATUS;
    }
}

