/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.JDBCUnicodeConvertor;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.rule.AbstractMappingFactory;
import zigen.plugin.db.core.rule.IMappingFactory;
import zigen.plugin.db.core.rule.UnSupportedTypeException;

public class DefaultMappingFactory
extends AbstractMappingFactory
implements IMappingFactory {
    protected DefaultMappingFactory(boolean convertUnicode) {
        this.convertUnicode = convertUnicode;
    }

    public Object getObject(ResultSet rs, int icol) throws SQLException {
        ResultSetMetaData rmd = rs.getMetaData();
        Object obj = null;
        int type = rmd.getColumnType(icol);
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                obj = this.getString(rs, icol);
                break;
            }
            case -7: 
            case 16: {
                obj = this.getBoolean(rs, icol);
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                obj = this.getLong(rs, icol);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                obj = this.getDouble(rs, icol);
                break;
            }
            case 2: 
            case 3: {
                obj = this.getBigDecimal(rs, icol);
                break;
            }
            case 91: {
                obj = this.getDate(rs, icol);
                break;
            }
            case 92: {
                obj = this.getTime(rs, icol);
                break;
            }
            case 93: {
                obj = this.getTimestamp(rs, icol);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                obj = this.getBinary(rs, icol);
                break;
            }
            case 2005: {
                obj = this.getClob(rs, icol);
                break;
            }
            case 2004: {
                obj = this.getBlob(rs, icol);
                break;
            }
            case 1111: {
                obj = this.getOther(rs, icol);
                break;
            }
            default: {
                obj = this.getUnknown(rs, icol, type);
            }
        }
        return obj;
    }

    protected boolean canModify_CHAR() {
        return true;
    }

    protected boolean canModify_VARCHAR() {
        return true;
    }

    protected boolean canModify_LONGVARCHAR() {
        return true;
    }

    protected boolean canModify_BIT() {
        return true;
    }

    protected boolean canModify_BOOLEAN() {
        return true;
    }

    protected boolean canModify_TINYINT() {
        return true;
    }

    protected boolean canModify_SMALLINT() {
        return true;
    }

    protected boolean canModify_INTEGER() {
        return true;
    }

    protected boolean canModify_BIGINT() {
        return true;
    }

    protected boolean canModify_REAL() {
        return true;
    }

    protected boolean canModify_FLOAT() {
        return true;
    }

    protected boolean canModify_DOUBLE() {
        return true;
    }

    protected boolean canModify_NUMERIC() {
        return true;
    }

    protected boolean canModify_DECIMAL() {
        return true;
    }

    protected boolean canModify_DATE() {
        return true;
    }

    protected boolean canModify_TIME() {
        return true;
    }

    protected boolean canModify_TIMESTAMP() {
        return true;
    }

    protected boolean canModify_BINARY() {
        return true;
    }

    protected boolean canModify_VARBINARY() {
        return true;
    }

    protected boolean canModify_LONGVARBINARY() {
        return true;
    }

    protected boolean canModify_CLOB() {
        return true;
    }

    protected boolean canModify_BLOB() {
        return true;
    }

    protected boolean canModify_OTHER() {
        return false;
    }

    public boolean canModifyDataType(int dataType) {
        switch (dataType) {
            case 1: {
                return this.canModify_CHAR();
            }
            case 12: {
                return this.canModify_VARCHAR();
            }
            case -1: {
                return this.canModify_LONGVARCHAR();
            }
            case -7: {
                return this.canModify_BIT();
            }
            case 16: {
                return this.canModify_BOOLEAN();
            }
            case -6: {
                return this.canModify_TINYINT();
            }
            case 5: {
                return this.canModify_SMALLINT();
            }
            case 4: {
                return this.canModify_INTEGER();
            }
            case -5: {
                return this.canModify_BIGINT();
            }
            case 7: {
                return this.canModify_REAL();
            }
            case 6: {
                return this.canModify_FLOAT();
            }
            case 8: {
                return this.canModify_DOUBLE();
            }
            case 2: {
                return this.canModify_NUMERIC();
            }
            case 3: {
                return this.canModify_DECIMAL();
            }
            case 91: {
                return this.canModify_DATE();
            }
            case 92: {
                return this.canModify_TIME();
            }
            case 93: {
                return this.canModify_TIMESTAMP();
            }
            case -2: {
                return this.canModify_BINARY();
            }
            case -3: {
                return this.canModify_VARBINARY();
            }
            case -4: {
                return this.canModify_LONGVARBINARY();
            }
            case 2005: {
                return this.canModify_CLOB();
            }
            case 2004: {
                return this.canModify_BLOB();
            }
            case 1111: {
                return this.canModify_OTHER();
            }
        }
        return false;
    }

    protected String getString(ResultSet rs, int icol) throws SQLException {
        String value = rs.getString(icol);
        if (rs.wasNull()) {
            return this.nullSymbol;
        }
        if (this.convertUnicode) {
            return JDBCUnicodeConvertor.convert(value);
        }
        return value;
    }

    protected String getBoolean(ResultSet rs, int icol) throws SQLException {
        boolean value = rs.getBoolean(icol);
        if (rs.wasNull()) {
            return this.nullSymbol;
        }
        return String.valueOf(value);
    }

    protected String getBigDecimal(ResultSet rs, int icol) throws SQLException {
        BigDecimal value = rs.getBigDecimal(icol);
        if (rs.wasNull()) {
            return this.nullSymbol;
        }
        return value.toString();
    }

    protected String getLong(ResultSet rs, int icol) throws SQLException {
        try {
            long value = rs.getLong(icol);
            if (rs.wasNull()) {
                return this.nullSymbol;
            }
            return String.valueOf(value);
        }
        catch (SQLException sQLException) {
            BigDecimal value = rs.getBigDecimal(icol);
            if (rs.wasNull()) {
                return this.nullSymbol;
            }
            return String.valueOf(value);
        }
    }

    protected String getDouble(ResultSet rs, int icol) throws SQLException {
        double value = rs.getDouble(icol);
        if (rs.wasNull()) {
            return this.nullSymbol;
        }
        return this.toStringForDisplay(value);
    }

    protected String getDate(ResultSet rs, int icol) throws SQLException {
        Date value = rs.getDate(icol);
        if (rs.wasNull()) {
            return this.nullSymbol;
        }
        return this.dateFormat.format(value);
    }

    protected String getTime(ResultSet rs, int icol) throws SQLException {
        Time value = rs.getTime(icol);
        if (rs.wasNull()) {
            return this.nullSymbol;
        }
        return this.timeFormat.format(value);
    }

    protected String getTimestamp(ResultSet rs, int icol) throws SQLException {
        Timestamp value = rs.getTimestamp(icol);
        if (rs.wasNull()) {
            return this.nullSymbol;
        }
        return this.timeStampFormat.format(new java.util.Date(value.getTime()));
    }

    protected String getBinary(ResultSet rs, int icol) throws SQLException {
        String obj = null;
        try {
            rs.getBinaryStream(icol);
            if (rs.wasNull()) {
                return this.nullSymbol;
            }
            obj = "<<Binary>>";
        }
        catch (Exception e) {
            DbPlugin.log(e);
            throw new SQLException(e.getMessage());
        }
        return obj;
    }

    protected Object getClob(ResultSet rs, int icol) throws SQLException {
        rs.getObject(icol);
        if (rs.wasNull()) {
            return this.nullSymbol;
        }
        return "<<CLOB>>";
    }

    protected Object getBlob(ResultSet rs, int icol) throws SQLException {
        rs.getObject(icol);
        if (rs.wasNull()) {
            return this.nullSymbol;
        }
        return "<<BLOB>>";
    }

    protected String getOther(ResultSet rs, int icol) throws SQLException {
        rs.getObject(icol);
        if (rs.wasNull()) {
            return this.nullSymbol;
        }
        return "<<OTHER>>";
    }

    protected String getUnknown(ResultSet rs, int icol, int type) throws SQLException {
        rs.getObject(icol);
        if (rs.wasNull()) {
            return this.nullSymbol;
        }
        return "<<Unknown Type (" + type + ")>>";
    }

    protected void setChar(PreparedStatement pst, int icol, String str) throws SQLException {
        if (this.nullSymbol.equals(str)) {
            pst.setNull(icol, 1);
        } else {
            pst.setString(icol, str);
        }
    }

    protected void setVarchar(PreparedStatement pst, int icol, String str) throws SQLException {
        if (this.nullSymbol.equals(str)) {
            pst.setNull(icol, 12);
        } else {
            pst.setString(icol, str);
        }
    }

    protected void setLonvarchar(PreparedStatement pst, int icol, String str) throws SQLException {
        if (this.nullSymbol.equals(str)) {
            pst.setNull(icol, -1);
        } else {
            StringReader reader = new StringReader(str);
            pst.setCharacterStream(icol, (Reader)reader, str.length());
        }
    }

    protected void setBigDecimal(PreparedStatement pst, int icol, String str) throws SQLException {
        if (this.nullSymbol.equals(str)) {
            pst.setNull(icol, 2);
        } else {
            pst.setBigDecimal(icol, new BigDecimal(str));
        }
    }

    protected void setDate(PreparedStatement pst, int icol, String str) throws Exception {
        if (this.nullSymbol.equals(str)) {
            pst.setNull(icol, 91);
        } else {
            pst.setDate(icol, this.toDate(str));
        }
    }

    protected void setTime(PreparedStatement pst, int icol, String str) throws Exception {
        if (this.nullSymbol.equals(str)) {
            pst.setNull(icol, 92);
        } else {
            pst.setTime(icol, this.toTime(str));
        }
    }

    protected void setTimestamp(PreparedStatement pst, int icol, String str) throws Exception {
        if (this.nullSymbol.equals(str)) {
            pst.setNull(icol, 93);
        } else {
            pst.setTimestamp(icol, this.toTimestamp(str));
        }
    }

    protected void setBoolean(PreparedStatement pst, int icol, String str) throws Exception {
        if (this.nullSymbol.equals(str)) {
            pst.setNull(icol, 16);
        } else if (str.toLowerCase().equals("true") || str.equals("1")) {
            pst.setBoolean(icol, true);
        } else {
            pst.setBoolean(icol, false);
        }
    }

    protected void setBinary(PreparedStatement pst, int icol, Object value) throws Exception {
        if (value == null) {
            pst.setNull(icol, 2004);
            return;
        }
        int size = 0;
        try {
            if (value instanceof File) {
                File file = (File)value;
                size = (int)file.length();
                pst.setBinaryStream(icol, (InputStream)new FileInputStream(file), size);
            } else if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                size = bytes.length;
                pst.setBinaryStream(icol, (InputStream)new ByteArrayInputStream(bytes), size);
            } else if (value instanceof String) {
                String str = (String)value;
                if (this.nullSymbol.equals(str)) {
                    pst.setNull(icol, 2004);
                    return;
                }
                byte[] bytes = str.getBytes();
                size = bytes.length;
                pst.setBinaryStream(icol, (InputStream)new ByteArrayInputStream(bytes), size);
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    protected void setBlob(PreparedStatement pst, int icol, Object value) throws SQLException {
        if (value == null) {
            pst.setNull(icol, 2004);
            return;
        }
        int size = 0;
        try {
            if (value instanceof File) {
                File file = (File)value;
                size = (int)file.length();
                pst.setBinaryStream(icol, (InputStream)new FileInputStream(file), size);
            } else if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                size = bytes.length;
                pst.setBinaryStream(icol, (InputStream)new ByteArrayInputStream(bytes), size);
            } else if (value instanceof String) {
                String str = (String)value;
                if (this.nullSymbol.equals(str)) {
                    pst.setNull(icol, 2004);
                    return;
                }
                byte[] bytes = str.getBytes();
                size = bytes.length;
                pst.setBinaryStream(icol, (InputStream)new ByteArrayInputStream(bytes), size);
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    protected void setClob(PreparedStatement pst, int icol, Object value) throws SQLException {
        if (value == null) {
            pst.setNull(icol, 2005);
            return;
        }
        int size = 0;
        try {
            if (value instanceof File) {
                File file = (File)value;
                size = (int)file.length();
                pst.setCharacterStream(icol, (Reader)new FileReader(file), size);
            } else if (value instanceof char[]) {
                char[] chars = (char[])value;
                size = chars.length;
                pst.setCharacterStream(icol, (Reader)new CharArrayReader(chars), size);
            } else if (value instanceof String) {
                String str = (String)value;
                if (this.nullSymbol.equals(str)) {
                    pst.setNull(icol, 2005);
                    return;
                }
                size = str.getBytes().length;
                pst.setCharacterStream(icol, (Reader)new StringReader(str), size);
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    public void setObject(PreparedStatement pst, int icol, TableColumn column, Object value) throws Exception {
        try {
            int type = column.getDataType();
            String str = String.valueOf(value);
            switch (type) {
                case 1: {
                    this.setChar(pst, icol, str);
                    break;
                }
                case 12: {
                    this.setVarchar(pst, icol, str);
                    break;
                }
                case -1: {
                    this.setLonvarchar(pst, icol, str);
                    break;
                }
                case -7: 
                case 16: {
                    this.setBoolean(pst, icol, str);
                    break;
                }
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.setBigDecimal(pst, icol, str);
                    break;
                }
                case 91: {
                    this.setDate(pst, icol, str);
                    break;
                }
                case 92: {
                    this.setTime(pst, icol, str);
                    break;
                }
                case 93: {
                    this.setTimestamp(pst, icol, str);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.setBinary(pst, icol, value);
                    break;
                }
                case 2004: {
                    this.setBlob(pst, icol, value);
                    break;
                }
                case 2005: {
                    this.setClob(pst, icol, value);
                    break;
                }
                default: {
                    throw new UnSupportedTypeException(column, value);
                }
            }
        }
        catch (SQLException e) {
            DbPlugin.log(e);
            throw new Exception(e);
        }
    }

    protected final String toStringForDisplay(double num) {
        if (Math.ceil(num) == Math.floor(num)) {
            return String.valueOf((int)num);
        }
        return String.valueOf(num);
    }

    protected final String toStringForDisplay(BigDecimal num) {
        BigDecimal b;
        BigDecimal a = num.setScale(0, 2);
        if (a.equals(b = num.setScale(0, 3))) {
            return a.toString();
        }
        return num.toString();
    }
}

