/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule.symfoware;

import java.sql.DatabaseMetaData;
import java.util.Map;
import java.util.TreeMap;
import zigen.plugin.db.core.JDBCUnicodeConvertor;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.rule.ColumnInfo;
import zigen.plugin.db.core.rule.DefaultColumnSearcherFactory;

public class SymfowareColumnSearcharFactory
extends DefaultColumnSearcherFactory {
    static Map typeMap = new TreeMap();
    static Map typeNameMap;

    static {
        typeMap.put("CH", new Integer(1));
        typeMap.put("CV", new Integer(12));
        typeMap.put("BL", new Integer(2004));
        typeMap.put("CN", new Integer(1));
        typeMap.put("NV", new Integer(1));
        typeMap.put("IN", new Integer(4));
        typeMap.put("SI", new Integer(5));
        typeMap.put("NU", new Integer(3));
        typeMap.put("DE", new Integer(3));
        typeMap.put("FL", new Integer(6));
        typeMap.put("DP", new Integer(8));
        typeMap.put("RE", new Integer(7));
        typeMap.put("TM", new Integer(93));
        typeMap.put("DT", new Integer(91));
        typeMap.put("TI", new Integer(92));
        typeMap.put("IT", new Integer(1111));
        typeNameMap = new TreeMap();
        typeNameMap.put("CH", "char");
        typeNameMap.put("CV", "varchar");
        typeNameMap.put("BL", "blob");
        typeNameMap.put("CN", "nchar");
        typeNameMap.put("NV", "nchar varying");
        typeNameMap.put("IN", "int");
        typeNameMap.put("SI", "smallint");
        typeNameMap.put("NU", "numeric");
        typeNameMap.put("DE", "decimal");
        typeNameMap.put("FL", "float");
        typeNameMap.put("DP", "double precision");
        typeNameMap.put("RE", "real");
        typeNameMap.put("TM", "timestamp");
        typeNameMap.put("DT", "date");
        typeNameMap.put("TI", "time");
        typeNameMap.put("IT", "interval");
    }

    public SymfowareColumnSearcharFactory(DatabaseMetaData meta, boolean convertUnicode) {
        super(meta, convertUnicode);
    }

    private int getJavaType(String typeName) {
        String key = typeName.toUpperCase();
        if (typeMap.containsKey(key)) {
            Integer i = (Integer)typeMap.get(key);
            return i;
        }
        return 1111;
    }

    private String getTypeName(String typeName) {
        String key = typeName.toUpperCase();
        if (typeNameMap.containsKey(key)) {
            return (String)typeNameMap.get(key);
        }
        return "Unknown";
    }

    protected void overrideColumnInfo(Map map, TableColumn tCol) throws Exception {
        ColumnInfo col;
        if (map != null && map.size() > 0 && (col = (ColumnInfo)map.get(tCol.getColumnName())) != null) {
            if (col.getData_precision() == null) {
                tCol.setColumnSize(0);
                tCol.setDecimalDigits(0);
                tCol.setWithoutParam(true);
            } else {
                if (col.getData_precision() != null) {
                    tCol.setColumnSize(col.getData_precision().intValue());
                } else {
                    tCol.setColumnSize(0);
                }
                if (col.getData_scale() != null) {
                    tCol.setDecimalDigits(col.getData_scale().intValue());
                } else {
                    tCol.setDecimalDigits(0);
                }
                tCol.setWithoutParam(false);
            }
            if (col.getData_default() != null) {
                tCol.setDefaultValue(col.getData_default().trim());
            }
            String dataType = col.getData_type();
            tCol.setDataType(this.getJavaType(dataType));
            tCol.setTypeName(this.getTypeName(dataType));
            String remarks = col.getComments();
            if (this.convertUnicode) {
                remarks = JDBCUnicodeConvertor.convert(remarks);
            }
            tCol.setRemarks(remarks);
        }
    }

    protected String getCustomColumnInfoSQL(String dbName, String owner, String table) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT");
        sb.append("        TRIM(COL.COLUMN_NAME) ").append("COLUMN_NAME");
        sb.append("        ,COL.DATA_TYPE ").append("DATA_TYPE");
        sb.append("        ,COL.DATA_TYPE ").append("TYPE_NAME");
        sb.append("        ,CASE");
        sb.append("            WHEN COL.CHAR_MAX_LENGTH IS NULL THEN COL.NUMERIC_PRECISION");
        sb.append("            ELSE CASE");
        sb.append("                WHEN COL.CHAR_MAX_LENGTH > 2147483647 THEN 2147483647");
        sb.append("                ELSE COL.CHAR_MAX_LENGTH");
        sb.append("            END");
        sb.append("        END ").append("DATA_PRECISION");
        sb.append("        ,COL.NUMERIC_SCALE ").append("DATA_SCALE");
        sb.append("        ,COL.DEFAULT_VALUE ").append("DATA_DEFAULT");
        sb.append("        ,COM.COMMENT_VALUE ").append("COMMENTS");
        sb.append("    FROM");
        sb.append("        RDBII_SYSTEM.RDBII_TABLE T");
        sb.append("        ,RDBII_SYSTEM.RDBII_COLUMN COL");
        sb.append("            LEFT OUTER JOIN RDBII_SYSTEM.RDBII_COMMENT COM");
        sb.append("                ON (");
        sb.append("                    COL.DB_CODE = COM.DB_CODE");
        sb.append("                    AND COL.SCHEMA_CODE = COM.SCHEMA_CODE");
        sb.append("                    AND COL.TABLE_CODE = COM.TABLE_CODE");
        sb.append("                    AND COL.COLUMN_CODE = COM.COLUMN_CODE");
        sb.append("                    AND COM.COMMENT_TYPE = 'CL'");
        sb.append("                )");
        sb.append("    WHERE");
        sb.append("        T.DB_NAME = '" + SQLUtil.encodeQuotation(dbName) + "'");
        sb.append("        AND T.SCHEMA_NAME = '" + SQLUtil.encodeQuotation(owner) + "'");
        sb.append("        AND T.TABLE_NAME = '" + SQLUtil.encodeQuotation(table) + "'");
        sb.append("        AND T.TABLE_CODE = COL.TABLE_CODE");
        sb.append("    ORDER BY");
        sb.append("        COL.ORDINAL_POSITION");
        return sb.toString();
    }
}

