/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.preference;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.preference.Messages;

public class CSVPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String P_ENCODING = "CSVPreferencePage.Encoding";
    public static final String P_DEMILITER = "CSVPreferencePage.Demiliter";
    public static final String P_NON_HEADER = "CSVPreferencePage.NonHeader";
    public static final String P_NON_DOUBLE_QUATE = "CSVPreferencePage.NonDoubleQuate";
    public static String[] encordes = new String[]{"MS932", "ISO-8859-1", "ISO2022JP", "JIS", "Shift-JIS", "US-ASCII", "UTF-16", "UTF-16BE", "UTF-16LE", "UTF-8", "EUC_JP"};
    private Combo comb;
    private Text txtSeparator;
    private Button checkNonHeader;
    private Button checkNonDoubleQuate;

    public void init(IWorkbench workbench) {
    }

    public CSVPreferencePage() {
        super.setPreferenceStore(DbPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(1, false));
        base.setLayoutData((Object)new GridData(1808));
        Group group = new Group(base, 0);
        group.setLayout((Layout)new FillLayout(256));
        group.setText(Messages.getString("CSVPreferencePage.12"));
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("CSVPreferencePage.13"));
        this.comb = new Combo(composite, 0);
        String defaultString = this.getPreferenceStore().getString(P_ENCODING);
        int i = 0;
        while (i < encordes.length) {
            this.comb.add(encordes[i]);
            if (encordes[i].equals(defaultString)) {
                this.comb.select(i);
            }
            ++i;
        }
        if (this.comb.getSelectionIndex() == -1) {
            this.comb.add(defaultString, 0);
            this.comb.select(0);
        }
        Label label2 = new Label(composite, 0);
        label2.setText(Messages.getString("CSVPreferencePage.7"));
        label2.setLayoutData((Object)new GridData(768));
        this.txtSeparator = new Text(composite, 2048);
        this.txtSeparator.setLayoutData((Object)new GridData(768));
        defaultString = this.getPreferenceStore().getString(P_DEMILITER).trim();
        if (defaultString != null && !"".equals(defaultString)) {
            this.txtSeparator.setText(defaultString);
        } else {
            this.txtSeparator.setText(",");
        }
        this.checkNonHeader = new Button(composite, 32);
        this.checkNonHeader.setText(Messages.getString("CSVPreferencePage.9"));
        GridData d = new GridData();
        d.horizontalSpan = 2;
        this.checkNonHeader.setLayoutData((Object)d);
        boolean b = this.getPreferenceStore().getBoolean(P_NON_HEADER);
        this.checkNonHeader.setSelection(b);
        GridData d2 = new GridData();
        d2.horizontalSpan = 2;
        this.checkNonHeader.setLayoutData((Object)d2);
        this.checkNonDoubleQuate = new Button(composite, 32);
        this.checkNonDoubleQuate.setText(Messages.getString("CSVPreferencePage.8"));
        boolean b2 = this.getPreferenceStore().getBoolean(P_NON_DOUBLE_QUATE);
        this.checkNonDoubleQuate.setSelection(b2);
        return parent;
    }

    protected void performDefaults() {
        String defaultString = this.getPreferenceStore().getDefaultString(P_ENCODING);
        String demiliter = this.getPreferenceStore().getDefaultString(P_DEMILITER);
        boolean nonHeader = this.getPreferenceStore().getDefaultBoolean(P_NON_HEADER);
        boolean nonDoubleQuate = this.getPreferenceStore().getDefaultBoolean(P_NON_DOUBLE_QUATE);
        int i = 0;
        while (i < encordes.length) {
            if (encordes[i].equals(defaultString)) {
                this.comb.select(i);
            }
            ++i;
        }
        this.txtSeparator.setText(demiliter);
        this.checkNonHeader.setSelection(nonHeader);
        this.checkNonDoubleQuate.setSelection(nonDoubleQuate);
        super.performDefaults();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue(P_ENCODING, this.comb.getText());
        this.getPreferenceStore().setValue(P_DEMILITER, this.txtSeparator.getText());
        this.getPreferenceStore().setValue(P_NON_HEADER, this.checkNonHeader.getSelection());
        this.getPreferenceStore().setValue(P_NON_DOUBLE_QUATE, this.checkNonDoubleQuate.getSelection());
        return super.performOk();
    }
}

