/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import zigen.plugin.db.core.ConnectionManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.editors.exceptions.NotFoundDBConfigException;

public class Transaction {
    private static Hashtable map = new Hashtable();
    private static Transaction instance;
    private IDBConfig config;

    public static synchronized Transaction getInstance(IDBConfig config) {
        if (instance == null) {
            instance = new Transaction();
        }
        Transaction.instance.config = config;
        instance.create();
        return instance;
    }

    private Transaction() {
    }

    private void create() {
        if (this.config == null) {
            throw new NotFoundDBConfigException("There is no Data Base definition information. ");
        }
        if (!map.containsKey(this.config.getDbName())) {
            map.put(this.config.getDbName(), new TransactionElement(this.config));
        } else {
            TransactionElement element = (TransactionElement)map.get(this.config.getDbName());
            if (element.con == null || !this.config.getUserId().equals(element.config.getUserId())) {
                ConnectionManager.closeConnection(element.con);
                element.con = null;
                element.config = this.config;
            }
        }
    }

    public Connection getConnection() throws Exception {
        TransactionElement element = (TransactionElement)map.get(this.config.getDbName());
        if (element.con == null) {
            element.con = ConnectionManager.getConnection(this.config);
            element.con.setAutoCommit(false);
            element.count = 0;
        }
        if (this.config.isAutoCommit()) {
            if (!element.con.getAutoCommit()) {
                element.con.setAutoCommit(true);
            }
        } else if (element.con.getAutoCommit()) {
            element.con.setAutoCommit(false);
        }
        return element.con;
    }

    public void cloesConnection() {
        TransactionElement element = (TransactionElement)map.get(this.config.getDbName());
        ConnectionManager.closeConnection(element.con);
        element.con = null;
    }

    public boolean isConneting() {
        TransactionElement element = (TransactionElement)map.get(this.config.getDbName());
        return element.isConnecting();
    }

    public void addCount(int rowAffected) throws Exception {
        TransactionElement element = (TransactionElement)map.get(this.config.getDbName());
        element.count += rowAffected;
    }

    public void resetCount() throws Exception {
        TransactionElement element = (TransactionElement)map.get(this.config.getDbName());
        element.count = 0;
    }

    public int getTransactionCount() {
        TransactionElement element = (TransactionElement)map.get(this.config.getDbName());
        return element.count;
    }

    public void commit() throws Exception {
        TransactionElement element = (TransactionElement)map.get(this.config.getDbName());
        if (element.con != null) {
            element.con.commit();
            element.count = 0;
        }
    }

    public void rollback() throws Exception {
        TransactionElement element = (TransactionElement)map.get(this.config.getDbName());
        if (element.con != null) {
            element.con.rollback();
            element.count = 0;
        }
    }

    public IDBConfig getConfig() {
        return this.config;
    }

    public static synchronized void destroy() {
        Enumeration e = map.keys();
        while (e.hasMoreElements()) {
            Object k = e.nextElement();
            TransactionElement elem = (TransactionElement)map.get(k);
            ConnectionManager.closeConnection(elem.con);
            elem.con = null;
        }
    }

    private class TransactionElement {
        IDBConfig config = null;
        Connection con = null;
        int count = 0;

        private TransactionElement(IDBConfig config) {
            this.config = config;
        }

        private boolean isConnecting() {
            return this.con != null;
        }
    }
}

