/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.tablespace.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ext.oracle.tablespace.CSVResultWriter;
import zigen.plugin.db.ext.oracle.tablespace.CalcIndexSpace;
import zigen.plugin.db.ext.oracle.tablespace.CalcIndexSpaces;
import zigen.plugin.db.ext.oracle.tablespace.CalcTableSpace;
import zigen.plugin.db.ext.oracle.tablespace.wizard.CalcTableSpaceWizard;
import zigen.plugin.db.ext.oracle.tablespace.wizard.DefaultWizardPage;
import zigen.plugin.db.ext.oracle.tablespace.wizard.IItem;
import zigen.plugin.db.ext.oracle.tablespace.wizard.IndexItem;
import zigen.plugin.db.ext.oracle.tablespace.wizard.Messages;
import zigen.plugin.db.ext.oracle.tablespace.wizard.TableItem;
import zigen.plugin.db.ext.oracle.tablespace.wizard.WizardPage2;

public class WizardPage3
extends DefaultWizardPage {
    public static final String HEADER_SCHEMANAME = Messages.getString("WizardPage3.0");
    public static final String HEADER_TABLENAME = Messages.getString("WizardPage3.1");
    public static final String HEADER_INDEXNAME = Messages.getString("WizardPage3.2");
    public static final String HEADER_PCTFREE = Messages.getString("WizardPage3.3");
    public static final String HEADER_RECORD = Messages.getString("WizardPage3.4");
    public static final String HEADER_TABLESPACESIZE = Messages.getString("WizardPage3.5");
    public static final String HEADER_SAFECONEFFICIENT = Messages.getString("WizardPage3.6");
    public static final String HEADER_TOTALTABLESPACESIZE = Messages.getString("WizardPage3.7");
    public static final int COLUMN_TABLENAME = 0;
    public static final int COLUMN_INDEXNAME = 1;
    public static final int COLUMN_PCTFREE = 2;
    public static final int COLUMN_RECORD = 3;
    public static final int COLUMN_TABLESPACESIZE = 4;
    public static final int COLUMN_SAFECONEFFICIENT = 5;
    public static final int COLUMN_TOTALTABLESPACESIZE = 6;
    public static final String[] headers = new String[]{HEADER_TABLENAME, HEADER_INDEXNAME, HEADER_PCTFREE, HEADER_RECORD, HEADER_TABLESPACESIZE, HEADER_SAFECONEFFICIENT, HEADER_TOTALTABLESPACESIZE};
    private Text dbBlockSizeText;
    private int dbBlockSize = 0;
    private List csvResultList = null;

    public WizardPage3() {
        super("wizardPage");
        this.setTitle(Messages.getString("WizardPage3.9"));
        this.setDescription(String.valueOf(Messages.getString("WizardPage3.10")) + Messages.getString("WizardPage3.11"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite = this.createDefaultComposite(container);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.getString("WizardPage3.12"));
        this.dbBlockSizeText = new Text(composite, 2052);
        this.dbBlockSizeText.setEditable(false);
        this.createTable(container);
        this.setControl((Control)container);
    }

    private void createTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.HEIGHT_HINT;
        gridData.widthHint = this.WIDTH_HINT;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gridData);
        this.tableViewer = new TableViewer(composite, 68352);
        gridData = new GridData(1808);
        this.tableViewer.getControl().setLayoutData((Object)gridData);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.setHeaderColumn(table, headers);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        Button exportCsvBtn = new Button(composite, 8);
        exportCsvBtn.setText(Messages.getString("WizardPage3.13"));
        exportCsvBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WizardPage3.this.exportCsvButtonPressedHandler();
            }
        });
        if (this.tableItems != null) {
            this.tableViewer.setInput((Object)this.tableItems);
            this.columnsPack(table);
        }
    }

    void exportCsvButtonPressedHandler() {
        String[] headers = new String[]{HEADER_SCHEMANAME, HEADER_TABLENAME, HEADER_INDEXNAME, WizardPage2.HEADER_BLOCKSIZE, WizardPage2.HEADER_PCTFREE, HEADER_RECORD, HEADER_TABLESPACESIZE, HEADER_SAFECONEFFICIENT, HEADER_TOTALTABLESPACESIZE};
        CSVResultWriter writer = new CSVResultWriter();
        writer.setHeaders(headers);
        writer.setAppend(false);
        Shell shell = DbPlugin.getDefault().getShell();
        File file = this.saveCsv(shell, null);
        if (file.exists() && !this.confirmOverwrite(shell, file.getName())) {
            return;
        }
        try {
            writer.execute(file, this.csvResultList);
            DbPlugin.getDefault().showInformationMessage(Messages.getString("WizardPage3.15"));
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private File saveCsv(Shell shell, String defaultFileName) {
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFileName(defaultFileName);
        dialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
        dialog.setFilterNames(new String[]{Messages.getString("WizardPage3.18"), Messages.getString("WizardPage3.19")});
        String fileName = dialog.open();
        if (fileName != null) {
            return new File(fileName);
        }
        return null;
    }

    private boolean confirmOverwrite(Shell shell, String fileName) {
        MessageBox msg = new MessageBox(shell, 196);
        msg.setMessage(String.valueOf(Messages.getString("WizardPage3.20")) + fileName + Messages.getString("WizardPage3.21"));
        msg.setText(Messages.getString("WizardPage3.22"));
        int res = msg.open();
        return res == 64;
    }

    private void setHeaderColumn(Table table, String[] headers) {
        int i = 0;
        while (i < headers.length) {
            TableColumn col = headers[i].equals(HEADER_TABLENAME) || headers[i].equals(HEADER_INDEXNAME) ? new TableColumn(table, 0, i) : new TableColumn(table, 131072, i);
            col.setText(headers[i]);
            col.setResizable(true);
            col.pack();
            ++i;
        }
    }

    private IItem[] calcurate(TableItem[] tableItems) {
        ArrayList<TableItem> result = new ArrayList<TableItem>();
        this.csvResultList = new ArrayList();
        try {
            int i = 0;
            while (i < tableItems.length) {
                TableItem item = tableItems[i];
                if (item.isChecked()) {
                    CalcTableSpace tableSpace = new CalcTableSpace(item.table, this.dbBlockSize, item.getPctFree(), item.getRecordSize());
                    tableSpace.calcurate();
                    item.setCalcTableSpace(tableSpace);
                    result.add(item);
                    this.csvResultList.add(tableSpace.getCsvRow());
                    CalcIndexSpaces indexSpaces = new CalcIndexSpaces(item.table, this.dbBlockSize, item.getPctFree(), item.getRecordSize());
                    indexSpaces.calcurate();
                    CalcIndexSpace[] spaces = indexSpaces.getCalcIndexSpaces();
                    int k = 0;
                    while (k < spaces.length) {
                        CalcIndexSpace space = spaces[k];
                        IndexItem indexItem = new IndexItem(item.table, space.getIndexName(), space.getColumns());
                        indexItem.setCalcIndexSpace(space);
                        result.add(indexItem);
                        this.csvResultList.add(space.getCsvRow());
                        ++k;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
        return result.toArray(new IItem[0]);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            CalcTableSpaceWizard wiz = (CalcTableSpaceWizard)this.getWizard();
            WizardPage2 page = (WizardPage2)wiz.getPreviousPage((IWizardPage)this);
            this.tableItems = page.tableItems;
            if (this.tableItems != null) {
                String str = page.dbBlockSizeText.getText();
                if (str != null && !"".equals(str)) {
                    this.dbBlockSize = Integer.parseInt(str);
                    this.dbBlockSizeText.setText(str);
                }
                this.tableViewer.setInput((Object)this.calcurate(this.tableItems));
                this.columnsPack(this.tableViewer.getTable());
                this.setPageComplete(true);
            }
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private List contents = null;

        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (IItem[])inputElement;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.contents = null;
        }

        public void dispose() {
            this.contents = null;
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            IItem item = (IItem)element;
            switch (columnIndex) {
                case 0: {
                    result = item.getTableName();
                    break;
                }
                case 1: {
                    if (!(item instanceof IndexItem)) break;
                    result = item.getIndexName();
                    break;
                }
                case 2: {
                    result = String.valueOf(item.getPctFree());
                    break;
                }
                case 3: {
                    result = String.valueOf(item.getRecordSize());
                    break;
                }
                case 4: {
                    result = String.valueOf(item.getTableSpaceSize());
                    break;
                }
                case 5: {
                    result = String.valueOf(item.getSafeCoefficient());
                    break;
                }
                case 6: {
                    result = String.valueOf(item.getTableSpaceSafeSize());
                    break;
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

