/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.PluginSettingsManager;
import zigen.plugin.db.core.ByteArrayUtil;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.InputStreamUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TransactionForTableEditor;
import zigen.plugin.db.ui.editors.Messages;
import zigen.plugin.db.ui.editors.internal.FillCellEditorUtil;

public class LobViewDialog
extends Dialog {
    private ImageCacher ic = ImageCacher.getInstance();
    protected PluginSettingsManager pluginMgr = DbPlugin.getDefault().getPluginSettingsManager();
    private static final String DEFAULT_CHARSET = Messages.getString("LobViewDialog.0");
    private static final String ORIGINAL = Messages.getString("LobViewDialog.1");
    private CTabFolder tabFolder;
    private Text orignalText;
    private Object originalData;
    private Text newText;
    private Object newData;
    private int colIndex;
    private TableElement tableElement;
    private TableColumn column;
    private ToolItem updateItem;
    private ToolItem deleteItem;
    private ToolItem impItem;
    private ToolItem expItem;
    private ToolItem charsetItem;
    private int dataType;

    public LobViewDialog(Shell parent, TableElement tableElement, int colIndex) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        this.tableElement = tableElement;
        this.colIndex = colIndex;
        this.column = tableElement.getColumns()[colIndex - 1];
        this.dataType = this.column.getDataType();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("LobViewDialog.2"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    private void doExport() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.*"});
        dialog.setFilterNames(new String[]{Messages.getString("LobViewDialog.4")});
        String fileName = dialog.open();
        if (fileName != null) {
            File file = new File(fileName);
            if (file.exists() && !this.confirmOverwrite(this.getShell(), file.getName())) {
                return;
            }
            FillCellEditorUtil.saveAsFile(this.tableElement, this.colIndex, this.column.getDataType(), file);
        }
    }

    private boolean isClob() {
        switch (this.dataType) {
            case 2005: {
                return true;
            }
        }
        return false;
    }

    private void doImport() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.*"});
        dialog.setFilterNames(new String[]{Messages.getString("LobViewDialog.6")});
        String fileName = dialog.open();
        if (fileName != null) {
            File file = new File(fileName);
            if (file.canRead()) {
                try {
                    this.newData = InputStreamUtil.toByteArray(new FileInputStream(file));
                    this.addImagePages((byte[])this.newData, "*" + file.getName());
                    this.updateItem.setEnabled(true);
                }
                catch (IOException e) {
                    DbPlugin.getDefault().showErrorDialog(e);
                }
            } else {
                DbPlugin.getDefault().showWarningMessage(Messages.getString("LobViewDialog.8"));
            }
        }
    }

    private void doUpdate() {
        if (this.newData != null) {
            try {
                IDBConfig config = this.tableElement.getTable().getDbConfig();
                TransactionForTableEditor trans = TransactionForTableEditor.getInstance(config);
                if (this.isClob()) {
                    String str = ByteArrayUtil.toString((byte[])this.newData, this.charsetItem.getText());
                    FillCellEditorUtil.update(trans.getConnection(), this.tableElement, this.colIndex, str);
                    this.originalData = str;
                    this.charsetItem.setEnabled(false);
                } else {
                    FillCellEditorUtil.update(trans.getConnection(), this.tableElement, this.colIndex, this.newData);
                    this.originalData = this.newData;
                    this.charsetItem.setEnabled(true);
                }
                trans.commit();
                this.orignalText = this.newText;
                CTabItem[] list = this.tabFolder.getItems();
                if (list.length == 1) {
                    list[0].setText(ORIGINAL);
                } else if (list.length == 2) {
                    list[0].dispose();
                    list[1].setText(ORIGINAL);
                }
                this.updateItem.setEnabled(false);
                this.deleteItem.setEnabled(true);
                this.expItem.setEnabled(true);
            }
            catch (Exception e) {
                DbPlugin.getDefault().showErrorDialog(e);
            }
        } else {
            DbPlugin.getDefault().showWarningMessage(Messages.getString("LobViewDialog.9"));
        }
    }

    private void doDelete() {
        if (DbPlugin.getDefault().confirmDialog(Messages.getString("LobViewDialog.10"))) {
            try {
                IDBConfig config = this.tableElement.getTable().getDbConfig();
                TransactionForTableEditor trans = TransactionForTableEditor.getInstance(config);
                FillCellEditorUtil.delete(trans.getConnection(), this.tableElement, this.colIndex);
                trans.commit();
                this.addTextPages(null, ORIGINAL, false);
                CTabItem[] list = this.tabFolder.getItems();
                int i = 0;
                while (i < list.length) {
                    CTabItem control = list[i];
                    control.dispose();
                    ++i;
                }
                this.updateItem.setEnabled(false);
                this.deleteItem.setEnabled(false);
                this.expItem.setEnabled(false);
                this.charsetItem.setEnabled(false);
            }
            catch (Exception e) {
                DbPlugin.getDefault().showErrorDialog(e);
            }
        }
    }

    private boolean confirmOverwrite(Shell shell, String fileName) {
        MessageBox msg = new MessageBox(shell, 196);
        msg.setMessage(String.valueOf(Messages.getString("LobViewDialog.13")) + fileName + Messages.getString("LobViewDialog.14"));
        msg.setText(Messages.getString("LobViewDialog.15"));
        int res = msg.open();
        return res == 64;
    }

    private void createToolItem(ToolBar toolBar) {
        this.updateItem = new ToolItem(toolBar, 0x800000);
        this.updateItem.setText(Messages.getString("LobViewDialog.16"));
        this.updateItem.setToolTipText(Messages.getString("LobViewDialog.17"));
        this.updateItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LobViewDialog.this.doUpdate();
            }
        });
        this.deleteItem = new ToolItem(toolBar, 0x800000);
        this.deleteItem.setText(Messages.getString("LobViewDialog.18"));
        this.deleteItem.setToolTipText(Messages.getString("LobViewDialog.19"));
        this.deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LobViewDialog.this.doDelete();
            }
        });
        new ToolItem(toolBar, 2);
        this.impItem = new ToolItem(toolBar, 0x800000);
        this.impItem.setText(Messages.getString("LobViewDialog.20"));
        this.impItem.setToolTipText(Messages.getString("LobViewDialog.21"));
        this.impItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LobViewDialog.this.doImport();
            }
        });
        this.expItem = new ToolItem(toolBar, 0x800000);
        this.expItem.setText(Messages.getString("LobViewDialog.22"));
        this.expItem.setToolTipText(Messages.getString("LobViewDialog.23"));
        this.expItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LobViewDialog.this.doExport();
            }
        });
        new ToolItem(toolBar, 2);
        Object obj = this.pluginMgr.getValue("KEY_LOG_CHARSET");
        if (obj != null && obj instanceof String) {
            String cfr_ignored_0 = (String)obj;
        }
        this.charsetItem = this.createToolItem(toolBar, 4, DEFAULT_CHARSET, null, null, "This is dropdown one");
        DropdownSelectionListener listenerOne = new DropdownSelectionListener(this.charsetItem);
        listenerOne.add(DEFAULT_CHARSET);
        listenerOne.add("SJIS");
        listenerOne.add("UTF-8");
        listenerOne.add("EUC_JP");
        listenerOne.add("ISO2022JP");
        this.charsetItem.addSelectionListener((SelectionListener)listenerOne);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 5;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        composite.setLayout((Layout)layout);
        ToolBar toolBar = new ToolBar(composite, 0x800000);
        toolBar.setLayoutData((Object)new GridData(768));
        this.createToolItem(toolBar);
        this.createTabFolder(composite);
        this.originalData = FillCellEditorUtil.getObject(this.tableElement, this.colIndex, this.dataType);
        if (this.originalData == null) {
            this.updateItem.setEnabled(false);
            this.deleteItem.setEnabled(false);
            this.expItem.setEnabled(false);
            this.charsetItem.setEnabled(false);
        } else if (this.originalData instanceof String) {
            this.addTextPages((String)this.originalData, ORIGINAL, false);
        } else if (this.originalData instanceof byte[]) {
            this.addImagePages((byte[])this.originalData, ORIGINAL);
            this.updateItem.setEnabled(false);
            this.deleteItem.setEnabled(true);
            this.expItem.setEnabled(true);
        }
        return composite;
    }

    private ToolItem createToolItem(ToolBar parent, int type, String text, Image image, Image hotImage, String toolTipText) {
        ToolItem item = new ToolItem(parent, type);
        item.setText(text);
        item.setImage(image);
        item.setHotImage(hotImage);
        item.setToolTipText(toolTipText);
        return item;
    }

    private void createTabFolder(Composite composite) {
        GridData gridData = new GridData(1808);
        this.tabFolder = new CTabFolder(composite, 0);
        this.tabFolder.setLayoutData((Object)gridData);
        this.tabFolder.setTabHeight(20);
        this.tabFolder.setSelectionBackground(new Color[]{composite.getDisplay().getSystemColor(31), composite.getDisplay().getSystemColor(32)}, new int[]{100}, true);
        this.tabFolder.setSelectionForeground(composite.getDisplay().getSystemColor(30));
        this.tabFolder.setSimple(true);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            private void setCharsetItemEnable(String label) {
                if (ORIGINAL.equals(label)) {
                    if (LobViewDialog.this.originalData instanceof String) {
                        LobViewDialog.this.charsetItem.setEnabled(false);
                    } else {
                        LobViewDialog.this.charsetItem.setEnabled(true);
                    }
                } else {
                    LobViewDialog.this.charsetItem.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CTabItem item = (CTabItem)e.item;
                this.setCharsetItemEnable(item.getText());
            }

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = (CTabItem)e.item;
                this.setCharsetItemEnable(item.getText());
            }
        });
    }

    private void addImagePages(byte[] bytes, String label) {
        try {
            Image image = new Image(null, (InputStream)new ByteArrayInputStream(bytes));
            CTabItem tabItem = null;
            tabItem = ORIGINAL.equals(label) ? new CTabItem(this.tabFolder, 0) : new CTabItem(this.tabFolder, 64);
            tabItem.setText(label);
            tabItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    try {
                        CTabItem item;
                        if (e.getSource() instanceof CTabItem && (item = (CTabItem)e.getSource()).getText().startsWith("*") && LobViewDialog.this.updateItem != null) {
                            LobViewDialog.this.updateItem.setEnabled(false);
                        }
                    }
                    catch (Exception exception) {}
                }
            });
            tabItem.setToolTipText(label);
            ScrolledComposite sc = new ScrolledComposite((Composite)this.tabFolder, 2816);
            sc.setLayoutData((Object)new GridData(1808));
            Composite c = new Composite((Composite)sc, 128);
            GridLayout layout = new GridLayout(1, false);
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            c.setLayout((Layout)layout);
            c.setLayoutData((Object)new GridData(1808));
            Label ctl = new Label(c, 128);
            GridData gd = new GridData();
            gd.heightHint = image.getImageData().height;
            gd.widthHint = image.getImageData().width;
            ctl.setLayoutData((Object)gd);
            ctl.setImage(image);
            sc.setContent((Control)c);
            sc.setMinSize(ctl.computeSize(-1, -1));
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            tabItem.setControl((Control)sc);
            this.tabFolder.setSelection(tabItem);
            this.removeTabItem();
            this.charsetItem.setEnabled(false);
        }
        catch (Exception exception) {
            String str = ByteArrayUtil.toString(bytes, this.charsetItem.getText());
            this.addTextPages(str, label, true);
        }
    }

    private void addTextPages(String str, String label, boolean changeCharset) {
        this.charsetItem.setEnabled(changeCharset);
        if (str == null) {
            str = "";
        }
        CTabItem tabItem = null;
        tabItem = ORIGINAL.equals(label) ? new CTabItem(this.tabFolder, 0) : new CTabItem(this.tabFolder, 64);
        tabItem.setText(label);
        tabItem.setToolTipText(label);
        tabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                try {
                    CTabItem item;
                    if (e.getSource() instanceof CTabItem && (item = (CTabItem)e.getSource()).getText().startsWith("*") && LobViewDialog.this.updateItem != null) {
                        LobViewDialog.this.updateItem.setEnabled(false);
                    }
                }
                catch (Exception exception) {}
            }
        });
        ScrolledComposite sc = new ScrolledComposite((Composite)this.tabFolder, 2816);
        sc.setLayoutData((Object)new GridData(1808));
        Composite c = new Composite((Composite)sc, 128);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        c.setLayout((Layout)layout);
        c.setLayoutData((Object)new GridData(1808));
        Text text = new Text(c, 130);
        GridData gd = new GridData(1808);
        text.setLayoutData((Object)gd);
        text.setText(str);
        text.setEditable(false);
        text.setBackground(Display.getDefault().getSystemColor(1));
        text.setFont(DbPlugin.getDefaultFont());
        if (ORIGINAL.equals(label)) {
            this.orignalText = text;
        } else {
            this.newText = text;
        }
        sc.setContent((Control)c);
        sc.setMinSize(text.computeSize(-1, -1));
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        tabItem.setControl((Control)sc);
        this.tabFolder.setSelection(tabItem);
        this.removeTabItem();
    }

    private void removeTabItem() {
        CTabItem[] list = this.tabFolder.getItems();
        int i = 0;
        while (i < list.length - 1) {
            CTabItem control = list[i];
            if (!control.getText().equals(ORIGINAL)) {
                control.dispose();
            }
            ++i;
        }
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    private boolean selectedOriginalTabItem() {
        CTabItem item = this.tabFolder.getSelection();
        if (item != null) {
            return item.getText().equals(ORIGINAL);
        }
        return false;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.setReturnCode(buttonId);
            this.close();
        }
        super.buttonPressed(buttonId);
    }

    public boolean close() {
        try {
            CTabItem[] list;
            if (this.tabFolder != null && (list = this.tabFolder.getItems()) != null && list.length > 0 && list[list.length - 1].getText().startsWith("*") && !DbPlugin.getDefault().confirmDialog(Messages.getString("LobViewDialog.12"))) {
                return false;
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
        return super.close();
    }

    class DropdownSelectionListener
    extends SelectionAdapter {
        private ToolItem dropdown;
        private Menu menu;

        public DropdownSelectionListener(ToolItem dropdown) {
            this.dropdown = dropdown;
            this.menu = new Menu((Control)dropdown.getParent().getShell());
        }

        private void changeText(String charset) {
            LobViewDialog.this.pluginMgr.setValue("KEY_LOG_CHARSET", charset);
            if (LobViewDialog.this.selectedOriginalTabItem()) {
                if (LobViewDialog.this.originalData != null && LobViewDialog.this.orignalText != null) {
                    String text = LobViewDialog.this.orignalText.getText();
                    if (LobViewDialog.this.originalData instanceof byte[]) {
                        text = ByteArrayUtil.toString((byte[])LobViewDialog.this.originalData, charset);
                    }
                    LobViewDialog.this.orignalText.setText(text);
                }
            } else if (LobViewDialog.this.newData != null && LobViewDialog.this.newText != null) {
                String text = LobViewDialog.this.newText.getText();
                if (LobViewDialog.this.newData instanceof byte[]) {
                    text = ByteArrayUtil.toString((byte[])LobViewDialog.this.newData, charset);
                }
                LobViewDialog.this.newText.setText(text);
            }
        }

        public void add(String item) {
            MenuItem menuItem = new MenuItem(this.menu, 0);
            menuItem.setText(item);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ DropdownSelectionListener this$1;
                {
                    this.this$1 = dropdownSelectionListener;
                }

                public void widgetSelected(SelectionEvent event) {
                    MenuItem selected = (MenuItem)event.widget;
                    DropdownSelectionListener.access$0(this.this$1).setText(selected.getText());
                    String charset = selected.getText();
                    DropdownSelectionListener.access$1(this.this$1, charset);
                }
            });
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.detail == 4) {
                ToolItem item = (ToolItem)event.widget;
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                this.menu.setLocation(pt.x, pt.y + rect.height);
                this.menu.setVisible(true);
            } else {
                String charset = this.dropdown.getText();
                this.changeText(charset);
            }
        }

        static /* synthetic */ ToolItem access$0(DropdownSelectionListener dropdownSelectionListener) {
            return dropdownSelectionListener.dropdown;
        }

        static /* synthetic */ void access$1(DropdownSelectionListener dropdownSelectionListener, String string) {
            dropdownSelectionListener.changeText(string);
        }
    }
}

