/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.DefaultSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.actions.ConfirmConnectDBAction;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;
import zigen.plugin.db.ui.editors.TableViewEditorInput;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.jobs.TotalRecordCountSearchThread;

public class RecordCountForTableJob
extends AbstractJob {
    private Transaction trans;
    private ITable table;
    int dispCount;
    String condition;
    boolean doCalculate = false;

    public RecordCountForTableJob(Transaction trans, ITable table, String condition, int dispCount, boolean doCalculate) {
        super(Messages.getString("RecordCountForTableJob.0"));
        this.trans = trans;
        this.table = table;
        this.condition = condition;
        this.dispCount = dispCount;
        this.doCalculate = doCalculate;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (!this.doCalculate) {
                this.showResults(new SetTotalCountAction(this.dispCount));
                return Status.OK_STATUS;
            }
            if (!this.trans.isConneting()) {
                Display.getDefault().syncExec((Runnable)new ConfirmConnectDBAction(this.trans));
                if (!this.trans.isConneting()) {
                    this.showWarningMessage(DbPluginConstant.MSG_NO_CONNECTED_DB);
                    return Status.CANCEL_STATUS;
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            int timeout = this.store.getInt("PreferencePage.QueryTimeoutForCount");
            IDBConfig config = this.table.getDbConfig();
            ISQLCreatorFactory factory = DefaultSQLCreatorFactory.getFactory(config, null);
            String q = factory.createCountAll(this.condition);
            TotalRecordCountSearchThread t = new TotalRecordCountSearchThread(this.trans, q, timeout);
            Thread th = new Thread(t);
            th.start();
            if (timeout > 0) {
                th.join(timeout * 1000);
            } else {
                th.join();
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (t.isComplete) {
                this.showResults(new SetTotalCountAction(t.count));
            } else {
                this.showResults(new SetTotalCountAction(-1L));
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            DbPlugin.log(e);
            this.showResults(new SetTotalCountAction(-1L));
            return Status.OK_STATUS;
        }
    }

    protected class SetTotalCountAction
    implements Runnable {
        long totalCount;

        public SetTotalCountAction(long totalCount) {
            this.totalCount = totalCount;
        }

        public void run() {
            try {
                DbPlugin.getDefault().getPage();
                TableViewEditorInput input = new TableViewEditorInput(RecordCountForTableJob.this.trans.getConfig(), RecordCountForTableJob.this.table);
                IEditorPart editor = DbPlugin.getDefault().getPage().findEditor((IEditorInput)input);
                if (editor instanceof TableViewEditorFor31) {
                    TableViewEditorFor31 tEditor = (TableViewEditorFor31)editor;
                    tEditor.setTotalCount(RecordCountForTableJob.this.dispCount, this.totalCount);
                } else {
                    DbPlugin.log("A corresponding editor is not found.");
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        }
    }
}

