#include "FilePerser.h"

using namespace dcl;

CFilePerser::CFilePerser()
{
	m_file = NULL;
	m_current_pos = 0;
	m_transfer_syntax = EXPLICIT_LITTLE;
}

CFilePerser::~CFilePerser()
{
	Close();
}

/** ̃g[Nǂݍ
 *
 */
CResult CFilePerser::GetNext( const CToken** token )
{
	CResult result;
	*token = &m_token;
	m_token.Clear();
	VR_TYPE vr;

	if( !m_file ){
		result.SetCode( RESULT_FAILED );
		result.AddMessage( "t@CJĂ܂" );
		return result;
	}

	if( feof( m_file ) ){
		m_token.SetType( TOKEN_END_POS );
		result.SetCode( RESULT_GOOD );
		return result;
	}

	// t@CvAuǂݍ
	if( m_state.isStart() ){
		unsigned char buf[132];
		if( 132 >= fread( buf, 1, 132, m_file ) ){
			if( memcmp( &buf[128], "DICM", 4 ) == 0 ){
				m_token.SetData( buf, 128 );
				m_token.SetType( TOKEN_PREAMBLE );
				m_state.SetPrefixState();
				result.SetCode( RESULT_GOOD );
				m_current_pos = 128;
				fseek( m_file, 128, SEEK_SET );
				return result;
			}
		}

		m_transfer_syntax = IMPLICIT_LITTLE;
		fseek( m_file, 0, SEEK_SET );
		m_state.SetElementState();
	}

	// DICMvtBbNXǂݍ
	if( m_state.isPrefix() ){
		unsigned char buf[4];
		m_current_pos += fread( buf, 1, 4, m_file );
		m_token.SetData( buf, 4 );
		m_token.SetType( TOKEN_DICM );
		m_token.SetTagPos( m_current_pos );
		m_state.SetElementState();
		result.SetCode( RESULT_GOOD );
		return result;
	}

	// Ggǂݍ
	if( m_state.isElement() ){
		unsigned char buf[8];
		int len;
		int data_len;
		unsigned char* data;

		m_token.SetType( TOKEN_ELEMENT );
		m_token.SetTagPos( m_current_pos );


		// ^Oǂݍ
		len = fread( buf, 1, 8, m_file );
		if( len < 8 ){
			m_token.SetType( TOKEN_END_POS );
			result.SetCode( RESULT_GOOD );
			return result;
		}
		m_token.SetGroup( *((unsigned short*)&buf[0]) );
		m_token.SetElement( *((unsigned short*)&buf[2]) );
		m_current_pos += len;

		// VRAf[^ǂݍ -->
		if( m_token.GetGroup() == 0x0002 ){
			// ^^O(0002,xxxx)̓ǂݍ(KIVRgGfBA)
			result = ReadVRLenExplicitLittle( m_token.GetGroup(), m_token.GetElement(), &buf[4], m_file, m_current_pos, vr, data_len );

		} else {
			if( m_transfer_syntax == IMPLICIT_LITTLE ){
				// ÖٓIVR̓ǂݍ
				result = ReadVRLenImplicitLittle( m_token.GetGroup(), m_token.GetElement(), &buf[4], vr, data_len );

			} else {
				// IVR̓ǂݍ(rbOGfBÂƂ͍lĂȂ)
				result = ReadVRLenExplicitLittle( m_token.GetGroup(), m_token.GetElement(), &buf[4], m_file, m_current_pos, vr, data_len );
			}
		}

		if( result.Failed() ){
			m_token.SetType( TOKEN_END_POS );
			result.SetCode( RESULT_GOOD );
			return result;
		}
		// <--

		// VRZbg
		m_token.SetVR( vr );

		// f[^ǂݍ
		m_token.SetDataPos( m_current_pos );
		data = new unsigned char[_MAX(data_len,0)];

		len = fread( data, 1, _MAX(data_len,0), m_file );
		m_current_pos += len;
		m_token.SetData( data, _MIN(len,data_len) );

		// ]\̓ǂݍ
		if( m_token.GetGroup() == 0x0002 && m_token.GetElement() == 0x0010 ){
			unsigned char* cmpdata = new unsigned char[m_token.GetLength()+1];
			memcpy( cmpdata, m_token.GetData(), m_token.GetLength() );
			cmpdata[m_token.GetLength()] = 0;
			// ÖٓIVRH
			if( strcmp( (char*)cmpdata, TRANSFERLITTLEENDIAN_UID ) == 0 ){
				m_transfer_syntax = IMPLICIT_LITTLE;
			}
			delete [] cmpdata;
		}

		delete [] data;

		if( len < data_len ){
			m_token.SetFailLength( data_len );
			m_token.SetType( TOKEN_BLOKEN );
			result.SetCode( RESULT_GOOD );
			return result;
		} else {
			result.SetCode( RESULT_GOOD );
			return result;
		}
	
	} else {
		result.AddMessage( "ςȓԂɂȂĂ܂" );
		result.SetCode( RESULT_FAILED );
		return result;
	}
}

/** t@CJ
 *
 */
CResult CFilePerser::Open( const char* file_path )
{
	CResult result;

	if( m_file ){
		result.SetCode( RESULT_FAILED );
		result.AddMessage( "Ƀt@CJĂ܂" );
		return result;
	}

	m_file = fopen( file_path, "rb" );
	if( !m_file ){
		result.SetCode( RESULT_IO_FAILED );
		result.AddMessage( "t@C̃I[vɎs܂" );
		return result;
	}

	result.SetCode( RESULT_GOOD );
	return result;
}

/** t@C
 *
 */
CResult CFilePerser::Close()
{
	CResult result;

	if( m_file ){
		fclose( m_file );
		m_file = NULL;
	}

	result.SetCode( RESULT_GOOD );
	return result;
}

/** ^OVRƃf[^ǂݍ(ÖٓIVRp)
 *
 */
CResult CFilePerser::ReadVRLenImplicitLittle(
		unsigned short group  ,   // (in)  O[vԍ
		unsigned short element,   // (in)  Ggԍ
		unsigned char* p_vrlen,   // (in)  f[^ĂoCg(4ByteL)
		VR_TYPE&       vr     ,   // (out) VR^CvԂ
		int&           data_len ) // (out) f[^A
{
	string caption;
	// f[^擾
	data_len = *((int*)p_vrlen);

	// VR擾
	vr = GetStandardDictionary()->ConsultVR( group, element, caption );

	CResult result;
	result.SetCode( RESULT_GOOD );
	return result;
}

/** ^OVRƃf[^ǂݍ(IVRp)
 *
 */
CResult CFilePerser::ReadVRLenExplicitLittle(
			unsigned short group  ,     // (in)  O[vԍ
			unsigned short element,     // (in)  Ggԍ
			unsigned char* p_vrlen,     // (in) VRAf[^ĂoCg(4ByteL)
			FILE*          file,        // (in) t@Cnh
			unsigned long& current_pos, // (in/out) t@Cnȟ݂̈ʒu
			VR_TYPE&       vr,          // (out) VR^CvԂ
			int&           data_len )   // (out) f[^A
{
	CResult result;

	// f~^^OVRȂ
	if( ( group == 0xfffe && element == 0xe000 ) ||
		( group == 0xfffe && element == 0xe00d ) ||
		( group == 0xfffe && element == 0xe0dd ) ){
		// f[^擾
		data_len = *((int*)p_vrlen);

		// VR擾
		vr = VR_UN;

		result.SetCode( RESULT_GOOD );
		return result;
	}

	// IVRt@CVRoCg񂩂AVRʂ
	vr = SeeVR( p_vrlen );

	// f[^ǂݎ
	if( vr == VR_UN || vr == VR_OB || vr == VR_OW || vr == VR_SQ || vr == VR_UT ){
		// UNAOBAOWASQAUTȂf[^4oCgǂݍŉ͂
		unsigned char buf[4];
		int len = fread( buf, 1, 4, file );
		if( len < 4 ){
			//m_token.SetType( TOKEN_END_POS );
			result.SetCode( RESULT_FAILED );
			return result;
		}

		current_pos += len;
		data_len = *((int*)buf);

	} else {
		data_len = *((unsigned short*)&p_vrlen[2]);
		if( data_len == 0xffff ){
			data_len = -1;
		}
	}

	result.SetCode( RESULT_GOOD );
	return result;
}
