/** CListBuilder
 *
 *  @file ListBuilder.h
 *  @author Y.Kameda
 *  @date 2003/4/23
 *
 */

#ifndef INCLUDE_LIST_BUILDER_H
#define INCLUDE_LIST_BUILDER_H

#include "Builder.h"
#include "FilePerser.h"

namespace dcl{

class CElement;

/** CListBuilderNX
 *
 *  DICOMf[^ǂݍނ߂̃NXB
 *  CFilePerserƑgݍ킹邱ƂŁADICOMt@CǂݍށB
 *
 *  evfւ̃ANZX́AGetSequence()ŕԂCElementCX^X
 *  gčsB
 */
class CListBuilder : public CBuilder
{
	CElement* m_sequence;
public:
	CListBuilder();
	virtual ~CListBuilder();
	virtual CResult Load();

	string GetTransferSyntax();
	CElement* GetSequence();

private:
	CResult LoadSequence( CElement* parent, CPerser* perser, int length );
	CResult LoadSequences( CElement* parent, CPerser* perser );
};

enum ELEMENT_TYPE{
	ELEMENT_START_DELIMITER,
	ELEMENT_END_DELIMITER,
	ELEMENT_NORMAL
};

/** DICOMt@Cǂݍ݂̂߂̂܂Ƃ߃NX
 *
 *  CFilePerser  CListBuilder ̃bp(Facadep^[)
 */
class CDicomFileReader
{
	 CListBuilder m_builder;
	 CFilePerser  m_perser;
public:

	CDicomFileReader(){
		m_builder.BindPerser( &m_perser );
	}

	CResult Load( const char* file_path ){
		CResult result;
		result = m_perser.Open( file_path );
		if( result.Succeed() ){
			result = m_builder.Load();
			m_perser.Close();
		}

		return result;
	}

	CElement* GetSequence(){
		return m_builder.GetSequence();
	}
};

/** DICOMvfNX
 *
 *  DICOMvf(CElement̗BȌV[PXƌĂ)́AKELEMENT_START_DELIMITER^Cv
 *  Ŏn܂AELEMENT_END_DELIMITER^CvŏIB̑͑SELEMENT_NORMAL
 *  vfłAELEMENT_START_DELIMITERELEMENT_END_DELIMITER̊Ԃɑ݂B
 *  V[PX̃O[vԍAGgԍ͏Ƀ\[gB
 *  vf̒ǉA폜m_typeELEMENT_START_DELIMITERCElementsB̑
 */
class CElement
{
	friend class CListBuilder;

	CElement( ELEMENT_TYPE );
	~CElement();

	ELEMENT_TYPE   m_type;
	unsigned short m_group;
	unsigned short m_element;
	VR_TYPE        m_vr;
	int            m_length;
	unsigned char* m_data;

	vector<CElement*> m_sequence;

	CElement* m_next;
	CElement* m_prev;
public:

	// 擾
	ELEMENT_TYPE   GetType() const;       ///< GgނԂ
	unsigned short GetGroup() const;      ///< O[vԍԂ
	unsigned short GetElement() const;    ///< GgԍԂ
	VR_TYPE        GetVR() const;         ///< 3ByteڂNULL~߂ꂽVRԂB
	int            GetLength() const;     ///< f[^
	const unsigned char* GetData() const; ///< f[^ւ̃|C^BNULL͕ԂȂB
	CElement* SearchElement( unsigned short group, unsigned short element );

	// f[^Zbg
	void SetData( const unsigned char* data, int length); /// f[^Zbg

	// ʃV[PX
	int       CountSequence();
	CElement* GetSequence( int index );
	CResult   InsertSequence( int index );
	CResult   RemoveSequence( int index );

	// ړ
	CElement* GetNext();
	CElement* GetPrev();

	// vf̒ǉA폜
	CResult AddElement( unsigned short group, unsigned short element, const unsigned char* data, int length, VR_TYPE vr );
	CResult AddElement( unsigned short group, unsigned short element, const unsigned char* data, int length ); ///< VR͎ɏ]ĎŌ߂
	CResult RemoveElement( unsigned short group, unsigned short elment );
	CResult RemoveGroup( unsigned short group );

private:
	CElement* CreateElement( CElement* e, unsigned short group, unsigned short element );
};

};

#endif
