#include "Result.h"

using namespace dcl;

CResult::CResult()
:m_result( RESULT_GOOD )
{
}

void CResult::AddMessage( const char* message )
{
	m_message_array.push_back( message );
}

void CResult::SetCode( RESULT result )
{
	m_result = result;
}

CResult& CResult::operator=( const CResult& rhs )
{
	if( this != &rhs ){
		m_result = rhs.m_result;
		m_message_array.clear();
		m_message_array = rhs.m_message_array;
	}

	return *this;
}

bool CResult::Failed()
{
	if( m_result != RESULT_GOOD ){
		return true;
	}

	return false;
}


bool CResult::Succeed()
{
	if( m_result == RESULT_GOOD ){
		return true;
	}

	return false;
}

string CResult::Message()
{
	if( m_message_array.size() > 0 ){
		return m_message_array[0];
	}

	return "G[bZ[W̓ZbgĂ܂";
}

/*
CMyString::CMyString(){
	m_buf=new char[1];
	m_buf[0]=0;
	m_buf_len=1;
}
*/

CMyString::CMyString( const char* src/*=""*/ ){
	m_buf=new char[strlen(src)+1];
	m_buf_len=strlen(src)+1;
	strcpy(m_buf,src);
}

CMyString::CMyString( const CMyString& rhs )
{
	m_buf=new char[strlen(rhs.m_buf)+1];
	m_buf_len=strlen(rhs.m_buf)+1;
	strcpy(m_buf,rhs.m_buf);
}

CMyString& CMyString::operator=( const CMyString& rhs ){
	if( this != &rhs ){
		if( strlen( rhs.m_buf ) + 1 > m_buf_len ){
			delete [] m_buf;
			m_buf = new char[strlen( rhs.m_buf ) + 1];
			m_buf_len = strlen( rhs ) + 1;
			strcpy( m_buf, rhs.m_buf );
		}
	}
	return *this;
}

CMyString& CMyString::operator=( const char* rhs ){
	if( rhs != m_buf ){
		if( strlen( rhs ) + 1 > m_buf_len ){
			delete [] m_buf;
			m_buf = new char[strlen( rhs ) + 1];
			m_buf_len = strlen( rhs ) + 1;
			strcpy( m_buf, rhs );
		}
	}

	return *this;
}

CMyString::~CMyString(){
	delete [] m_buf;
}

CMyString::operator LPCSTR() const{
	return m_buf;
}
