#ifndef INCLUDE_DICT_DATA_H
#define INCLUDE_DICT_DATA_H

using namespace dcl;

CDictionary::CKey g_key[] = {
	{ 0x0000, 0x0000, VR_UL, "Group 0000 Length" },
	{ 0x0000, 0x0001, VR_UL, "Group 0000 Length to End (RET)" },
	{ 0x0000, 0x0002, VR_UI, "Affected SOP Class UID" },
	{ 0x0000, 0x0003, VR_UI, "Requested SOP Class UID" },
	{ 0x0000, 0x0010, VR_SH, "Recognition Code (RET)" },
	{ 0x0000, 0x0100, VR_US, "Command Field" },
	{ 0x0000, 0x0110, VR_US, "Message ID" },
	{ 0x0000, 0x0120, VR_US, "Message Id being Responded to" },
	{ 0x0000, 0x0200, VR_AE, "Initiator (RET)" },
	{ 0x0000, 0x0300, VR_AE, "Receiver (RET)" },
	{ 0x0000, 0x0400, VR_AE, "Find Location (RET)" },
	{ 0x0000, 0x0600, VR_AE, "Move Destination" },
	{ 0x0000, 0x0700, VR_US, "Priority" },
	{ 0x0000, 0x0800, VR_US, "Data Set Type" },
	{ 0x0000, 0x0850, VR_US, "Number of Matches (RET)" },
	{ 0x0000, 0x0860, VR_US, "Response Sequence Number (RET)" },
	{ 0x0000, 0x0900, VR_US, "Status" },
	{ 0x0000, 0x0901, VR_AT, "Offending Element" },
	{ 0x0000, 0x0902, VR_LO, "Error Comment" },
	{ 0x0000, 0x0903, VR_US, "Error ID" },
	{ 0x0000, 0x1000, VR_UI, "Affected SOP Instance UID" },
	{ 0x0000, 0x1001, VR_UI, "Requested SOP Instance UID" },
	{ 0x0000, 0x1002, VR_US, "Event Type ID" },
	{ 0x0000, 0x1005, VR_AT, "Attribute Identifier List" },
	{ 0x0000, 0x1008, VR_US, "Action Type ID" },
	{ 0x0000, 0x1012, VR_UI, "Requested SOP Instance UID List" },
	{ 0x0000, 0x1020, VR_US, "Number of Remaining Sub-operations" },
	{ 0x0000, 0x1021, VR_US, "Number of Completed Sub-operations" },
	{ 0x0000, 0x1022, VR_US, "Number of Failed Sub-operations" },
	{ 0x0000, 0x1023, VR_US, "Number of Warning Sub-operations" },
	{ 0x0000, 0x1030, VR_AE, "Move Originator Application Entity Title" },
	{ 0x0000, 0x1031, VR_US, "Move Originator Message ID" },
	{ 0x0000, 0x5010, VR_LO, "Message Set ID (RET)" },
	{ 0x0000, 0x5020, VR_LO, "End Message Set ID (RET)" },
	{ 0x0002, 0x0000, VR_UL, "Group 0002 Length" },
	{ 0x0002, 0x0001, VR_OB, "File Meta Information Version" },
	{ 0x0002, 0x0002, VR_UI, "Media Stored SOP Class UID" },
	{ 0x0002, 0x0003, VR_UI, "Media Stored SOP Instance UID" },
	{ 0x0002, 0x0010, VR_UI, "Transfer Syntax UID" },
	{ 0x0002, 0x0012, VR_UI, "Implementation Class UID" },
	{ 0x0002, 0x0013, VR_SH, "Implementation Version Name" },
	{ 0x0002, 0x0016, VR_AE, "Source Application Entity Title" },
	{ 0x0002, 0x0100, VR_UI, "Private Information Creator UID" },
	{ 0x0002, 0x0102, VR_OB, "Private Information" },
	{ 0x0004, 0x0000, VR_UL, "Group 0004 Length" },
	{ 0x0004, 0x1130, VR_CS, "File-set ID" },
	{ 0x0004, 0x1141, VR_CS, "File-set Descriptor File File ID" },
	{ 0x0004, 0x1142, VR_CS, "File-set Descriptor File Format" },
	{ 0x0004, 0x1200, VR_UL, "Root Directory Entity's First Directory Record Offset" },
	{ 0x0004, 0x1202, VR_UL, "Root Directory Entity's Last Directory Record Offset" },
	{ 0x0004, 0x1212, VR_US, "File-set Consistence Flag" },
	{ 0x0004, 0x1220, VR_SQ, "Directory Record Sequence" },
	{ 0x0004, 0x1400, VR_UL, "Next Directory Record Offset" },
	{ 0x0004, 0x1410, VR_US, "Record In-use Flag" },
	{ 0x0004, 0x1420, VR_UL, "Referenced Lower-level Directory Entity Offset" },
	{ 0x0004, 0x1430, VR_CS, "Directory Record Type" },
	{ 0x0004, 0x1432, VR_UI, "Private Record UID" },
	{ 0x0004, 0x1500, VR_CS, "Referenced File ID" },
	{ 0x0004, 0x1510, VR_UI, "Referenced SOP Class UID in File" },
	{ 0x0004, 0x1511, VR_UI, "Referenced SOP Instance UID in File" },
	{ 0x0004, 0x1600, VR_UL, "Number of References" },
	{ 0x0008, 0x0000, VR_UL, "Group 0008 Length" },
	{ 0x0008, 0x0001, VR_UL, "Group 0008 Length to End (RET)" },
	{ 0x0008, 0x0005, VR_CS, "Specific Character Set" },
	{ 0x0008, 0x0008, VR_CS, "Image Type" },
	{ 0x0008, 0x0010, VR_SH, "Recognition Code (RET)" },
	{ 0x0008, 0x0012, VR_DA, "Instance Creation Date" },
	{ 0x0008, 0x0013, VR_TM, "Instance Creation Time" },
	{ 0x0008, 0x0014, VR_UI, "Instance Creator UID" },
	{ 0x0008, 0x0016, VR_UI, "SOP Class UID" },
	{ 0x0008, 0x0018, VR_UI, "SOP Instance UID" },
	{ 0x0008, 0x0020, VR_DA, "Study Date" },
	{ 0x0008, 0x0021, VR_DA, "Series Date" },
	{ 0x0008, 0x0022, VR_DA, "Acquisition Date" },
	{ 0x0008, 0x0023, VR_DA, "Image Date" },
	{ 0x0008, 0x0024, VR_DA, "Overlay Date" },
	{ 0x0008, 0x0025, VR_DA, "Curve Date" },
	{ 0x0008, 0x0030, VR_TM, "Study Time" },
	{ 0x0008, 0x0031, VR_TM, "Series Time" },
	{ 0x0008, 0x0032, VR_TM, "Acquisition Time" },
	{ 0x0008, 0x0033, VR_TM, "Image Time" },
	{ 0x0008, 0x0034, VR_TM, "Overlay Time" },
	{ 0x0008, 0x0035, VR_TM, "Curve Time" },
	{ 0x0008, 0x0040, VR_US, "Data Set Type (RET)" },
	{ 0x0008, 0x0041, VR_SH, "Data Set Subtype (RET)" },
	{ 0x0008, 0x0042, VR_CS, "Nuclear Medicine Series Type" },
	{ 0x0008, 0x0050, VR_SH, "Accession Number" },
	{ 0x0008, 0x0052, VR_CS, "Query/Retrieve Level" },
	{ 0x0008, 0x0054, VR_AE, "Retrieve AE Title" },
	{ 0x0008, 0x0058, VR_AE, "Failed SOP Instance UID List" },
	{ 0x0008, 0x0060, VR_CS, "Modality" },
	{ 0x0008, 0x0064, VR_CS, "Conversion Type" },
	{ 0x0008, 0x0070, VR_LO, "Manufacturer" },
	{ 0x0008, 0x0080, VR_LO, "Institution Name" },
	{ 0x0008, 0x0081, VR_ST, "Institution Address" },
	{ 0x0008, 0x0082, VR_SQ, "Institution Code Sequence" },
	{ 0x0008, 0x0090, VR_PN, "Referring Physician's Name" },
	{ 0x0008, 0x0092, VR_ST, "Referring Physician's Address" },
	{ 0x0008, 0x0094, VR_SH, "Referring Physician's Telephone Numbers" },
	{ 0x0008, 0x0100, VR_SH, "Code Value" },
	{ 0x0008, 0x0102, VR_SH, "Coding Scheme Designator" },
	{ 0x0008, 0x0104, VR_LO, "Code Meaning" },
	{ 0x0008, 0x1000, VR_SH, "Network ID (RET)" },
	{ 0x0008, 0x1010, VR_SH, "Station Name" },
	{ 0x0008, 0x1030, VR_LO, "Study Description" },
	{ 0x0008, 0x1032, VR_SQ, "Procedure Code Sequence" },
	{ 0x0008, 0x103E, VR_LO, "Series Description" },
	{ 0x0008, 0x1040, VR_LO, "Institutional Department Name" },
	{ 0x0008, 0x1050, VR_PN, "Attending Physician's Name" },
	{ 0x0008, 0x1060, VR_PN, "Name of Physician(s) Reading Study" },
	{ 0x0008, 0x1070, VR_PN, "Operator's Name" },
	{ 0x0008, 0x1080, VR_LO, "Admitting Diagnoses Description" },
	{ 0x0008, 0x1084, VR_SQ, "Admitting Diagnosis Code Sequence" },
	{ 0x0008, 0x1090, VR_LO, "Manufacturer's Model Name" },
	{ 0x0008, 0x1100, VR_SQ, "Referenced Results Sequence" },
	{ 0x0008, 0x1110, VR_SQ, "Referenced Study Sequence" },
	{ 0x0008, 0x1111, VR_SQ, "Referenced Study Component Sequence" },
	{ 0x0008, 0x1115, VR_SQ, "Referenced Series Sequence" },
	{ 0x0008, 0x1120, VR_SQ, "Referenced Patient Sequence" },
	{ 0x0008, 0x1125, VR_SQ, "Referenced Visit Sequence" },
	{ 0x0008, 0x1130, VR_SQ, "Referenced Overlay Sequence" },
	{ 0x0008, 0x1140, VR_SQ, "Referenced Image Sequence" },
	{ 0x0008, 0x1145, VR_SQ, "Referenced Curve Sequence" },
	{ 0x0008, 0x1150, VR_UI, "Referenced SOP Class UID" },
	{ 0x0008, 0x1155, VR_UI, "Referenced SOP Instance UID" },
	{ 0x0008, 0x2111, VR_ST, "Derivation Description" },
	{ 0x0008, 0x2112, VR_SQ, "Source Image Sequence" },
	{ 0x0008, 0x2120, VR_SH, "Stage Name" },
	{ 0x0008, 0x2122, VR_IS, "Stage Number" },
	{ 0x0008, 0x2124, VR_IS, "Number of Stages" },
	{ 0x0008, 0x2129, VR_IS, "Number of Event Timers" },
	{ 0x0008, 0x2128, VR_IS, "View Number" },
	{ 0x0008, 0x212A, VR_IS, "Number of Views in Stage" },
	{ 0x0008, 0x2130, VR_DS, "Event Elapsed Time(s)" },
	{ 0x0008, 0x2132, VR_LO, "Event Timer Name(s)" },
	{ 0x0008, 0x2142, VR_IS, "Start Trim" },
	{ 0x0008, 0x2143, VR_IS, "Stop Trim" },
	{ 0x0008, 0x2144, VR_IS, "Recommended Display Frame Rate" },
	{ 0x0008, 0x2200, VR_CS, "Transducer Position" },
	{ 0x0008, 0x2204, VR_CS, "Transducer Orientation" },
	{ 0x0008, 0x2208, VR_CS, "Anatomic Structure" },
	{ 0x0008, 0x4000, VR_SH, "Group 0008 Comments (RET)" },
	{ 0x0010, 0x0000, VR_UL, "Group 0010 Length" },
	{ 0x0010, 0x0010, VR_PN, "Patient's Name" },
	{ 0x0010, 0x0020, VR_LO, "Patient ID" },
	{ 0x0010, 0x0021, VR_LO, "Issuer of Patient ID" },
	{ 0x0010, 0x0030, VR_DA, "Patient's Birth Date" },
	{ 0x0010, 0x0032, VR_TM, "Patient's Birth Time" },
	{ 0x0010, 0x0040, VR_CS, "Patient's Sex" },
	{ 0x0010, 0x0042, VR_SH, "Patient's Social Security Number" },
	{ 0x0010, 0x0050, VR_SQ, "Patient's Insurance Plan Code Sequence" },
	{ 0x0010, 0x1000, VR_LO, "Other Patient IDs" },
	{ 0x0010, 0x1001, VR_PN, "Other Patient Names" },
	{ 0x0010, 0x1005, VR_PN, "Patient's Maiden Name" },
	{ 0x0010, 0x1010, VR_AS, "Patient's Age" },
	{ 0x0010, 0x1020, VR_DS, "Patient's Size" },
	{ 0x0010, 0x1030, VR_DS, "Patient's Weight" },
	{ 0x0010, 0x1040, VR_LO, "Patient's Address" },
	{ 0x0010, 0x1050, VR_SH, "Insurance Plan Identification (RET)" },
	{ 0x0010, 0x1060, VR_PN, "Patient's Mother's Maiden Name" },
	{ 0x0010, 0x1080, VR_LO, "Military Rank" },
	{ 0x0010, 0x1081, VR_LO, "Branch of Service" },
	{ 0x0010, 0x1090, VR_LO, "Medical Record Locator" },
	{ 0x0010, 0x2000, VR_LO, "Medical Alerts" },
	{ 0x0010, 0x2110, VR_LO, "Contrast Allergies" },
	{ 0x0010, 0x2150, VR_LO, "Country of Residence" },
	{ 0x0010, 0x2152, VR_LO, "Region of Residence" },
	{ 0x0010, 0x2154, VR_SH, "Patient's Telephone Numbers" },
	{ 0x0010, 0x2160, VR_SH, "Ethnic Group" },
	{ 0x0010, 0x2180, VR_SH, "Occupation" },
	{ 0x0010, 0x21A0, VR_CS, "Smoking Status" },
	{ 0x0010, 0x21B0, VR_LT, "Additional Patient History" },
	{ 0x0010, 0x21C0, VR_US, "Pregnancy Status" },
	{ 0x0010, 0x21D0, VR_DA, "Last Menstrual Date" },
	{ 0x0010, 0x21F0, VR_LO, "Patient's Religious Preference" },
	{ 0x0010, 0x4000, VR_LT, "Patient Comments" },
	{ 0x0018, 0x0000, VR_UL, "Group 0018 Length" },
	{ 0x0018, 0x0010, VR_LO, "Contrast/Bolus Agent" },
	{ 0x0018, 0x0015, VR_CS, "Body Part Examined" },
	{ 0x0018, 0x0020, VR_CS, "Scanning Sequence" },
	{ 0x0018, 0x0021, VR_CS, "Sequence Variant" },
	{ 0x0018, 0x0022, VR_CS, "Scan Options" },
	{ 0x0018, 0x0023, VR_CS, "MR Acquisition Type" },
	{ 0x0018, 0x0024, VR_SH, "Sequence Name" },
	{ 0x0018, 0x0025, VR_CS, "Angio Flag" },
	{ 0x0018, 0x0030, VR_LO, "Radionuclide" },
	{ 0x0018, 0x0031, VR_LO, "Radiopharmaceutical" },
	{ 0x0018, 0x0032, VR_DS, "Energy Window Centerline" },
	{ 0x0018, 0x0033, VR_DS, "Energy Window Total Width" },
	{ 0x0018, 0x0034, VR_LO, "Intervention Drug Name" },
	{ 0x0018, 0x0035, VR_TM, "Intervention Drug Start Time" },
	{ 0x0018, 0x0040, VR_IS, "Cine Rate" },
	{ 0x0018, 0x0050, VR_DS, "Slice Thickness" },
	{ 0x0018, 0x0060, VR_DS, "KVP" },
	{ 0x0018, 0x0070, VR_IS, "Counts Accumulated" },
	{ 0x0018, 0x0071, VR_CS, "Acquisition Termination Condition" },
	{ 0x0018, 0x0072, VR_DS, "Effective Series Duration" },
	{ 0x0018, 0x0080, VR_DS, "Repetition Time" },
	{ 0x0018, 0x0081, VR_DS, "Echo Time" },
	{ 0x0018, 0x0082, VR_DS, "Inversion Time" },
	{ 0x0018, 0x0083, VR_DS, "Number of Averages" },
	{ 0x0018, 0x0084, VR_DS, "Imaging Frequency" },
	{ 0x0018, 0x0085, VR_SH, "Imaged Nucleus" },
	{ 0x0018, 0x0086, VR_IS, "Echo Numbers(s)" },
	{ 0x0018, 0x0087, VR_DS, "Magnetic Field Strength" },
	{ 0x0018, 0x0088, VR_DS, "Spacing Between Slices" },
	{ 0x0018, 0x0089, VR_IS, "Number of Phase Encoding Steps" },
	{ 0x0018, 0x0090, VR_DS, "Data Collection Diameter" },
	{ 0x0018, 0x0091, VR_IS, "Echo Train Length" },
	{ 0x0018, 0x0093, VR_DS, "Percent Sampling" },
	{ 0x0018, 0x0094, VR_DS, "Percent Phase Field of View" },
	{ 0x0018, 0x0095, VR_DS, "Pixel Bandwidth" },
	{ 0x0018, 0x1000, VR_LO, "Device Serial Number" },
	{ 0x0018, 0x1004, VR_LO, "Plate ID" },
	{ 0x0018, 0x1010, VR_LO, "Secondary Capture Device ID" },
	{ 0x0018, 0x1012, VR_DA, "Date of Secondary Capture" },
	{ 0x0018, 0x1014, VR_TM, "Time of Secondary Capture" },
	{ 0x0018, 0x1016, VR_LO, "Secondary Capture Device Manufacturer" },
	{ 0x0018, 0x1018, VR_LO, "Secondary Capture Device Manufacturer's Model Name" },
	{ 0x0018, 0x1019, VR_LO, "Secondary Capture Device Software Version(s)" },
	{ 0x0018, 0x1020, VR_LO, "Software Versions(s)" },
	{ 0x0018, 0x1022, VR_SH, "Video Image Format Acquired" },
	{ 0x0018, 0x1023, VR_LO, "Digital Image Format Acquired" },
	{ 0x0018, 0x1030, VR_LO, "Protocol Name" },
	{ 0x0018, 0x1040, VR_LO, "Contrast/Bolus Route" },
	{ 0x0018, 0x1041, VR_DS, "Contrast/Bolus Volume" },
	{ 0x0018, 0x1042, VR_TM, "Contrast/Bolus Start Time" },
	{ 0x0018, 0x1043, VR_TM, "Contrast/Bolus Stop Time" },
	{ 0x0018, 0x1044, VR_DS, "Contrast/Bolus Total Dose" },
	{ 0x0018, 0x1045, VR_IS, "Syringe Counts" },
	{ 0x0018, 0x1050, VR_DS, "Spatial Resolution" },
	{ 0x0018, 0x1060, VR_DS, "Trigger Time" },
	{ 0x0018, 0x1061, VR_LO, "Trigger Source or Type" },
	{ 0x0018, 0x1062, VR_IS, "Nominal Interval" },
	{ 0x0018, 0x1063, VR_DS, "Frame Time" },
	{ 0x0018, 0x1064, VR_LO, "Framing Type" },
	{ 0x0018, 0x1065, VR_DS, "Frame Time Vector" },
	{ 0x0018, 0x1066, VR_DS, "Frame Delay" },
	{ 0x0018, 0x1070, VR_LO, "Radionuclide Route" },
	{ 0x0018, 0x1071, VR_DS, "Radionuclide Volume" },
	{ 0x0018, 0x1072, VR_TM, "Radionuclide Start Time" },
	{ 0x0018, 0x1073, VR_TM, "Radionuclide Stop Time" },
	{ 0x0018, 0x1074, VR_DS, "Radionuclide Total Dose" },
	{ 0x0018, 0x1080, VR_CS, "Beat Rejection Flag" },
	{ 0x0018, 0x1081, VR_IS, "Low R-R Value" },
	{ 0x0018, 0x1082, VR_IS, "High R-R Value" },
	{ 0x0018, 0x1083, VR_IS, "Intervals Acquired" },
	{ 0x0018, 0x1084, VR_IS, "Intervals Rejected" },
	{ 0x0018, 0x1085, VR_LO, "PVC Rejection" },
	{ 0x0018, 0x1086, VR_IS, "Skip Beats" },
	{ 0x0018, 0x1088, VR_IS, "Heart Rate" },
	{ 0x0018, 0x1090, VR_IS, "Cardiac Number of Images" },
	{ 0x0018, 0x1094, VR_IS, "Trigger Window" },
	{ 0x0018, 0x1100, VR_DS, "Reconstruction Diameter" },
	{ 0x0018, 0x1110, VR_DS, "Distance Source to Detector" },
	{ 0x0018, 0x1111, VR_DS, "Distance Source to Patient" },
	{ 0x0018, 0x1120, VR_DS, "Gantry/Detector Tilt" },
	{ 0x0018, 0x1030, VR_DS, "Table Height" },
	{ 0x0018, 0x1131, VR_DS, "Table Traverse" },
	{ 0x0018, 0x1140, VR_CS, "Rotation Direction" },
	{ 0x0018, 0x1141, VR_DS, "Angular Position" },
	{ 0x0018, 0x1142, VR_DS, "Radial Position" },
	{ 0x0018, 0x1143, VR_DS, "Scan Arc" },
	{ 0x0018, 0x1144, VR_DS, "Angular Step" },
	{ 0x0018, 0x1145, VR_DS, "Center of Rotation Offset" },
	{ 0x0018, 0x1146, VR_DS, "Rotation Offset" },
	{ 0x0018, 0x1147, VR_CS, "Field of View Shape" },
	{ 0x0018, 0x1149, VR_IS, "Field of View Dimensions(s)" },
	{ 0x0018, 0x1150, VR_IS, "Exposure Time" },
	{ 0x0018, 0x1151, VR_IS, "X-ray Tube Current" },
	{ 0x0018, 0x1152, VR_IS, "Exposure" },
	{ 0x0018, 0x1160, VR_SH, "Filter Type" },
	{ 0x0018, 0x1170, VR_IS, "Generator Power" },
	{ 0x0018, 0x1180, VR_SH, "Collimator/grid Name" },
	{ 0x0018, 0x1181, VR_CS, "Collimator Type" },
	{ 0x0018, 0x1182, VR_IS, "Focal Distance" },
	{ 0x0018, 0x1183, VR_DS, "X Focus Center" },
	{ 0x0018, 0x1184, VR_DS, "Y Focus Center" },
	{ 0x0018, 0x1190, VR_DS, "Focal Spot(s)" },
	{ 0x0018, 0x1200, VR_DA, "Date of Last Calibration" },
	{ 0x0018, 0x1201, VR_TM, "Time of Last Calibration" },
	{ 0x0018, 0x1210, VR_SH, "Convolution Kernel" },
	{ 0x0018, 0x1240, VR_DS, "Upper/Lower Pixel Values (RET)" },
	{ 0x0018, 0x1242, VR_IS, "Actual Frame Duration" },
	{ 0x0018, 0x1243, VR_IS, "Count Rate" },
	{ 0x0018, 0x1250, VR_SH, "Receiving Coil" },
	{ 0x0018, 0x1151, VR_SH, "Transmitting Coil" },
	{ 0x0018, 0x1160, VR_SH, "Screen Type" },
	{ 0x0018, 0x1261, VR_LO, "Phosphor Type" },
	{ 0x0018, 0x1300, VR_IS, "Scan Velocity" },
	{ 0x0018, 0x1301, VR_CS, "Whole Body Technique" },
	{ 0x0018, 0x1302, VR_IS, "Scan Length" },
	{ 0x0018, 0x1310, VR_US, "Acquisition Matrix" },
	{ 0x0018, 0x1312, VR_CS, "Phase Encoding Direction" },
	{ 0x0018, 0x1314, VR_DS, "Flip Angle" },
	{ 0x0018, 0x1315, VR_CS, "Variable Flip Angle Flag" },
	{ 0x0018, 0x1316, VR_DS, "SAR" },
	{ 0x0018, 0x1318, VR_DS, "dB/dt" },
	{ 0x0018, 0x1400, VR_LO, "Acquisition Device Processing Description" },
	{ 0x0018, 0x1401, VR_LO, "Acquisition Device Processing Code" },
	{ 0x0018, 0x1402, VR_CS, "Cassette Orientation" },
	{ 0x0018, 0x1403, VR_CS, "Cassette Size" },
	{ 0x0018, 0x1404, VR_US, "Exposures on Plate" },
	{ 0x0018, 0x1405, VR_IS, "Relative X-ray Exposure" },
	{ 0x0018, 0x4000, VR_SH, "Group 0018 Comments (RET)" },
	{ 0x0018, 0x5000, VR_SH, "Output Power" },
	{ 0x0018, 0x5010, VR_LO, "Transducer Data" },
	{ 0x0018, 0x5012, VR_DS, "Focus Depth" },
	{ 0x0018, 0x5020, VR_LO, "Preprocessing Function" },
	{ 0x0018, 0x5021, VR_LO, "Postprocessing Function" },
	{ 0x0018, 0x5022, VR_DS, "Mechanical Index" },
	{ 0x0018, 0x5024, VR_DS, "Thermal Index" },
	{ 0x0018, 0x5026, VR_DS, "Cranial Thermal Index" },
	{ 0x0018, 0x5027, VR_DS, "Soft Tissue Thermal Index" },
	{ 0x0018, 0x5028, VR_DS, "Soft Tissue-focus Thermal Index" },
	{ 0x0018, 0x5029, VR_DS, "Soft Tissue-surface Thermal Index" },
	{ 0x0018, 0x5030, VR_IS, "Dynamic Range (RET)" },
	{ 0x0018, 0x5040, VR_IS, "Total Gain (RET)" },
	{ 0x0018, 0x5050, VR_IS, "Depth of Scan Field" },
	{ 0x0018, 0x5100, VR_CS, "Patient Position" },
	{ 0x0018, 0x5101, VR_CS, "View Position" },
	{ 0x0018, 0x5210, VR_DS, "Image Transformation Matrix" },
	{ 0x0018, 0x5212, VR_DS, "Image Translation Vector" },
	{ 0x0018, 0x6000, VR_DS, "Sensitivity" },
	{ 0x0018, 0x6011, VR_SQ, "Sequence of Ultrasound Regions" },
	{ 0x0018, 0x6012, VR_US, "Region Spatial Format" },
	{ 0x0018, 0x6014, VR_US, "Region Data Type" },
	{ 0x0018, 0x6016, VR_UL, "Region Flags" },
	{ 0x0018, 0x6018, VR_UL, "Region Location Min X0" },
	{ 0x0018, 0x601A, VR_UL, "Region Location Min Y0" },
	{ 0x0018, 0x601C, VR_UL, "Region Location Max X1" },
	{ 0x0018, 0x601E, VR_UL, "Region Location Max Y1" },
	{ 0x0018, 0x6020, VR_SL, "Reference Pixel X0" },
	{ 0x0018, 0x6022, VR_SL, "Reference Pixel Y0" },
	{ 0x0018, 0x6024, VR_US, "Physical Units X Direction" },
	{ 0x0018, 0x6026, VR_US, "Physical Units Y Direction" },
	{ 0x0018, 0x1628, VR_FD, "Reference Pixel Physical Value X" },
	{ 0x0018, 0x602A, VR_FD, "Reference Pixel Physical Value Y" },
	{ 0x0018, 0x602C, VR_FD, "Physical Delta X" },
	{ 0x0018, 0x602E, VR_FD, "Physical Delta Y" },
	{ 0x0018, 0x6030, VR_UL, "Transducer Frequency" },
	{ 0x0018, 0x6031, VR_CS, "Transducer Type" },
	{ 0x0018, 0x6032, VR_UL, "Pulse Repetition Frequency" },
	{ 0x0018, 0x6034, VR_FD, "Doppler Correction Angle" },
	{ 0x0018, 0x6036, VR_FD, "Sterring Angle" },
	{ 0x0018, 0x6038, VR_UL, "Doppler Sample Volume X Position" },
	{ 0x0018, 0x603A, VR_UL, "Doppler Sample Volume Y Position" },
	{ 0x0018, 0x603C, VR_UL, "TM-Line Position X0" },
	{ 0x0018, 0x603E, VR_UL, "TM-Line Position Y0" },
	{ 0x0018, 0x6040, VR_UL, "TM-Line Position X1" },
	{ 0x0018, 0x6042, VR_UL, "TM-Line Position Y1" },
	{ 0x0018, 0x6044, VR_US, "Pixel Component Organization" },
	{ 0x0018, 0x6046, VR_UL, "Pixel Component Organization" },
	{ 0x0018, 0x6048, VR_UL, "Pixel Component Range Start" },
	{ 0x0018, 0x604A, VR_UL, "Pixel Component Range Stop" },
	{ 0x0018, 0x604C, VR_US, "Pixel Component Physical Units" },
	{ 0x0018, 0x604E, VR_US, "Pixel Component Data Type" },
	{ 0x0018, 0x6050, VR_UL, "Number of Table Break Points" },
	{ 0x0018, 0x6052, VR_UL, "Table of X Break Points" },
	{ 0x0018, 0x6054, VR_FD, "Table of Y Break Points" },
	{ 0x0020, 0x0000, VR_UL, "Group 0020 Length" },
	{ 0x0020, 0x000D, VR_UI, "Study Instance UID" },
	{ 0x0020, 0x000E, VR_UI, "Series Instance UID" },
	{ 0x0020, 0x0010, VR_SH, "Study ID" },
	{ 0x0020, 0x0011, VR_IS, "Series Number" },
	{ 0x0020, 0x0012, VR_IS, "Acquisition Number" },
	{ 0x0020, 0x0013, VR_IS, "Image Number" },
	{ 0x0020, 0x0014, VR_IS, "Isotope Number" },
	{ 0x0020, 0x0015, VR_IS, "Phase Number" },
	{ 0x0020, 0x0016, VR_IS, "Interval Number" },
	{ 0x0020, 0x0017, VR_IS, "Time Slot Number" },
	{ 0x0020, 0x0018, VR_IS, "Angle Number" },
	{ 0x0020, 0x0020, VR_CS, "Patient Orientation" },
	{ 0x0020, 0x0022, VR_US, "Overlay Number" },
	{ 0x0020, 0x0024, VR_US, "Curve Number" },
	{ 0x0020, 0x0030, VR_DS, "Image Position (RET)" },
	{ 0x0020, 0x0032, VR_DS, "Image Position (Patient)" },
	{ 0x0020, 0x0035, VR_DS, "Image Orientation (RET)" },
	{ 0x0020, 0x0037, VR_DS, "Image Orientation (Patient)" },
	{ 0x0020, 0x0050, VR_DS, "Location (RET)" },
	{ 0x0020, 0x0052, VR_UI, "Frame of Reference UID" },
	{ 0x0020, 0x0060, VR_CS, "Laterality" },
	{ 0x0020, 0x0070, VR_SH, "Image Geometry Type (RET)" },
	{ 0x0020, 0x0080, VR_UI, "Masking Image UID" },
	{ 0x0020, 0x0100, VR_IS, "Temporal Position Identifier" },
	{ 0x0020, 0x0105, VR_IS, "Number of Temporal Positions" },
	{ 0x0020, 0x0110, VR_DS, "Temporal Resolution" },
	{ 0x0020, 0x1000, VR_IS, "Series in Study" },
	{ 0x0020, 0x1001, VR_IS, "Acquisitions in Series (RET)" },
	{ 0x0020, 0x1002, VR_IS, "Images in Acquisition" },
	{ 0x0020, 0x1004, VR_IS, "Acquisition in Study" },
	{ 0x0020, 0x1020, VR_SH, "Reference (RET)" },
	{ 0x0020, 0x1040, VR_LO, "Position Reference Indicator" },
	{ 0x0020, 0x1041, VR_DS, "Slice Location" },
	{ 0x0020, 0x1070, VR_IS, "Other Study Numbers" },
	{ 0x0020, 0x1200, VR_IS, "Number of Patient Related Studies" },
	{ 0x0020, 0x1202, VR_IS, "Number of Patient Related Series" },
	{ 0x0020, 0x1204, VR_IS, "Number of Patient Related Images" },
	{ 0x0020, 0x1206, VR_IS, "Number of Study Related Series" },
	{ 0x0020, 0x1208, VR_IS, "Number of Study Related Images" },
	{ 0x0020, 0x3100, VR_SH, "Source Image ID (RET)s" },
	{ 0x0020, 0x3401, VR_SH, "Modifying Device ID (RET)" },
	{ 0x0020, 0x3402, VR_SH, "Modified Image ID (RET)" },
	{ 0x0020, 0x3403, VR_SH, "Modified Image Date (RET)" },
	{ 0x0020, 0x3404, VR_SH, "Modifying Device Manufacturer (RET)" },
	{ 0x0020, 0x3405, VR_SH, "Modified Image Time (RET)" },
	{ 0x0020, 0x3406, VR_SH, "Modified Image Description (RET)" },
	{ 0x0020, 0x4000, VR_LT, "Image Comments" },
	{ 0x0020, 0x5000, VR_US, "Original Image Identification (RET)" },
	{ 0x0020, 0x5002, VR_SH, "Original Image Identification Nomenclature (RET)" },
	{ 0x0028, 0x0000, VR_UL, "Group 0028 Length" },
	{ 0x0028, 0x0002, VR_US, "Samples per Pixel" },
	{ 0x0028, 0x0004, VR_CS, "Photometric Interpretation" },
	{ 0x0028, 0x0005, VR_US, "Image Dimensions (RET)" },
	{ 0x0028, 0x0006, VR_US, "Planar Configuration" },
	{ 0x0028, 0x0008, VR_IS, "Number of Frames" },
	{ 0x0028, 0x0009, VR_AT, "Frame Increment Pointer" },
	{ 0x0028, 0x0010, VR_US, "Rows" },
	{ 0x0028, 0x0011, VR_US, "Columns" },
	{ 0x0028, 0x0030, VR_DS, "Pixel Spacing" },
	{ 0x0028, 0x0031, VR_DS, "Zoom Factor" },
	{ 0x0028, 0x0032, VR_DS, "Zoom Center" },
	{ 0x0028, 0x0034, VR_IS, "Pixel Aspect Ratio" },
	{ 0x0028, 0x0040, VR_SH, "Image Format (RET)" },
	{ 0x0028, 0x0050, VR_SH, "Manipulated Image (RET)" },
	{ 0x0028, 0x0051, VR_CS, "Corrected Image" },
	{ 0x0028, 0x0060, VR_SH, "Compression Code (RET)" },
	{ 0x0028, 0x0100, VR_US, "Bits Allocated" },
	{ 0x0028, 0x0101, VR_US, "Bits Stored" },
	{ 0x0028, 0x0102, VR_US, "High Bit" },
	{ 0x0028, 0x0103, VR_US, "Pixel Representation" },
	{ 0x0028, 0x0104, VR_US, "Smallest Valid Pixel Value (RET)" },
	{ 0x0028, 0x0105, VR_US, "Largest Valid Pixel Value (RET)" },
	{ 0x0028, 0x0106, VR_US, "Smallest Image Pixel Value" },
	{ 0x0028, 0x0107, VR_US, "Largest Image Pixel Value" },
	{ 0x0028, 0x0108, VR_US, "Smallest Pixel Value in Series" },
	{ 0x0028, 0x0109, VR_US, "Largest Pixel Value in Series" },
	{ 0x0028, 0x0120, VR_US, "Pixel Padding Value" },
	{ 0x0028, 0x0200, VR_US, "Image Location (RET)" },
	{ 0x0028, 0x1050, VR_DS, "Window Center" },
	{ 0x0028, 0x1051, VR_DS, "Window Width" },
	{ 0x0028, 0x1052, VR_DS, "Rescale Intercept" },
	{ 0x0028, 0x1053, VR_DS, "Rescale Slope" },
	{ 0x0028, 0x1054, VR_LO, "Rescale Type" },
	{ 0x0028, 0x1055, VR_LO, "Window Center & Width Explanation" },
	{ 0x0028, 0x1080, VR_SH, "Gray Scale (RET)" },
	{ 0x0028, 0x1100, VR_US, "Gray Lookup Table Descriptor (RET)" },
	{ 0x0028, 0x1101, VR_US, "Red Palette Color Lookup Table Descriptor" },
	{ 0x0028, 0x1102, VR_US, "Green Palette Color Lookup Table Descriptor" },
	{ 0x0028, 0x1103, VR_US, "Blue Palette Color Lookup Table Descriptor" },
	{ 0x0028, 0x1200, VR_US, "Gray Lookup Table Data (RET)" },
	{ 0x0028, 0x1201, VR_US, "Red Palette Color Lookup Table Data" },
	{ 0x0028, 0x1202, VR_US, "Green Palette Color Lookup Table Data" },
	{ 0x0028, 0x1203, VR_US, "Blue Palette Color Lookup Table Data" },
	{ 0x0028, 0x3000, VR_SQ, "Modality LUT Sequence" },
	{ 0x0028, 0x3002, VR_US, "LUT Descriptor" },
	{ 0x0028, 0x3003, VR_LO, "LUT Explanation" },
	{ 0x0028, 0x3004, VR_LO, "Madality LUT Type" },
	{ 0x0028, 0x3006, VR_US, "LUT Data" },
	{ 0x0028, 0x3010, VR_SQ, "VOI LUT Sequence" },
	{ 0x0028, 0x4000, VR_SH, "Group 0028 Comments (RET)" },
	{ 0x0032, 0x0000, VR_UL, "Group 0032 Length" },
	{ 0x0032, 0x000A, VR_CS, "Study Status ID" },
	{ 0x0032, 0x000C, VR_CS, "Study Priority ID" },
	{ 0x0032, 0x0012, VR_LO, "Study ID Issuer" },
	{ 0x0032, 0x0032, VR_DA, "Study Verified Date" },
	{ 0x0032, 0x0033, VR_TM, "Study Verified Time" },
	{ 0x0032, 0x0034, VR_DA, "Study Read Date" },
	{ 0x0032, 0x0035, VR_TM, "Study Read Time" },
	{ 0x0032, 0x1000, VR_DA, "Scheduled Study Start Date" },
	{ 0x0032, 0x1001, VR_TM, "Scheduled Study Start Time" },
	{ 0x0032, 0x1010, VR_DA, "Scheduled Study Stop Date" },
	{ 0x0032, 0x1011, VR_TM, "Scheduled Study Stop Time" },
	{ 0x0032, 0x1020, VR_LO, "Scheduled Study Location" },
	{ 0x0032, 0x1021, VR_AE, "Scheduled Study Location AE Title(s)" },
	{ 0x0032, 0x1030, VR_LO, "Reason  for Study" },
	{ 0x0032, 0x1032, VR_PN, "Requesting Physician" },
	{ 0x0032, 0x1033, VR_LO, "Requesting Service" },
	{ 0x0032, 0x1040, VR_DA, "Study Arrival Date" },
	{ 0x0032, 0x1041, VR_TM, "Study Arrival Time" },
	{ 0x0032, 0x1050, VR_DA, "Study Completion Date" },
	{ 0x0032, 0x1051, VR_TM, "Study Completion Time" },
	{ 0x0032, 0x1055, VR_CS, "Study Component Status ID" },
	{ 0x0032, 0x1060, VR_LO, "Requested Procedure Description" },
	{ 0x0032, 0x1064, VR_SQ, "Requested Procedure Code Sequence" },
	{ 0x0032, 0x1070, VR_LO, "Requested Contrast Agent" },
	{ 0x0032, 0x4000, VR_LT, "Study Comments" },
	{ 0x0038, 0x0000, VR_UL, "Group 0038 Length" },
	{ 0x0038, 0x0004, VR_SQ, "Referenced Patient Alias Sequence" },
	{ 0x0038, 0x0008, VR_CS, "Visit Status ID" },
	{ 0x0038, 0x0010, VR_LO, "Admissin ID" },
	{ 0x0038, 0x0011, VR_LO, "Issuer of Admission ID" },
	{ 0x0038, 0x0016, VR_LO, "Route of Admissions" },
	{ 0x0038, 0x001A, VR_DA, "Scheduled Admissin Date" },
	{ 0x0038, 0x001B, VR_TM, "Scheduled Adission Time" },
	{ 0x0038, 0x001C, VR_DA, "Scheduled Discharge Date" },
	{ 0x0038, 0x001D, VR_TM, "Scheduled Discharge Time" },
	{ 0x0038, 0x001E, VR_LO, "Scheduled Patient Institution Residence" },
	{ 0x0038, 0x0020, VR_DA, "Admitting Date" },
	{ 0x0038, 0x0021, VR_TM, "Admitting Time" },
	{ 0x0038, 0x0030, VR_DA, "Discharge Date" },
	{ 0x0038, 0x0032, VR_TM, "Discharge Time" },
	{ 0x0038, 0x0040, VR_LO, "Discharge Diagnosis Description" },
	{ 0x0038, 0x0044, VR_SQ, "Discharge Diagnosis Code Sequence" },
	{ 0x0038, 0x0050, VR_LO, "Special Needs" },
	{ 0x0038, 0x0300, VR_LO, "Current Patient Location" },
	{ 0x0038, 0x0400, VR_LO, "Patient's Institution Residence" },
	{ 0x0038, 0x0500, VR_LO, "Patient State" },
	{ 0x0038, 0x4000, VR_LT, "Visit Comments" },
	{ 0x0088, 0x0000, VR_UL, "Group 0088 Length" },
	{ 0x0088, 0x0130, VR_SH, "Storage Media File-set ID" },
	{ 0x0088, 0x0140, VR_UI, "Storage Media File-set UID" },
	{ 0x2000, 0x0000, VR_UL, "Group 2000 Length" },
	{ 0x2000, 0x0010, VR_IS, "Number of Copies" },
	{ 0x2000, 0x0020, VR_CS, "Print Priority" },
	{ 0x2000, 0x0030, VR_CS, "Medium Type" },
	{ 0x2000, 0x0040, VR_CS, "Film Destination" },
	{ 0x2000, 0x0050, VR_LO, "Film Session Label" },
	{ 0x2000, 0x0060, VR_IS, "Memory Allocation" },
	{ 0x2000, 0x0500, VR_SQ, "Referenced Film Box Sequence" },
	{ 0x2010, 0x0000, VR_UL, "Group 2010 Length" },
	{ 0x2010, 0x0010, VR_ST, "Image Display Format" },
	{ 0x2010, 0x0030, VR_CS, "Annotation Display Format ID" },
	{ 0x2010, 0x0040, VR_CS, "Film Orientation" },
	{ 0x2010, 0x0050, VR_CS, "Film Size ID" },
	{ 0x2010, 0x0060, VR_CS, "Magnification Type" },
	{ 0x2010, 0x0080, VR_CS, "Smoothing Type" },
	{ 0x2010, 0x0100, VR_CS, "Border Density" },
	{ 0x2010, 0x0110, VR_CS, "Empty Image Density" },
	{ 0x2010, 0x0120, VR_US, "Min Density" },
	{ 0x2010, 0x0130, VR_US, "Max Density" },
	{ 0x2010, 0x0140, VR_CS, "Trim" },
	{ 0x2010, 0x0150, VR_ST, "Configuration Information" },
	{ 0x2010, 0x0500, VR_SQ, "Referenced Film Session Sequence" },
	{ 0x2010, 0x0510, VR_SQ, "Referenced Basic Image Box Sequence" },
	{ 0x2010, 0x0520, VR_SQ, "Referenced Basic Annotation Box Sequence" },
	{ 0x2020, 0x0000, VR_UL, "Group 2020 Length" },
	{ 0x2020, 0x0010, VR_US, "Image Position" },
	{ 0x2020, 0x0020, VR_CS, "Polarity" },
	{ 0x2020, 0x0030, VR_DS, "Requested Image Size" },
	{ 0x2020, 0x0110, VR_SQ, "Preformatted Greyscale Image Sequence" },
	{ 0x2020, 0x0111, VR_SQ, "Preformatted Color Image Sequence" },
	{ 0x2020, 0x0130, VR_SQ, "Referenced Image Overlay Box Sequence" },
	{ 0x2020, 0x0140, VR_SQ, "Referenced VOI LUT Sequence" },
	{ 0x2030, 0x0000, VR_UL, "Group 2030 Length" },
	{ 0x2030, 0x0010, VR_US, "Annotation Position" },
	{ 0x2030, 0x0020, VR_LO, "Text String" },
	{ 0x2040, 0x0000, VR_UL, "Group 2040 Length" },
	{ 0x2040, 0x0010, VR_SQ, "Referenced Overlay Plane Sequence" },
	{ 0x2040, 0x0011, VR_US, "Refenced Overlay Plane Groups" },
	{ 0x2040, 0x0060, VR_CS, "Overlay Magnification Type" },
	{ 0x2040, 0x0070, VR_CS, "Overlay Smoothing Type" },
	{ 0x2040, 0x0080, VR_CS, "Overlay Foreground Density" },
	{ 0x2040, 0x0090, VR_CS, "overlay Mode" },
	{ 0x2040, 0x0100, VR_CS, "Threshold Density" },
	{ 0x2040, 0x0500, VR_SQ, "Referenced Image Box Sequence" },
	{ 0x2100, 0x0000, VR_UL, "Group 2100 Length" },
	{ 0x2100, 0x0020, VR_CS, "Execution Status" },
	{ 0x2100, 0x0030, VR_CS, "Execution Status Info" },
	{ 0x2100, 0x0040, VR_DA, "Creation Date" },
	{ 0x2100, 0x0050, VR_TM, "Creation Time" },
	{ 0x2100, 0x0070, VR_AE, "Originator" },
	{ 0x2100, 0x0500, VR_SQ, "Referenced Print Job Sequence" },
	{ 0x2110, 0x0000, VR_UL, "Group 2110 Length" },
	{ 0x2110, 0x0010, VR_CS, "Printer Status" },
	{ 0x2110, 0x0020, VR_CS, "Printer Status Info" },
	{ 0x2110, 0x0030, VR_ST, "Printer Name" },
	{ 0x4000, 0x0000, VR_UL, "Group 4000 Length (RET)" },
	{ 0x4000, 0x0010, VR_SH, "Arbitray (RET)" },
	{ 0x4000, 0x4000, VR_LT, "Group 4000 Comments (RET)" },
	{ 0x4008, 0x0000, VR_UL, "Group 4008 Length" },
	{ 0x4008, 0x0040, VR_SH, "Results ID" },
	{ 0x4008, 0x0042, VR_LO, "Results ID Issuer" },
	{ 0x4008, 0x0050, VR_SQ, "Referenced Interpretation Sequence" },
	{ 0x4008, 0x0100, VR_DA, "Interpretation Recorded Date" },
	{ 0x4008, 0x0101, VR_TM, "Interpretation Recorded Time" },
	{ 0x4008, 0x0102, VR_PN, "Interpretation Recorder" },
	{ 0x4008, 0x0103, VR_LO, "Reference to Recorded Sound" },
	{ 0x4008, 0x0108, VR_DA, "Interpretation Transcription Time" },
	{ 0x4008, 0x0109, VR_TM, "Interpretation Transcription Time" },
	{ 0x4008, 0x010A, VR_PN, "Interpretation Transcriber" },
	{ 0x4008, 0x010B, VR_ST, "Interpretation Text" },
	{ 0x4008, 0x010C, VR_PN, "Interpretation Author" },
	{ 0x4008, 0x0111, VR_SQ, "Interpretation Approver Sequence" },
	{ 0x4008, 0x0112, VR_DA, "Interpretation Approval Date" },
	{ 0x4008, 0x0113, VR_TM, "Interpretation Approval Time" },
	{ 0x4008, 0x0114, VR_PN, "Physician Approving Interpretation" },
	{ 0x4008, 0x0115, VR_LT, "Interpretation Diagnosis Description" },
	{ 0x4008, 0x0117, VR_SQ, "Diagnosis Code Sequence" },
	{ 0x4008, 0x0118, VR_SQ, "Results Distribution List Sequence" },
	{ 0x4008, 0x0119, VR_PN, "Distribution Name" },
	{ 0x4008, 0x011A, VR_LO, "Distribution Address" },
	{ 0x4008, 0x0200, VR_SH, "Interpretation ID" },
	{ 0x4008, 0x0202, VR_LO, "Interpretation ID Issuer" },
	{ 0x4008, 0x0210, VR_CS, "Interpretation Type ID" },
	{ 0x4008, 0x0212, VR_CS, "Interpretation Status ID" },
	{ 0x4008, 0x0300, VR_ST, "Impression" },
	{ 0x4008, 0x4000, VR_SH, "Group 4008 Comments" },
	{ 0x5000, 0x0000, VR_UL, "Group 5000 Length" },
	{ 0x5000, 0x0005, VR_US, "Curve Dimensions" },
	{ 0x5000, 0x0010, VR_US, "Number of Points" },
	{ 0x5000, 0x0020, VR_CS, "Type of Data" },
	{ 0x5000, 0x0022, VR_LO, "Curve Description" },
	{ 0x5000, 0x0030, VR_SH, "Axis Units" },
	{ 0x5000, 0x0040, VR_SH, "Axis Labels" },
	{ 0x5000, 0x0103, VR_US, "Data Value Representation" },
	{ 0x5000, 0x0104, VR_US, "Minimum Coordinate Value" },
	{ 0x5000, 0x0105, VR_US, "Maximum Coordinate Value" },
	{ 0x5000, 0x0106, VR_SH, "Curve Range" },
	{ 0x5000, 0x0110, VR_US, "Curve Data Descriptor" },
	{ 0x5000, 0x0112, VR_US, "Coordinate Start Value" },
	{ 0x5000, 0x0114, VR_US, "Coordinate Step Value" },
	{ 0x5000, 0x2000, VR_US, "Audio Type" },
	{ 0x5000, 0x2002, VR_US, "Audio Sample Format" },
	{ 0x5000, 0x2004, VR_US, "Number of Channels" },
	{ 0x5000, 0x2006, VR_UL, "Number of Samples" },
	{ 0x5000, 0x2008, VR_UL, "Sample Rate" },
	{ 0x5000, 0x200A, VR_UL, "Total Time" },
	{ 0x5000, 0x200C, VR_OB, "Audio Sample Data" },
	{ 0x5000, 0x200E, VR_LT, "Audio Comments" },
	{ 0x5000, 0x3000, VR_OB, "Curve Data" },
	{ 0x6000, 0x0000, VR_UL, "Group 6000 Length" },
	{ 0x6000, 0x0010, VR_US, "Rows" },
	{ 0x6000, 0x0011, VR_US, "Columns" },
	{ 0x6000, 0x0015, VR_IS, "Number of Frames in Overlay" },
	{ 0x6000, 0x0040, VR_CS, "Overlay Type" },
	{ 0x6000, 0x0050, VR_SS, "Origin" },
	{ 0x6000, 0x0060, VR_SH, "Compression Code (RET)" },
	{ 0x6000, 0x0100, VR_US, "Bits Allocated" },
	{ 0x6000, 0x0102, VR_US, "Bit Position" },
	{ 0x6000, 0x0110, VR_SH, "Overlay Format (RET)" },
	{ 0x6000, 0x0200, VR_US, "Overlay Location (RET)" },
	{ 0x6000, 0x1100, VR_US, "Overlay Descriptor - Gray" },
	{ 0x6000, 0x1101, VR_US, "Overlay Descriptor - Red" },
	{ 0x6000, 0x1102, VR_US, "Overlay Descriptor - Green" },
	{ 0x6000, 0x1103, VR_US, "Overlay Descriptor - Blue" },
	{ 0x6000, 0x1200, VR_US, "Overlays - Gray" },
	{ 0x6000, 0x1201, VR_US, "Overlays - Red" },
	{ 0x6000, 0x1202, VR_US, "Overlays - Green" },
	{ 0x6000, 0x1203, VR_US, "Overlays - Blue" },
	{ 0x6000, 0x1301, VR_IS, "ROI Area" },
	{ 0x6000, 0x1302, VR_DS, "ROI Mean" },
	{ 0x6000, 0x1303, VR_DS, "ROI Standard Deviation" },
	{ 0x6000, 0x3000, VR_OW, "Overlay Data" },
	{ 0x6000, 0x4000, VR_SH, "Group 6000 Comments (RET)" },
	{ 0x7FE0, 0x0000, VR_UL, "Group 7FE0 Length" },
	{ 0x7FE0, 0x0010, VR_OB, "Pixel Data" },
	{ 0xFFFE, 0xE000, VR_UN, "Item" },
	{ 0xFFFE, 0xE00D, VR_UN, "Item Delimitation Item" },
	{ 0xFFFE, 0xE0DD, VR_UN, "Sequence Delimitation Item" },
};

#endif
