// dcl_test.cpp : R\[ AvP[Vp̃Gg |Cg̒`
//

#include "stdafx.h"
#include "ListBuilder.h"

using namespace dcl;

void dump_dicom_data( CElement* element, int level );

int main(int argc, char* argv[])
{
	if( argc < 2 ){
		puts( "DICOMt@Cw肵" );
		return 1;
	}

	CResult result;
	CDicomFileReader reader;

	// t@Cr_DICOMf[^ǂݍ
	result = reader.Load( argv[1] );
	if( result.Failed() ){
		puts( result.Message().c_str() );
		return 1;
	}

	// r_DICOMf[^擾
	dump_dicom_data( reader.GetSequence(), 0 );

	return 0;
}

void dump_dicom_data( CElement* element, int level )
{
	while( element ){
		if( element->GetType() == ELEMENT_START_DELIMITER ){
			element = element->GetNext();
			continue;
		}

		if( element->GetType() == ELEMENT_END_DELIMITER ){
			break;
		}

		printf( "(%04x,%04x) [%s] %8d ", element->GetGroup(), element->GetElement(), Vr2Str( element->GetVR() ).c_str(), element->GetLength() );
		for( int i=0; i < _MIN( element->GetLength(), 8 ); i++ ){
			printf( "%02x ", element->GetData()[i] );
		}
		puts( "" );

		for( i=0; i <  element->CountSequence(); i++ ){
			dump_dicom_data( element->GetSequence( i ), level + 1 );
		}

		element = element->GetNext();
	}
}
