/** CResultNX
 *
 *  @file Token.h
 *  @author Y.Kameda
 *  @date 2003/4/23
 *
 */

#ifndef INCLUDE_RESULT_H
#define INCLUDE_RESULT_H

#include <string>
#include <vector>

using namespace std;

namespace dcl{

/** ʎʎq
 *
 */
enum RESULT{
	RESULT_GOOD,
	RESULT_IO_FAILED,
	RESULT_NETWORK_FAILED,
	RESULT_MEMORY_FAILED,
	RESULT_FAILED
};

typedef const char* LPCSTR;

class CMyString
{
	char* m_buf;
	int   m_buf_len;
public:
	//CMyString();
	CMyString( const char* src="" );
	CMyString( const CMyString& rhs );
	CMyString& operator=( const CMyString& rhs );
	CMyString& operator=( const char* rhs );
	~CMyString();
	operator LPCSTR() const;
};

/** CResultNX
 *
 *  dclԂʃNXB
 *  G[ʂƃG[bZ[WԂB
 *
 */
class CResult
{
private:
	RESULT m_result;
	vector<CMyString> m_message_array;

public:
	CResult();
	CResult& operator=( const CResult& rhs );

	int    Code();
	bool   Succeed(); ///< ֐H(RESULT_GOODH)
	bool   Failed();  ///< ֐sH(RESULT_GOODȊOH)
	int    MessageCount();
	string Message( int index );
	string Message(); ///< G[bZ[WԂ
	void   AddMessage( const char* message );
	void   SetCode( RESULT );
};

}

#endif
