#include "TekitoBuilder.h"

using namespace dcl;

/** VRԂ
 *
 */
/*
string Vr2Str( VR_TYPE vr )
{
	switch( vr ){
	case VR_AE : return "AE";
	case VR_AS : return "AS";
	case VR_AT : return "AT";
	case VR_CS : return "CS";
	case VR_DA : return "DA";
	case VR_DS : return "DS";
	case VR_DT : return "DT";
	case VR_FL : return "FL";
	case VR_FD : return "FD";
	case VR_IS : return "IS";
	case VR_LO : return "LO";
	case VR_LT : return "LT";
	case VR_OB : return "OB";
	case VR_OW : return "OW";
	case VR_PN : return "PN";
	case VR_SH : return "SH";
	case VR_SL : return "SL";
	case VR_SQ : return "SQ";
	case VR_SS : return "SS";
	case VR_ST : return "ST";
	case VR_TM : return "TM";
	case VR_UI : return "UI";
	case VR_UL : return "UL";
	case VR_US : return "US";
	case VR_UT : return "UT";
	case VR_UN :
	case VR_OTHER:
	default    : return "UN";
	}
}
*/

/** CPerserǂݍ񂾓ê܂܃_vႤ
 *
 */
CResult CTekitoBuilder::Load()
{
	CResult result;
	const CToken* token;
	int     i;

	CPerser* perser = GetPerser();
	if( perser == NULL ){
		result.SetCode( RESULT_FAILED );
		result.AddMessage( "CPerserBindĂȂ" );
		return result;
	}

	while( 1 ){

		result = perser->GetNext( &token );
		if( result.Failed() ){
			return result;
		}

		switch( token->GetType() ){
		case TOKEN_PREAMBLE: // t@CvAu
			puts( "[t@CvAu]" );
			break;
		case TOKEN_DICM:     /// DICMvtBbNX
			puts( "[DICMvtBbNX]" );
			break;
		case TOKEN_ELEMENT:  /// ^Ovf
			//puts( "^O" );
			printf( "(%04x,%04x) [%s] %8d  ", token->GetGroup(), token->GetElement(), Vr2Str( token->GetVR() ).c_str(), token->GetLength() );
			for( i=0; i < 12; i++ ){
				if( token->GetLength() > i ){
					printf( "%02x ", token->GetData()[i] );
				} else {
					printf( "   " );
				}
			}
			printf( ": " );
			for( i=0; i < _MIN( token->GetLength(), 16 ); i++ ){
				if( isprint( token->GetData()[i] ) ){
					putchar( token->GetData()[i] );
				} else {
					putchar( ' ' );
				}
			}
			if( token->GetLength() > 16 ){
				puts( "..." );
			} else {
				puts( "" );
			}
			break;
		case TOKEN_BLOKEN:   /// ^ȎOɃt@CI[Ă܂BtH[}bgG[
			puts( "[ꂽ^O]" );
			printf( "(%04x,%04x) [%d] %8d(%8d)  ", token->GetGroup(), token->GetElement(), token->GetVR(), token->GetFailLength(), token->GetLength() );
			for( i=0; i < _MIN( token->GetLength(), 8 ); i++ ){
				printf( "%02x ", token->GetData()[i] );
			}
			puts( "" );
			break;
		case TOKEN_END_POS:
			puts( "[f[^I]" );
			goto BREAK;
		}
	}

BREAK:
	result.SetCode( RESULT_GOOD );
	return result;
}
