// ControlDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "dcl_viewer.h"
#include "ControlDlg.h"
#include "dcl_access.h"
#include "MainFrm.h"

#define TIMER_POLING 100

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CControlDlg _CAO


CControlDlg::CControlDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CControlDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CControlDlg)
	m_center_label = _T("");
	m_width_label = _T("");
	m_center_max = _T("");
	m_center_min = _T("");
	m_width_max = _T("");
	m_width_min = _T("");
	m_nega = FALSE;
	//}}AFX_DATA_INIT

	_max_center = 65536;
	_min_center = 0;
	_reverse = false;
	_parent = NULL;
	_width = 0;
	_center = 0;
}


void CControlDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CControlDlg)
	DDX_Control(pDX, IDC_SLIDER_WIDTH, m_slider_width);
	DDX_Control(pDX, IDC_SLIDER_CENTER, m_slider_center);
	DDX_Text(pDX, IDC_CENTER_LABEL, m_center_label);
	DDX_Text(pDX, IDC_WIDTH_LABEL, m_width_label);
	DDX_Text(pDX, IDC_CENTER_MAX, m_center_max);
	DDX_Text(pDX, IDC_CENTER_MIN, m_center_min);
	DDX_Text(pDX, IDC_WIDTH_MAX, m_width_max);
	DDX_Text(pDX, IDC_WIDTH_MIN, m_width_min);
	DDX_Check(pDX, IDC_NEGA, m_nega);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CControlDlg, CDialog)
	//{{AFX_MSG_MAP(CControlDlg)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_CENTER, OnReleasedcaptureSliderCenter)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_WIDTH, OnReleasedcaptureSliderWidth)
	ON_BN_CLICKED(IDC_NEGA, OnNega)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CControlDlg bZ[W nh

void CControlDlg::OnOK() 
{
	//CDialog::OnOK();
}

void CControlDlg::OnCancel() 
{
	//CDialog::OnCancel();
}

BOOL CControlDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	setCenterRange( _max_center, _min_center );

	SetTimer( TIMER_POLING, 100, NULL );
	
	return TRUE;
}

/** KZbg
 *
 */
void CControlDlg::setCenterRange( int max_center, int min_center )
{
	UpdateData( TRUE );

	_max_center = max_center;
	_min_center = min_center;

	if( this->m_hWnd ){
		m_slider_center.SetRange( min_center, max_center, TRUE );
		m_slider_width.SetRange( 0, abs( max_center - min_center ), TRUE );

		m_center_min.Format( "%d", min_center );
		m_center_max.Format( "%d", max_center );
		m_width_min.Format( "%d", 0 );
		m_width_max.Format( "%d", abs( max_center - min_center ) );
	}

	UpdateData( FALSE );
}

/** KlZbg
 *
 */
void CControlDlg::setCurrentValue( int center, int width )
{
	UpdateData( TRUE );

	if( this->m_hWnd ){
		m_slider_center.SetPos( center );
		m_slider_width.SetPos( width );

		m_center_label.Format( "%d", center );
		m_width_label.Format( "%d", width );

		_width = width;
		_center = center;
	}

	UpdateData( FALSE );
}

void CControlDlg::OnReleasedcaptureSliderCenter(NMHDR* pNMHDR, LRESULT* pResult) 
{
	/*
	// DICOMrbg}bvϊIuWFNg擾
	CDIBitsConverter* converter = get_converter();	

	if( converter && _parent ){
		converter->setWindow( m_slider_center.GetPos(), m_slider_width.GetPos(), _reverse );
		_parent->redraw_image();
	}

	setCurrentValue( m_slider_center.GetPos(), m_slider_width.GetPos() );
	*/

	*pResult = 0;
}

void CControlDlg::OnReleasedcaptureSliderWidth(NMHDR* pNMHDR, LRESULT* pResult) 
{
	/*
	// DICOMrbg}bvϊIuWFNg擾
	CDIBitsConverter* converter = get_converter();	

	if( converter && _parent ){
		converter->setWindow( m_slider_center.GetPos(), m_slider_width.GetPos(), _reverse );
		//this->GetParentOwner()->Invalidate();
		_parent->redraw_image();
	}

	setCurrentValue( m_slider_center.GetPos(), m_slider_width.GetPos() );
	*/

	*pResult = 0;
}

void CControlDlg::OnNega() 
{
	UpdateData();

	_reverse = (m_nega)?true:false;

	// DICOMrbg}bvϊIuWFNg擾
	CDIBitsConverter* converter = get_converter();	

	if( converter && _parent ){
		converter->setWindow( m_slider_center.GetPos(), m_slider_width.GetPos(), _reverse );
		_parent->redraw_image();
	}
}

void CControlDlg::OnTimer(UINT nIDEvent) 
{
	// KXC_Ď^C}
	if( nIDEvent == TIMER_POLING ){

		if( _width != m_slider_width.GetPos() ||
			_center != m_slider_center.GetPos() ){
			_width = m_slider_width.GetPos();
			_center = m_slider_center.GetPos();

			// DICOMrbg}bvϊIuWFNg擾
			CDIBitsConverter* converter = get_converter();	

			if( converter && _parent ){
				converter->setWindow( _center, _width, _reverse );
				_parent->redraw_image();
			}
		}
	}
	
	CDialog::OnTimer(nIDEvent);
}
