#include "stdafx.h"
#include "dcl_access.h"

// DICOMt@Cǂݍ݃IuWFNg
static CDicomFileReader g_reader;

// DICOMrbg}bvf[^Ro[^
static CDIBitsConverter g_converter;

// DICOMt@Cǂݍݍς݃tO
static bool g_b_load = false;

// DICOMt@Cǂݍ
void load_image( LPCTSTR path )
{
	CResult result;

	g_b_load = false;

	// t@Cr_DICOMf[^ǂݍ
	result = g_reader.Load( path );
	if( result.Failed() ){

		// t@Cǂݍ݃G[\
		AfxMessageBox( result.Message().c_str() );
		return;
	}

	CElement* e = g_reader.GetSequence();

	if( e ){
		// 摜Gg擾
		CElement* e_image = e->SearchElement( 0x7fe0, 0x0010 );

		// column擾
		CElement* e_column = e->SearchElement( 0x0028, 0x0011 );

		// row擾
		CElement* e_row = e->SearchElement( 0x0028, 0x0010 );

		// allocate bits擾
		CElement* e_alloc = e->SearchElement( 0x0028, 0x0100 );

		// stored bits擾
		CElement* e_stored = e->SearchElement( 0x0028, 0x0101 );

		// samples per pixel擾
		CElement* e_samples = e->SearchElement( 0x0028, 0x0002 );
		//CElement* e_samples = e->SearchElement( 0x0028, 0x0101 );

		// Window Width擾
		CElement* e_width = e->SearchElement( 0x0028, 0x1051 );

		// Window Center擾
		CElement* e_center = e->SearchElement( 0x0028, 0x1050 );

		// f\擾
		CElement* e_interception = e->SearchElement( 0x0028, 0x0004 );

		// \擾
		CElement* e_representation = e->SearchElement( 0x0028, 0x0103 );

		// XP[ؕ
		CElement* e_rescale_intercept = e->SearchElement( 0x0028, 0x1052 );

		// XP[X
		CElement* e_rescale_slope = e->SearchElement( 0x0028, 0x1053 );

		if( !e_image || !e_column || !e_row || !e_alloc || !e_samples || !e_stored || !e_representation ){
			AfxMessageBox( "\ɕKvȃ^O܂" );
			return;
		}

		// XP[ؕЁAXP[X΁AƂ݂Ȃ
		bool b_representation = (*((USHORT*)e_representation->GetData())==1)?true:false;
		if( b_representation == false ){
			if( e_rescale_intercept || e_rescale_slope ){
				b_representation = true;
			}
		}

		// Ef[^BMPϊIuWFNgɁA摜f[^Zbg
		g_converter.setData(
			e_image->GetData(), *((USHORT*)e_column->GetData()), *((USHORT*)e_row->GetData()),
			*((USHORT*)e_alloc->GetData()), *((USHORT*)e_stored->GetData()), *((USHORT*)e_samples->GetData()),
			b_representation );

		double width = 256;
		double center = 128;
		bool b_reverse = false;

		if( e_width ){
			width = atof( (const char*)e_width->GetData() );
		}

		if( e_center ){
			center = atof( (const char*)e_center->GetData() );
		}

		if( e_interception ){
			if( strstr( (const char*)e_interception->GetData(), "MONOCHROME1" ) ){
				b_reverse = true;
			}
		}

		// Ef[^BMPϊIuWFNgɁAKZbg
		g_converter.setWindow( center, width, b_reverse );

		// t@Cǂݍݍς݃tO𗧂Ă
		g_b_load = true;

	} else {
		AfxMessageBox( "ǂݍ݂ɐƎvǁAf[^擾łȂHHH" );
	}
}

// 摜Gg(7fe0,0010)ԂB
// 摜Gg擾łȂ΁ANULLԂ
CElement* get_image_element()
{
	CElement* e = g_reader.GetSequence();

	if( e ){
		return e->SearchElement( 0x7fe0, 0x0010 );
	}

	return NULL;
}


// DICOMrbg}bvRo[gIuWFNg擾B
// 摜ǂݍłȂNULLԂ
CDIBitsConverter* get_converter()
{
	if( g_b_load ){
		return &g_converter;
	} else {
		return NULL;
	}
}

