/*
 * Decompiled with CFR 0.152.
 */
package jp.osdn.dddsupport.basegenerator.internal.action;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import jp.osdn.dddsupport.basegenerator.internal.action.BaseClassModifierImpl;
import jp.osdn.dddsupport.basegenerator.model.AbstractClass;
import jp.osdn.dddsupport.basegenerator.model.BaseClass;
import jp.osdn.dddsupport.basegenerator.model.ClassName;
import jp.osdn.dddsupport.basegenerator.model.PackageName;
import jp.osdn.dddsupport.basegenerator.model.Workspace;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class WorkspaceImpl
implements Workspace {
    private IJavaElement baseClassPackageInWorkspace;
    private ICompilationUnit baseClassInWorkspace;

    public WorkspaceImpl(ExecutionEvent event) {
        this.baseClassInWorkspace = this.getUnit(event);
        this.baseClassPackageInWorkspace = this.baseClassInWorkspace.getParent();
    }

    @Override
    public BaseClass getSelectedBaseClass() {
        PackageName packageName = new PackageName(this.baseClassPackageInWorkspace.getElementName());
        ClassName className = new ClassName(this.baseClassInWorkspace.getElementName());
        BaseClassModifierImpl modifier = new BaseClassModifierImpl(this.baseClassInWorkspace);
        return new BaseClass(packageName, className, modifier);
    }

    private ICompilationUnit getUnit(ExecutionEvent event) {
        ICompilationUnit unit = null;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection selectionFromExplorer = (IStructuredSelection)selection;
            unit = (ICompilationUnit)selectionFromExplorer.getFirstElement();
        }
        if (selection instanceof ITextSelection) {
            CompilationUnitEditor javaEditor = (CompilationUnitEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
            unit = (ICompilationUnit)javaEditor.getViewPartInput();
        }
        return unit;
    }

    @Override
    public boolean add(AbstractClass newClass) {
        IResource resource = this.baseClassPackageInWorkspace.getResource();
        IPath path = resource.getFullPath().append(newClass.toJavaFileName());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile(path);
        if (file.exists()) {
            System.out.println("file " + path + " is already exists.");
            return false;
        }
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(newClass.writeCode().getBytes());
            file.create((InputStream)in, false, null);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }
}

