unit locatefrm;

{$IFDEF FPC}
  {$MODE DELPHI}{$H+}
{$ENDIF}

interface

uses
     Types,Classes, SysUtils, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, LResources, Buttons;

type
   StringArray8=array[1..8]of string;

type
  TLocateForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    TrackBar1: TTrackBar;
    OkButton: TButton;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure OkButtonClick(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    Button:integer;
    valuet,value0,value1:double;
  public
    function Choice(dev0,ini0:integer; capts:StringArray8):integer;
    function Value(vr,vi:boolean; left0,right0,ini0:double):extended;
    procedure InitValue;
  end;

var
  LocateForm: TLocateForm;

implementation
uses base,struct,paintfrm;

function TLocateForm.Choice(dev0,ini0:integer;capts:StringArray8):integer;
var
   i:integer;
begin
   TrackBar1.Visible:=false;
   OkButton.visible:=false;
   Label1.Visible:=false;

   if capts[1]<>'' then
      Button1.Caption:=capts[1]
   else
      Button1.Caption:='1';
   if capts[2]<>'' then
      Button2.Caption:=capts[2]
   else
      Button2.Caption:='2';
   if capts[3]<>'' then
      Button3.Caption:=capts[3]
   else
      Button3.Caption:='3';
   if capts[4]<>'' then
      Button4.Caption:=capts[4]
   else
      Button4.Caption:='4';
   if capts[5]<>'' then
      Button5.Caption:=capts[5]
   else
      Button5.Caption:='5';
   if capts[6]<>'' then
      Button6.Caption:=capts[6]
   else
      Button6.Caption:='6';
   if capts[7]<>'' then
      Button7.Caption:=capts[7]
   else
      Button7.Caption:='7';
   if capts[8]<>'' then
      Button8.Caption:=capts[8]
   else
      Button8.Caption:='8';


   Button8.Visible:=(dev0>=8);
   Button7.Visible:=(dev0>=7);
   Button6.Visible:=(dev0>=6);
   Button5.Visible:=(dev0>=5);
   Button4.Visible:=(dev0>=4);
   Button3.Visible:=(dev0>=3);
   Button2.Visible:=(dev0>=2);
   Button1.Visible:=(dev0>=1);

   Button:=-1;

   if ini0<=dev0 then
     case ini0 of
     1: ActiveControl:=Button1;
     2: ActiveControl:=Button2;
     3: ActiveControl:=Button3;
     4: ActiveControl:=Button4;
     5: ActiveControl:=Button5;
     6: ActiveControl:=Button6;
     7: ActiveControl:=Button7;
     8: ActiveControl:=Button8;
     end;

   visible:=true;
   WindowState:=wsNormal;
   repeat
     Application.ProcessMessages;
     sleep(100);
   until (button<>-1) ;
   if Button=0 then
      CtrlBreakHit:=true ;
   result:=button;
end;

function TLocateForm.Value(vr,vi:boolean; left0,right0,ini0:double):extended;
begin

   Button8.Visible:=false;
   Button7.Visible:=false;
   Button6.Visible:=false;
   Button5.Visible:=false;
   Button4.Visible:=false;
   Button3.Visible:=false;
   Button2.Visible:=false;
   Button1.Visible:=false;
   TrackBar1.Visible:=true;
   OkButton.visible:=true;

   visible:=true;
   WindowState:=wsNormal;
   Button:=-1;

   if vr then
     begin
      value0:=left0;
      value1:=right0;
     end;
   if vi then
      valuet:=ini0;
   if (valuet-value0)*(valuet-value1)>0 then
      if vi then
         setexception(11152)
      else
         valuet:=(left0+right0)/2.0;
   //if vr or vi then
   with TrackBar1 do
            Position:=round(min+(valuet-value0)/(value1-value0)*(max-min));
   TrackBar1Change(self);
   repeat
     Application.ProcessMessages;
     sleep(100);
   until button<>-1;

   result:=valuet;
   if Button=0 then
        CtrlBreakHit:=true ;

end;

procedure TLocateForm.Button1Click(Sender: TObject);
begin
   button:=1
end;

procedure TLocateForm.Button2Click(Sender: TObject);
begin
  button:=2
end;

procedure TLocateForm.Button3Click(Sender: TObject);
begin
  button:=3
end;

procedure TLocateForm.Button4Click(Sender: TObject);
begin
   button:=4
end;

procedure TLocateForm.Button5Click(Sender: TObject);
begin
  button:=5
end;

procedure TLocateForm.Button6Click(Sender: TObject);
begin
   button:=6
end;

procedure TLocateForm.Button7Click(Sender: TObject);
begin
  button:=7
end;

procedure TLocateForm.Button8Click(Sender: TObject);
begin
   button:=8
end;

procedure TLocateForm.OkButtonClick(Sender: TObject);
begin
  Button:=11
end;

procedure TLocateForm.FormCreate(Sender: TObject);
begin
  if height<paintform.Top then
     top:=paintform.Top-height
  else
     top:=0;
  left:=paintform.left+paintform.width-width;
end;

procedure TLocateForm.TrackBar1Change(Sender: TObject);
begin
 with TrackBar1 do
   begin
     valuet:=Value0 + (Position/(max-min))*(Value1-Value0);
     Label1.Caption:=Format('%8g',[valuet]);
     Label1.Left:=Left+(Position -label1.Width) div 2;
     Label1.Visible:=true;
   end;
end;

procedure TLocateForm.InitValue;
begin
  value0:=0;
  value1:=1;
  valuet:=0.5;
  Visible:=false;
end;

procedure TLocateForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    Button:=0;
    Action:=caMiniMize
end;

initialization
  {$i locatefrm.lrs}


end.
