unit myutils;
{$IFDEF FPC}
  {$MODE DELPHI}{$H+}
{$ENDIF}

(***************************************)
(* Copyright (C) 2007, SHIRAISHI Kazuo *)
(***************************************)


interface
uses Dialogs,StdCtrls,SynEdit,
{$IFDEF FPC}
  LCLType;
{$ELSE}
  Windows;
{$ENDIF}

  function LineFromChar(memo:TSynEdit; n:integer):integer; //line index from char pos
  function LineIndex(memo:TSynEdit; n:integer):integer;    //line index to char pos
  procedure ReadMBC(var i:integer; const s:AnsiString);
  function isTrueFile(s:string):boolean;
  procedure NotAvailableMessage;

const
{$IFDEF FPC}
  mb_YesNo=LCLType.mb_YesNo;
  mb_OKCANCEL=LCLType.mb_OKCANCEL;
  IDOk=LCLType.IDOk;
  IDYES=LCLType.IDYES;
  vk_F1=LCLType.vk_F1;
  vk_F5=LCLType.vk_F5;
  vk_F6=LCLType.vk_F6;
  vk_F7=LCLType.vk_F7;
  vk_F8=LCLType.vk_F8;
  vk_insert=LCLType.vk_insert;
  TRANSPARENT=LCLType.TRANSPARENT;
  OPAQUE=LCLType.OPAQUE;
  OEM_CHARSET=LCLType.OEM_CHARSET;
{$ELSE}
  mb_YesNo=Windows.mb_YesNo;
  mb_OKCANCEL=Windows.mb_OKCANCEL;
  IDOk=Windows.IDOk;
  IDYES=Windows.IDYES;
  vk_F1=Windows.vk_F1;
  vk_F5=Windows.vk_F5;
  vk_F6=Windows.vk_F6;
  vk_F7=Windows.vk_F7;
  vk_F8=Windows.vk_F8;
  vk_insert=Windows.vk_insert;
  TRANSPARENT=Windows.TRANSPARENT;
  OPAQUE=Windows.OPAQUE;
  OEM_CHARSET=Windows.OEM_CHARSET;
{$ENDIF}

implementation
uses
  Types,
{$IFDEF LINUX}
   LibC,
{$ENDIF}
   SysUtils,
   SConsts,Base;

{$IFDEF Windows}
const EOL1=#13;
      EOL2=#10;
{$ENDIF}
{$IFDEF LINUX}
const EOL1=#10;
      EOL2=#10;
{$ENDIF}
{$IFDEF Darwin}
const EOL1=#13;
      EOL2=#13;
{$ENDIF}



// CaretPos障害対策
(*
function LineFromChar(memo:TSynEdit; n:integer):integer; //line index from char pos
var
   i:integer;
   svSelStart:integer;
   s:string[2];
begin
  result:=0;
  with memo do
     begin
       svSelStart:=SelStart;
       i:=0;
       while i<n do
         begin
            SelStart:=i;
            SelLength:=1;
            s:=SelText;

            if (s=#13) then
              begin
                 inc(result);
                 SelStart:=i;
                 SelLength:=2;
                 s:=SelText;
                 if s=#13#10 then
                    inc(i);
              end
            else
              if (s=#10) then inc(result);

            inc(i)
         end;
       SelStart:=svSelStart;
       SelLength:=0;
     end;
end;


function LineIndex(memo:TSynEdit; n:integer):integer;    //line index to char pos
var
   i:integer;
   svSelStart:integer;
   s:string[2];
begin
  result:=0;
  with memo do
    begin
      svSelStart:=SelStart;
      i:=0;
      while (i<n) do
        begin
          SelStart:=result;
          sellength:=1;
          s:=SelText;
          if s='' then break;
          if s=#13 then
             begin
                inc(i);
                SelStart:=Result;
                SelLength:=2;
                s:=Seltext;
                if s=#13#10 then inc(result);
             end
          else
            if s=#10 then inc(i);
          inc(result);
        end;
       SelStart:=svSelStart;
       SelLength:=0;
    end;
end;
*)

function LineFromChar(memo:TSynEdit; n:integer):integer; //line index from char pos
var
   svSelStart:integer;
begin
  with memo do
  begin
    Lines.BeginUpdate;
    svSelStart:=SelStart;
    SelStart:=n;
    //Sellength:=0;
    result:=CaretX-1;
    SelStart:=svSelStart;
    Lines.EndUpdate;
  end;
end;

function LineIndex(memo:TSynEdit; n:integer):integer;    //line index to char pos
var
  svSelStart:integer;
begin
  result:=0;
  with memo do
  begin
    Lines.BeginUpdate;
    svSelStart:=SelStart;
    CaretX:=1;
    CaretY:=n+1;
    result:=selStart;
    SelStart:=svSelStart;
    lines.endUpdate;
  end;
end;



(*
function  isDBCSLeadByte(ch:byte):boolean;
  begin
     result:=char(ch) in LeadBytes;
  end;

procedure ReadMBC(var i:integer; const s:AnsiString);
begin
   if isDBCSLeadByte(byte(s[i])) then
         inc(i);
end;
*)

  //assume UTF-8
procedure ReadMBC(var i:integer; const s:AnsiString);
var
   b:byte;
begin
   b:=byte(s[i]);
   if b>=$c0 then
      if b<$e0 then
         inc(i)
      else if b<$f0 then
         inc(i,2)
      else if b<$f8 then
         inc(i,3)
      else if b<$fc then
         inc(i,4)
      else if b<$fe then
         inc(i,5);
end;

 procedure NotAvailableMessage;
begin
   Messagedlg('This feature not available yet.' ,mterror,[mbok],0)
end;


function isTrueFile(s:string):boolean;
{$IFDEF Linx}
var
  buf: TStatBuf;
begin
  result:=false;
  if STAT(PChar(s),buf) and S_ISREG(buf.st_mode) then
    result:=true
end;
{$ELSE}
begin
   result:=true;  //dummy
end;
{$ENDIF}


//{$IFDEF LINUX}
(*
procedure SetSysStackSize;
var
  rlim:rlimit;
begin
  if (getrlimit(RLIMIT_STACK, rlim)=0 )
     and (rlim.rlim_max>=$00800000) then
     begin
        rlim.rlim_cur:=$00800000;
        if setrlimit(RLIMIT_STACK, rlim)=0 then
           StackLimit:=$00400000;
     end;
end;
*)
//{$ELSE}
procedure SetSysStackSize;
begin
           StackLimit1:=$00400000;
end;
//{$ENDIF}


begin

 SetSysStackSize
end.

