unit vstack;
{$IFDEF FPC}
  {$MODE DELPHI}{$H+}
{$ENDIF}

(***************************************)
(* Copyright (C) 2003, SHIRAISHI Kazuo *)
(***************************************)


interface

function getmemory(size:integer):pointer;
procedure freememory(size:integer);
procedure InitMemory;

implementation

uses
{$IFDEF LINUX}
   Libc,
{$ENDIF}
   base ;

var
  StackBase:pointer;
  StackBottom:pointer;
  StackLimit:pointer;

function getmemory(size:integer):pointer;
begin
  if LongInt(StackLimit)-LongInt(StackBottom)<size then
                   setexception(VirtualStackOverflow);
  GetMemory:=StackBottom;
  Inc(Longint(StackBottom),size);
end;

procedure freememory(size:integer);
begin
  Dec(Longint(StackBottom),size);
end;

procedure InitMemory;
begin
  StackBottom:=StackBase
end;


var
   StackSize:Cardinal=$2000000;  {32MB}

{$IFDEF LINUX}
procedure setMaxStackSize;
var
  pagesize, physpages:longint;
  physmemory:int64;
begin
  pagesize:=sysconf(_SC_PHYS_PAGES );
  physpages:=sysconf(_SC_AVPHYS_PAGES );
    StackSize:= $2000000  {32MB} ;
  if (pagesize>0) and (physpages>0) then
    begin
       physmemory:=int64(pagesize)*physpages;
       if physmemory>$24000000 {512MB+64MB} then
          stacksize:= $20000000 {512MB}
       else if physmemory>=$6000000 {32MB+64MB} then
          stacksize:=physmemory-$4000000 {64MB}
    end;
end;
{$ENDIF}

procedure ReadIniFile;
var
   IniFile:TMyIniFile;
begin
  IniFile:=TMyIniFile.create('Frame');
  with IniFile do
    begin
      StackSize:=ReadInteger('VirtualMemory',StackSize div $100000) * $100000;
      free;
    end;
  if StackSize> $40000000 {1GB} then StackSize:=$40000000;
end;

initialization

{$IFDEF LINUX}

 setmaxstacksize;
 ReadIniFile;

 StackBase:=mmap(nil, StackSize, PROT_READ or PROT_WRITE
                  , MAP_PRIVATE or MAP_ANONYMOUS, 0, 0);
 while StackBase=MAP_FAILED do
    begin
       dec(StackSize, $4000000{64MB});
       StackBase:=mmap(nil, StackSize, PROT_READ or PROT_WRITE
                          , MAP_PRIVATE or MAP_ANONYMOUS, 0, 0);
    end;

{$ELSE}
 GetMem(StackBase,StackSize);
{$ENDIF}
 StackBottom:=StackBase;
 Cardinal(StackLimit):=Cardinal(StackBase)+StackSize;


finalization
{$IFDEF LINUX}

{$ELSE}
 FreeMem(stackBase,StackSize);
{$ENDIF}

end.
