unit compadlg;

{$IFDEF FPC}
  {$MODE DELPHI}{$H+}
{$ENDIF}

(***************************************)
(* Copyright (C) 2003, SHIRAISHI Kazuo *)
(***************************************)


interface

uses  SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls, LResources;

type

  { TcompatibilityDialog }

  TcompatibilityDialog = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    HelpBtn: TButton;
    PageControl1: TPageControl;
    RadioGroup12: TRadioGroup;
    RadioGroup3: TRadioGroup;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    RadioGroup1: TRadioGroup;
    RadioGroup4: TRadioGroup;
    RadioGroup5: TRadioGroup;
    RadioGroup2: TRadioGroup;
    RadioGroup6: TRadioGroup;
    RadioGroup9: TRadioGroup;
    RadioGroup11: TRadioGroup;
    procedure HelpBtnClick(Sender: TObject);
  private
    { Private 宣言 }
  public
    { Public 宣言 }
  end;

var
  compatibilityDialog: TcompatibilityDialog;

procedure setCompatibility;

implementation

uses MainFrm,base,graphsys, express,htmlhelp;



procedure TcompatibilityDialog.HelpBtnClick(Sender: TObject);
begin
  OpenHelp(HelpContext);
end;

procedure setCompatibility;

begin
   with compatibilityDialog do
   begin
       RadioGroup1.ItemIndex:=byte(JISFormat);
       RadioGroup2.ItemIndex:=byte(InitialCharacterByte0);
       RadioGroup3.ItemIndex:=byte(JISSetWindow);
       RadioGroup4.ItemIndex:=byte(JISDim);
       RadioGroup5.ItemIndex:=byte(ForceFunctionDeclare);
       RadioGroup6.ItemIndex:=byte(JISDef);
       RadioGroup9.ItemIndex:=byte(ForNextBroadOwn);
       RadioGroup11.ItemIndex:=1+byte(TextProblemCoordinate)-byte(TextPhysicalCoordinate);
       RadioGroup12.ItemIndex:=byte(ResultVarStatic);

      if ShowModal=mrOK then
        begin
          byte(JISFormat):=RadioGroup1.ItemIndex;
          byte(InitialCharacterByte0):=RadioGroup2.ItemIndex;
          byte(JISSetWindow):=RadioGroup3.ItemIndex;
          byte(JISDim):=RadioGroup4.ItemIndex;
          byte(ForceFunctionDeclare):=RadioGroup5.ItemIndex;
          byte(JISDef):=RadioGroup6.ItemIndex;
          byte(ForNextBroadown):=RadioGroup9.ItemIndex;
          TextPhysicalCoordinate:=RadioGroup11.ItemIndex = 0;
          TextProblemCoordinate:=RadioGroup11.ItemIndex = 2;
          byte(ResultVarStatic):=RadioGroup12.ItemIndex;

        end;
   end;
end;

initialization
  {$i compadlg.lrs}
  with TMyIniFile.create('Frame') do
   begin
     JISFormat:=            ReadBool('JISFormat',JISFormat);
     InitialCharacterByte0:=ReadBool('CharacterByte', InitialCharacterByte0);
     JISSetWindow:=         ReadBool('JISSetWindow',JISSetWindow);
     JISDim:=               ReadBool('JISDim',JISDim);
     ForceFunctionDeclare:= ReadBool('ForceFunctionDeclare',ForceFunctionDeclare);
     JISDef:=               ReadBool('JISDef',JISDef);
     ForNextBroadOwn:=      ReadBool('ForNextBroadOwn',ForNextBroadOwn);
     ResultVarStatic:=      ReadBool('ResultVarStatic',ResultVarStatic);
     free
   end;
 with TMyIniFile.create('Graphics') do
  begin
     //GeometricPenOnly:=     ReadBool('GeometricPenOnly',GeometricPenOnly);
     //ForwardPlot:=          ReadBool('ForwardPlot',ForwardPlot);
     TextProblemCoordinate:= ReadBool('TextProblemCoordinate',TextProblemCoordinate);
     TextPhysicalCoordinate:=ReadBool('TextPhysicalCoordinate',TextPhysicalCoordinate);
     free
  end;

finalization
  with TMyIniFile.create('Frame') do
   begin
    WriteBool('JISFormat',JISFormat);
    WriteBool('CharacterByte', InitialCharacterByte0);
    WriteBool('JISSetWindow',JISSetWindow);
    WriteBool('JISDim',JISDim);
    WriteBool('ForceFunctionDeclare',ForceFunctionDeclare);
    WriteBool('JISDef',JISDef);
    WriteBool('ForNextBroadOwn',ForNextBroadOwn);
    WriteBool('ResultVarStatic',ResultvarStatic);
    free
   end;
 with TMyIniFile.create('Graphics') do
  begin
      //WriteBool('GeometricPenOnly',GeometricPenOnly);
      //WriteBool('ForwardPlot',ForwardPlot);
      WriteBool('TextProblemCoordinate',TextProblemCoordinate);
      WriteBool('TextPhysicalCoordinate', TextPhysicalCoordinate);
   free
  end;



end.

