unit LocateFrm;

{$MODE Delphi}

interface

uses
  Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls;


type
  TLocateForm = class(TForm)
    TrackBar1: TTrackBar;
    OkButton: TButton;
    Label1: TLabel;
    Name1: TLabel;
    Name2: TLabel;
    TrackBar2: TTrackBar;
    Label2: TLabel;
    Name3: TLabel;
    TrackBar3: TTrackBar;
    Label3: TLabel;
    name4: TLabel;
    TrackBar4: TTrackBar;
    Label4: TLabel;
    name5: TLabel;
    TrackBar5: TTrackBar;
    Label5: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure TrackBar3Change(Sender: TObject);
    procedure TrackBar4Change(Sender: TObject);
    procedure TrackBar5Change(Sender: TObject);
  private
    valuet1,left1,right1:double;
    valuet2,left2,right2:double;
    valuet3,left3,right3:double;
    valuet4,left4,right4:double;
    valuet5,left5,right5:double;
  public
    function Value1(vr,vi,nowait:boolean; left0,right0,ini0:double; Name0:Ansistring):extended;
    function Value2(vr,vi,nowait:boolean; left0,right0,ini0:double; Name0:Ansistring):extended;
    function Value3(vr,vi,nowait:boolean; left0,right0,ini0:double; Name0:Ansistring):extended;
    function Value4(vr,vi,nowait:boolean; left0,right0,ini0:double; Name0:Ansistring):extended;
    function Value5(vr,vi,nowait:boolean; left0,right0,ini0:double; Name0:Ansistring):extended;
    procedure InitValue;
  end;

var
  LocateForm: TLocateForm;

implementation
uses Base,Struct,PaintFrm;
{$R *.lfm}



function TLocateForm.Value1(vr,vi,nowait:boolean; left0,right0,ini0:double; Name0:Ansistring):extended;
begin
   name1.Caption:=name0;
   OkButton.Visible:=not nowait;
   name1.Visible:=true;

   if vr then
     begin
      left1:=left0;
      right1:=right0;
     end;

   if vi then
      valuet1:=ini0;

   if (valuet1-left1)*(valuet1-right1)>0 then
      if vi then
         setexception(11152)
      else
         valuet1:=(left0+right0)/2.0;

   with TrackBar1 do
            Position:=round(min+(valuet1-left1)/(right1-left1)*(max-min));
   //TrackBar1Change(self);

   TrackBar1.Visible:=true;
   TrackBar1.Enabled:=true;
   WindowState:=wsNormal;
   if nowait then
      visible:=true
   else
     begin
       TrackBar2.Enabled:=false;
       TrackBar3.Enabled:=false;
       TrackBar4.Enabled:=false;
       TrackBar5.Enabled:=false;
       Application.ProcessMessages;
       if showModal<>mrOk then
          CtrlBreakHit:=true ;
       TrackBar1.Enabled:=false;
     end;
   result:=valuet1;
end;

function TLocateForm.Value2(vr,vi,nowait:boolean; left0,right0,ini0:double; Name0:Ansistring):extended;
begin
   name2.Caption:=name0;
   OkButton.Visible:=not nowait;
   if ClientHeight<2*50 then
    {$IFDEF Linux}begin visible:=true;{$ENDIF}
                            ClientHeight:=2*50;
   {$IFDEF Linux}visible:=false; end;{$ENDIF}
   name2.Visible:=true;

   if vr then
     begin
      left2:=left0;
      right2:=right0;
     end;

   if vi then
      valuet2:=ini0;

   if (valuet2-left2)*(valuet2-right2)>0 then
      if vi then
         setexception(11152)
      else
         valuet2:=(left0+right0)/2.0;

   with TrackBar2 do
            Position:=round(min+(valuet2-left2)/(right2-left2)*(max-min));
   //TrackBar2Change(self);

   TrackBar2.Visible:=true;
   TrackBar2.Enabled:=true;
   WindowState:=wsNormal;
   if nowait then
      visible:=true
   else
     begin
       TrackBar1.Enabled:=false;
       TrackBar3.Enabled:=false;
       TrackBar4.Enabled:=false;
       TrackBar5.Enabled:=false;
       Application.ProcessMessages;
       if showModal<>mrOk then
          CtrlBreakHit:=true ;
       TrackBar2.Enabled:=false;
     end;

   result:=valuet2
end;



function TLocateForm.Value3(vr,vi,nowait:boolean; left0,right0,ini0:double; Name0:Ansistring):extended;
begin
   name3.Caption:=name0;
   OkButton.Visible:=not nowait;
   if ClientHeight<3*50 then
   {$IFDEF Linux}begin visible:=true;{$ENDIF}
                       ClientHeight:=3*50;
   {$IFDEF Linux}visible:=false; end;{$ENDIF}
   name3.Visible:=true;

   if vr then
     begin
      left3:=left0;
      right3:=right0;
     end;

   if vi then
      valuet3:=ini0;

   if (valuet3-left3)*(valuet3-right3)>0 then
      if vi then
         setexception(33352)
      else
         valuet3:=(left0+right0)/2.0;

   with TrackBar3 do
            Position:=round(min+(valuet3-left3)/(right3-left3)*(max-min));
   //TrackBar3Change(self);

   TrackBar3.Visible:=true;
   TrackBar3.Enabled:=true;
   WindowState:=wsNormal;
   if nowait then
      visible:=true
   else
     begin
       TrackBar1.Enabled:=false;
       TrackBar2.Enabled:=false;
       TrackBar4.Enabled:=false;
       TrackBar5.Enabled:=false;
       Application.ProcessMessages;
       if showModal<>mrOk then
          CtrlBreakHit:=true ;
       TrackBar3.Enabled:=false;
     end;

   result:=valuet3;
end;

function TLocateForm.Value4(vr,vi,nowait:boolean; left0,right0,ini0:double; Name0:Ansistring):extended;
begin
   name4.Caption:=name0;
   OkButton.Visible:=not nowait;
   if ClientHeight<4*50 then
     {$IFDEF Linux}begin visible:=true;{$ENDIF}
                              ClientHeight:=4*50;
   {$IFDEF Linux}visible:=false; end;{$ENDIF}
   name4.Visible:=true;

   if vr then
     begin
      left4:=left0;
      right4:=right0;
     end;

   if vi then
      valuet4:=ini0;

   if (valuet4-left4)*(valuet4-right4)>0 then
      if vi then
         setexception(44454)
      else
         valuet4:=(left0+right0)/4.0;

   with TrackBar4 do
            Position:=round(min+(valuet4-left4)/(right4-left4)*(max-min));
   //TrackBar4Change(self);

   TrackBar4.Visible:=true;
   TrackBar4.Enabled:=true;
   WindowState:=wsNormal;
   if nowait then
      visible:=true
   else
     begin
       TrackBar1.Enabled:=false;
       TrackBar2.Enabled:=false;
       TrackBar3.Enabled:=false;
       TrackBar5.Enabled:=false;
       Application.ProcessMessages;
       if showModal<>mrOk then
          CtrlBreakHit:=true ;
       TrackBar4.Enabled:=false;
     end;


   result:=valuet4;
end;

function TLocateForm.Value5(vr,vi,nowait:boolean; left0,right0,ini0:double; Name0:Ansistring):extended;
begin
   name5.Caption:=name0;
   OkButton.Visible:=not nowait;
   if ClientHeight<5*50 then
    {$IFDEF Linux}begin visible:=true;{$ENDIF}
                          ClientHeight:=5*50;
    {$IFDEF Linux}visible:=false; end;{$ENDIF}
    name5.Visible:=true;

   if vr then
     begin
      left5:=left0;
      right5:=right0;
     end;

   if vi then
      valuet5:=ini0;

   if (valuet5-left5)*(valuet5-right5)>0 then
      if vi then
         setexception(55552)
      else
         valuet5:=(left0+right0)/2.0;

   with TrackBar5 do
            Position:=round(min+(valuet5-left5)/(right5-left5)*(max-min));
   //TrackBar5Change(self);

   TrackBar5.Visible:=true;
   TrackBar5.Enabled:=true;
   WindowState:=wsNormal;
   if nowait then
      visible:=true
   else
     begin
       TrackBar1.Enabled:=false;
       TrackBar2.Enabled:=false;
       TrackBar3.Enabled:=false;
       TrackBar4.Enabled:=false;
       Application.ProcessMessages;
       if showModal<>mrOk then
          CtrlBreakHit:=true ;
       TrackBar1.Enabled:=false;
     end;


   result:=valuet5;
end;




procedure TLocateForm.FormCreate(Sender: TObject);
begin
  {$IFDEF Linux}
  BorderStyle:=bsSizeable;
  {$ENDIF}
  if height<paintform.Top then
     top:=paintform.Top-height
  else
     top:=0;
  left:=paintform.left+paintform.width-width;
end;

procedure TLocateForm.TrackBar1Change(Sender: TObject);
begin
 with TrackBar1 do
   begin
     valuet1:=left1 + (Position/(max-min))*(right1-left1);
     Label1.Caption:=Format('%8.8g',[valuet1]);
     Label1.Left:=Left+(Position -label1.Width) div 2;
     Label1.Visible:=true;
   end;
end;

procedure TLocateForm.TrackBar2Change(Sender: TObject);
begin
 with TrackBar2 do
   begin
     valuet2:=left2 + (Position/(max-min))*(right2-left2);
     Label2.Caption:=Format('%8.8g',[valuet2]);
     Label2.Left:=Left+(Position -label2.Width) div 2;
     Label2.Visible:=true;
   end;
end;

procedure TLocateForm.TrackBar3Change(Sender: TObject);
begin
 with TrackBar3 do
   begin
     valuet3:=left3 + (Position/(max-min))*(right3-left3);
     Label3.Caption:=Format('%8.8g',[valuet3]);
     Label3.Left:=Left+(Position -label3.Width) div 2;
     Label3.Visible:=true;
   end;
end;

procedure TLocateForm.TrackBar4Change(Sender: TObject);
begin
 with TrackBar4 do
   begin
     valuet4:=left4 + (Position/(max-min))*(right4-left4);
     Label4.Caption:=Format('%8.8g',[valuet4]);
     Label4.Left:=Left+(Position -label4.Width) div 2;
     Label4.Visible:=true;
   end;
end;

procedure TLocateForm.TrackBar5Change(Sender: TObject);
begin
 with TrackBar5 do
   begin
     valuet5:=left5 + (Position/(max-min))*(right5-left5);
     Label5.Caption:=Format('%8.8g',[valuet5]);
     Label5.Left:=Left+(Position -label5.Width) div 2;
     Label5.Visible:=true;
   end;
end;

procedure TLocateForm.InitValue;
begin
  Visible:=false;
  Application.ProcessMessages;
  left1:=0;  right1:=1;   valuet1:=0.5;
  left2:=0;  right2:=1;   valuet2:=0.5;
  left3:=0;  right3:=1;   valuet3:=0.5;
  left4:=0;  right4:=1;   valuet4:=0.5;
  left5:=0;  right5:=1;   valuet5:=0.5;
  name1.Visible:=false; Trackbar1.Visible:=false; Label1.Visible:=false;
  name2.Visible:=false; Trackbar2.Visible:=false; Label2.Visible:=false;
  name3.Visible:=false; Trackbar3.Visible:=false; Label3.Visible:=false;
  name4.Visible:=false; Trackbar4.Visible:=false; Label4.Visible:=false;
  name5.Visible:=false; Trackbar5.Visible:=false; Label5.Visible:=false;
  ClientHeight:=50;
  OkButton.Visible:=true;
end;

end.
