unit MyThread;
{$IFDEF FPC}
  {$MODE DELPHI}{$H+}
{$ENDIF}
interface

uses    Classes, SysUtils,Graphics,
        Forms,Dialogs, Controls, extctrls;


 procedure RepaintExec;
 procedure MainTask;
 var
      //ConsoleInputRequest:boolean=false;
      //CharacterInputRequest:boolean=false;
      MsgDlgRequest:boolean=false;
      RepaintRequest:boolean = true;

 function ThreadMessageDlg(const aMsg: String; DlgType: TMsgDlgType;
                            Buttons: TMsgDlgButtons; HelpCtx: LongInt):Integer;

 // var
 //    TextOutWorking:boolean=false;
 // procedure Drop(s:ansistring);
 // procedure TextoutExec;
 Type
   TMyThread = class(TThread)
  private
     procedure ExecuteDebugDlg;
     procedure ExecuteMesDlg;
     procedure ExecuteInputDlg;
     procedure ExecuteCharInput;
     procedure ExecuteOpenDlg;
     procedure ExecuteTraceFormMinimize;
  protected
     procedure Execute; override;
  public
     Constructor Create;
     procedure ExecDebugDlg;
     procedure ExecMesDlg;
     procedure ExecInputDlg;
     procedure ExecCharInput;
     procedure ExecOpenDlg;
     procedure ExecTraceFormMinimize;
   end;
var
    RunThread:TMyThread;

implementation
uses  Math,
  base,charinp,textfrm,textfile,paintfrm,graphsys,graphque,debugdg,debug,tracefrm,
  struct,compiler,inputdlg,extensio;

var
  MsgText:string;
  MsgDlgType: TMsgDlgType;
  DlgButtons: TMsgDlgButtons;
  DlgHelpContext:integer;
  DlgResult:integer;

function ThreadMessageDlg(const aMsg: String; DlgType: TMsgDlgType;
                          Buttons: TMsgDlgButtons; HelpCtx: LongInt):Integer;
begin
    MsgText:=aMsg;
    MsgDlgType:=DlgType;
    DlgButtons:=Buttons;
    DlgHelpContext:=HelpCtx;
    //MsgDlgRequest:=true;
    RunThread.ExecMesDlg;
    result:=DlgResult
end;

{***********}
{RepaintExec}
{***********}
procedure RepaintExec;
begin
if RepaintRequest then
   begin
     RepaintRequest:=false;
     {$IFDEF Windows}
      PaintForm.PaintBox1Paint(nil);
     {$ELSE}
      PaintForm.RePaint;
      SetFPUMask(OriginalCW);Application.ProcessMessages;
     {$ENDIF}
   end;
 end;

procedure MainTask;
var
d:Dword;
begin
    GraphOutExec;
    if not HiddenDrawMode then
       RepaintExec;

    with textform do
      if not TextOutWorking then
       TextOutExec;



    {
     if CharacterInputRequest then
       begin
            charInput.execute;
            CharacterInputRequest:=false;
       end;
     if ConsoleInputRequest then
        begin
            Console.DataRequest;
            ConsoleInputRequest:=false;
        end;

    if DebugRequest then
       begin
            ExecInspectBox;
            DebugRequest:=false;
       end;
    }
    if TraceFormRequest=true then
       begin
         TraceFormRequest:=false;
         with TraceForm do
           begin
             visible:=true;
             if WindowState=wsMinimized then WindowState:=wsNormal;
           end;
        end;
    {
    if MsgDlgRequest then
       begin
         DlgResult:=MessageDlg(MsgText,MsgDlgType,DlgButtons,DlgHelpContext);
         MsgDlgRequest:=false;
       end;
    }
    with TraceForm do
      if not TextOutWorking then
       TextOutExec;


    if CtrlBreakHit then
       begin
        // {$IFDEF Windows} AllThreadsList.Suspend;{$ENDIF}
        // DebugDLG.Execute;
        // CtrlBreakHit:=false;
        // {$IFDEF Windows}AllThreadsList.Resume;{$ENDIF}
       end;

    //ClearExceptions(false);
    SetFPUMask(OriginalCW);
    Application.ProcessMessages;
 end;

constructor TMyThread.create;
begin
  inherited create(false,StackLimit1+$80000);
  //FreeOnTerminate:=true;
end;

procedure TMyThread.execute;
begin
  ExecuteOnThread;
end;

procedure TmyThread.ExecuteDebugDlg;
begin
  ExecInspectBox;
end;

procedure TMyThread.ExecDebugDlg;
begin
   Synchronize(ExecuteDebugDlg);
end;

procedure TMyThread.ExecuteMesDlg;
begin
   DlgResult:=MessageDlg(MsgText,MsgDlgType,DlgButtons,DlgHelpContext);
end;

procedure TMyThread.ExecMesDlg;
begin
   Synchronize(ExecuteMesDlg);
end;

procedure TMyThread.ExecuteInputDlg;
begin
    InputDialog.execute;
end;

procedure  TMyThread.ExecInputDlg;
begin
    Synchronize(ExecuteInputDlg);
 end;

procedure TMyThread.ExecuteCharInput;
begin
    CharInput.execute;
end;

procedure TMyThread.ExecCharInput;
begin
    Synchronize(ExecuteCharInput)
end;

procedure TMyThread.ExecuteOpenDlg;
begin
    extensio.opendlg.execute;
end;

procedure TMyThread.ExecOpenDlg;
begin
   Synchronize(ExecuteOpenDlg)
end;

procedure TMyThread.ExecuteTraceFormMinimize;
begin
    TraceForm.WindowState:=wsMinimized;
end;

procedure TMyThread.ExecTraceFormMinimize;
begin
    Synchronize(ExecuteTraceFormMinimize)
end;


initialization
    //InitCriticalSection(DropCriticalSection);

finalization
    //DoneCriticalSection(DropCriticalSection);

end.

