100 ! コッホ曲線
110 ! 底辺ABの長さが3で高さがsqr(3)/2の二等辺三角形CABで，頂点Aを不動点として，点Bを点Cに移し，点Cを線分AB上の点に移すような相似変換をf1，
115 ! 頂点Bを不動点として，点Aを点Cに移し，点Cを線分BA上の点に移すような相似変換をf2とするとき，
120 ! f1,f2に対して，f1(D)∪f2(D)=D となる自己相似図形Dをコッホ曲線といいます（曲線という名前がついていますが，定義自体からは曲線かどうかわかりません。）
130 ! このプログラムは，上の定義をほとんどそのままに実行してコッホ曲線の近似解を描きます。
140 ! このプログラムでは，３頂点の座標をA(0,0)，B(3,0)，C(3/2,SQR(3)/2) と仮定します。
150 ! 縮小写像f1,f2の倍率rを280行で計算しています。線分ACの長さを線分ABの長さで割って求めています。
155 ! 再帰呼び出しの度に絵Kochの引数sにrを乗じていきます。
160 ! 最初sの値は1です（320行）。
170 ! sの値がビットマップの大きさに比べて無視できる大きさになったとき，1点を描きます（220行）。
180 ! したがって，描画領域のドット数を増やして実行する場合には，210行の定数を大きくして実行する必要があります。
190 ! 参考文献 「カオスとフラクタル入門」山口昌哉 （放送大学印刷教材）ISBN4-595-56791-X
200 PICTURE Koch(s)
210    IF s<1/1000 THEN 
220       PLOT POINTS: 0,0
230    ELSE
240       DRAW Koch(s*r) WITH SCALE(1,-1)*ROTATE(alfa)*SCALE(r) 
250       DRAW Koch(s*r) WITH SHIFT(-3,0)*SCALE(1,-1)*ROTATE(-alfa)*SCALE(r)*SHIFT(3,0)
260    END IF
270 END PICTURE
280 LET r=SQR((3/2)^2+(SQR(3)/2)^2) / 3
290 LET alfa=ANGLE(3/2,SQR(3)/2)
300 SET WINDOW 0,3,0,3
310 SET POINT STYLE 1
320 DRAW Koch(1)
330 END
