unit htmlhelp;
{$MODE DELPHI}{$H+}
(***************************************)
(* Copyright (C) 2003, SHIRAISHI Kazuo *)
(***************************************)

interface
uses
  SysUtils, Types, Classes, Variants, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls;
procedure OpenHelp(hcx:integer); overload;
procedure OpenHelp(key:Ansistring); overload;


implementation
uses
  LCLIntf,
  MainFrm,hselect;
var
  CurrentPos:string;
  KeyWordRec:TStringList;
function HtmName(s:string):string;
var
  p:integer;
begin
  p:=pos('#',s);
  if p=0 then p:=length(s)+1;
  result:=copy(s,1,p-1);
end;
function Anchor(s:string):string;
var
  p:integer;
begin
  p:=pos('#',s);
  if p=0 then
    result:=''
  else
    result:=copy(s,p+1,length(s)-p);
end;
function LinkSelect(const HelpString: String):string;
var
   i:integer;
   s:string;
begin
  s:=KeyWordRec.Values[HelpString];
  if (s='')then
       result:='basic.htm'
  else if s[1]<>'"' then
       result:=s
  else
   begin
     with TStringList.Create do
     begin
       CommaText:=s;
       with HelpSelector do
        begin
          RadioGroup1.Caption:=HelpString;
          for i:=0 to (count-1) div 2 do
                RadioGroup1.items.add(strings[i*2]);
          RadioGroup1.ItemIndex:=0;
          //RadioGroup1.SetFocus;
          ShowModal;
          result:=Strings[RadioGroup1.ItemIndex *2 +1];
          RadioGroup1.items.Clear;
        end;
       Free;
      end;
   end;
end;
var
  HelpContexts:array [0..999] of string ;
  ALinks:TStringList;

procedure InitHelpContexts;
var
   F:text;
   n:integer;
   s:string;
   p:integer;
   c:integer;
begin
   assignFile(F,ChangeFileExt(Application.ExeName,'.hcx'));
{$I-}
   Reset(F);
   if IOResult=0 then
     begin
       while not EOF(F) do
         begin
           Readln(F,s);
           p:=pos(' ',s);
           if p>0 then
             begin
               val(copy(s,p,maxint),n, c);
               if (n>=0) and (n<=999) then HelpContexts[n]:=copy(s,1,p-1);
             end;
         end;
       Close(F);
     end;
{$I+}
end;
procedure InitALinks;
var
   s:string;
begin
  s:=ChangeFileExt(Application.ExeName,'.hlk');
  ALinks:=TStringList.create;
  try
      ALinks.LoadFromFile(s) ;
  except
      ShowMessage(s + ' not found')
  end;
end;


procedure InitKeyWordRec;
var
   F:text;
   s:string;
begin
   KeywordRec:=TStringList.create;
   KeywordRec.CaseSensitive:=false;
   AssignFile(F,ChangeFileExt(Application.ExeName,'.hkw'));
{$I-}
   Reset(F);
   if IOResult=0 then
     begin
       while not EOF(F) do
         begin
           Readln(F,s);
           KeywordRec.add(s);
         end;
       close(F);
     end;
{$I+}
end;

procedure OpenBrowser(s:ansistring);
var
   i:integer;
begin
  s:=ExtractFilePath(Application.ExeName)+ s;
  openURL('file://'+s);
end;

procedure OpenHelp(hcx:integer);
var
   s:ansistring;
begin
   s:=ALinks.Values[HelpContexts[hcx]];
   if s='' then
         s:='basic.htm'
   else
        {$IFDEF Windows}
         s:='html\'+s;
        {$ELSE}
         s:='html/'+s;
        {$ENDIF}
   OpenBrowser(s);
end;
procedure OpenHelp(key:ansistring);
begin
  OpenBrowser(LinkSelect(key));
end;



initialization
   InitKeyWordRec;
   InitHelpContexts;
   InitALinks;

finalization
   ALinks.Free;
   KeywordRec.free;
end.
