unit myutils;
{$IFDEF FPC}
  {$MODE DELPHI}{$H+}
{$ENDIF}
(***************************************)
(* Copyright (C) 2007, SHIRAISHI Kazuo *)
(***************************************)

interface
uses Dialogs,StdCtrls,Types,SysUtils,Forms, Math,
     LCLType;

  function FPUerror:boolean;
  function LineFromChar(memo:TMemo; n:integer):integer; //line index from char pos
  function LineIndex(memo:Tmemo; n:integer):integer;    //line index to char pos
  procedure ReadMBC(var i:integer; const s:AnsiString);
  function isTrueFile(const s:string):boolean;
  procedure NotAvailableMessage;
  function adjustEOL(s:string):string;
  function IniFileName:string;
const
  mb_YesNo=LCLType.mb_YesNo;
  mb_OKCANCEL=LCLType.mb_OKCANCEL;
  IDOk=LCLType.IDOk;
  IDYES=LCLType.IDYES;
  vk_F1=LCLType.vk_F1;
  vk_F5=LCLType.vk_F5;
  vk_F6=LCLType.vk_F6;
  vk_F7=LCLType.vk_F7;
  vk_F8=LCLType.vk_F8;
  vk_insert=LCLType.vk_insert;
  TRANSPARENT=LCLType.TRANSPARENT;
  OPAQUE=LCLType.OPAQUE;
  OEM_CHARSET=LCLType.OEM_CHARSET;


implementation
uses
   {$IFDEF UNIX}
   baseUnix,Unix,UnixType,
   {$ENDIF}
   SConsts,Base;

{$IFDEF CPU386}
function FPUerror:boolean;assembler;
asm
   fstsw  ax
   and    ax, 0Dh
   FCLEX
   jz     @L1
   mov    ax,1
 @L1:
end;
{$ELSE}
{$IFDEF CPUX86_64}
 {$ASMMODE Intel}
function FPUerror:boolean;
begin
asm
   fstsw  ax
   and    ax, 0Dh
   FCLEX
   jz     @L1
   mov    ax,1
 @L1:
end;
end;
{$ELSE}
function FPUerror:boolean;
begin
  result:=false;
  try
    ClearExceptions(true)
  except
    result:=true;
  end;
end;
{$ENDIF}
{$ENDIF}
function adjustEOL(s:string):string;
var
   i:integer;
begin
{$IFDEF Windows}
  i:=1;
  while i<=length(s) do
    begin
      if s[i]=#13 then
         if (i<length(s)) and (s[i+1]=#10) then
            Inc(i)
         else
            begin
              inc(i);
              Insert(#10,s,i);
            end
       else if s[i]=#10 then
            begin
              Insert(#13,s,i);
              inc(i)
            end;
       inc(i);
    end;
  {$ELSE}
  i:=1;
  while i<= length(s) do
    begin
      if s[i]=#13 then
         if (i<length(s)) and (s[i+1]=#10) then
            Delete(s,i,1)
         else
             s[i]:=#10;
      inc(i)
    end;
{$ENDIF}
   result:=s;
end;



function LineFromChar(memo:TMemo; n:integer):integer; //line index from char pos
var
   svSelStart:integer;
begin
  with memo do
  begin
    Lines.BeginUpdate;
    svSelStart:=SelStart;
    SelStart:=n;
    Sellength:=0;
    result:=CaretPos.y;
    SelStart:=svSelStart;
    Lines.EndUpdate;
  end;
end;
function LineIndex(memo:Tmemo; n:integer):integer;    //line index to char pos
var
  Pos:TPoint;
  svSelStart:integer;
begin
  result:=0;
  Pos.y:=n;
  Pos.x:=0;
  with memo do
  begin
    Lines.BeginUpdate;
    svSelStart:=SelStart;
    CaretPos:=Pos;
    result:=selStart;
    SelStart:=svSelStart;
    lines.endUpdate;
  end;
end;


// UTF-8
procedure ReadMBC(var i:integer; const s:AnsiString);
var
   b:byte;
begin
   b:=byte(s[i]);
   case b of
      $c2..$df:  inc(i);
      $e0..$ef:  inc(i,2);
      $f0..$f4:  inc(i,3);
      // $f5..$fb:  inc(i,4);
      // $fc..$fd:  inc(i,5);
    end;
end;
 procedure NotAvailableMessage;
begin
   Messagedlg('This feature not available yet.' ,mterror,[mbok],0)
end;

{$IFDEF Windows}
type
  LPCSTR  = PChar;
  LPSTR   = Pchar;
function QueryDosDevice(lpDeviceName:LPCSTR; lpTargetPath:LPSTR; ucchMax:DWORD):DWORD; stdcall; external 'kernel32' name 'QueryDosDeviceA';
function isDeviceName(const FName:string):LongBool;
var
   buf:array[0..255] of char;
   s:ansistring;
   w:DWORD;
begin
   s:=UTF8ToANSI(FName);
   w:=QueryDosDevice(PChar(s),@buf,255);
   result:=(FName='PRN') or (w>0)
end;
function isTrueFile(const s:string):boolean;
begin
  result:=not  isDeviceName(s)
end;
{$ELSE}
{$IFDEF Unix}
function isTrueFile(const s:string):boolean;
 var
  buf: Stat;
begin
  result:=false;
  if (FPSTAT(PChar(s),buf)=0)                    // 0.6.4.6
  and ((buf.st_mode and STAT_IFMT)=STAT_IFREG)then
    result:=true
end;
function isDeviceName(const FName:string):LongBool;
begin
   result:=not isTrueFile(FName)
end;
{$ELSE}
function isDeviceName(const FName:string):LongBool;
begin
   result:=false;  //dummy
end;
{$ENDIF}
{$ENDIF}
function IniFileName:string;
begin
{$IFDEF UNIX}
   result:=GetEnvironmentVariable('HOME') + '/.basic.ini'
{$ELSE}
   result:= ChangeFileExt(Application.ExeName,'.ini')
{$ENDIF}
end;
begin
end.
