unit printdlg;

{$IFDEF FPC}
  {$MODE DELPHI}{$H+}
{$ENDIF}

interface

uses
   Types,Classes, SysUtils, Graphics, Controls, Forms, Dialogs,
   ExtCtrls, StdCtrls, Buttons, LResources,Printers;

type

  { TPrintDialog1 }

  TPrintDialog1 = class(TForm)
    ListBox1: TListBox;
    OkButton: TBitBtn;
    cancelButton: TBitBtn;
    FontDialog1: TFontDialog;
    PrinterButton: TButton;
    FontButton: TButton;
    procedure ListBox1SelectionChange(Sender: TObject; User: boolean);
    procedure PrinterButtonClick(Sender: TObject);
    procedure FontButtonClick(Sender: TObject);
    procedure OnFormShow(Sender: TObject);
  private
    { Private 宣言 }
  public
    procedure execute(memo1:TMemo);
  end;

var
  PrintDialog1: TPrintDialog1;
procedure PrintMemo(memo1:TMemo);

implementation
uses
     base,sconsts, myutils;
 {$R *.lfm}
procedure PrintMemo(memo1:TMemo);
var
  x,y,dy:integer;
  i: Integer;
begin
{todo 1 printer}

  with Printer do
    begin
      Canvas.Font.Assign(PrinterFont);
      Canvas.Font.PixelsPerInch:=XDPI;
      BeginDoc;
      with Canvas do
      begin
         //Brush.Color := clBlack;
         dy:=TextHeight(Memo1.Lines.Strings[0]);
         x:=0;
         y:=dy+dy;   //上margin
         i:=0;
         while i<Memo1.Lines.Count do
           begin
             TextOut(x,y, Memo1.Lines.Strings[i]);
             inc(i);
             y:=y+dy;
             if y>pageHeight then
                begin
                  y:=dy;
                  NewPage;
                end;
           end;
      end;
      EndDoc;
    end;

end;


procedure TPrintDialog1.execute(memo1:TMemo);
begin
  if showModal=mrOk then
          PrintMemo(Memo1);
end;

procedure TPrintDialog1.PrinterButtonClick(Sender: TObject);
begin
    NotAvailableMessage;
  //PrinterSetupDialog1.Execute;
end;

procedure TPrintDialog1.ListBox1SelectionChange(Sender: TObject; User: boolean);
begin
  Printer.PrinterIndex:=ListBox1.ItemIndex;
end;

procedure TPrintDialog1.FontButtonClick(Sender: TObject);
begin
   //FontDialog1.Device:=fdPrinter;
   FontDialog1.Font:=PrinterFont;
   if FontDialog1.Execute then
         PrinterFont.Assign(FontDialog1.Font);

end;

procedure TPrintDialog1.OnFormShow(Sender: TObject);
begin
    ListBox1.Items:=printer.printers;
    ListBox1.ItemIndex:=Printer.PrinterIndex;
end;

initialization

end.
