REM Reaction-Diffusion system
REM reference (in Japanese)
REM http://www.fbs.osaka-u.ac.jp/labs/skondo/ozaki/what%20is%20RD%202(outline).htm

OPTION ARITHMETIC NATIVE
DECLARE NUMERIC SIZE
LET SIZE=200

REM Parameters
DECLARE NUMERIC a,b,c,d,e,f,g
DECLARE NUMERIC Du,Dv
LET a=0.02
LET b=0.02
LET c=0.005
LET d=0.0075
LET e=0.025
LET f=0.0375
LET g=0.02
LET Du=0.01
LET Dv=0.125
DECLARE NUMERIC MaxFF,MaxGG
LET MaxFF=0.05
LET MaxGG=0.125

REM Variables
DIM u(0 TO SIZE+1, 0 TO SIZE+1)
DIM v(0 TO SIZE+1, 0 TO SIZE+1)
DIM uu(0 TO SIZE+1, 0 TO SIZE+1)
DIM vv(0 TO SIZE+1, 0 TO SIZE+1)
DIM w(0 TO SIZE+1, 0 TO SIZE+1)
DECLARE NUMERIC i,j

REM Initialize
DECLARE NUMERIC u0,v0,uMax
LET u0=3.5
LET v0=2.1
LET uMax=u0*2
! RANDOMIZE
MAT u=(u0/2)*CON
MAT v=(v0/2)*CON
FOR i=50 TO size
   FOR j=0 TO size
      LET u(i,j)=u0*(1/2+RND)
      LET v(i,j)=v0
   NEXT j
NEXT i
FOR j=1 TO SIZE
   LET u(0,j)=u(1,j)
   LET v(0,j)=v(1,j)
   LET u(size+1,j)=u(size,j)
   LET v(size+1,j)=v(size,j)
NEXT j
FOR i=1 TO size
   LET u(i,0)=u(i,1)
   LET v(i,0)=v(i,1)
   LET u(i,size+1)=u(i,size)
   LET v(i,size+1)=v(i,size)
NEXT i

CALL InitGraphics
CALL show

REM  Reaction and Diffusion
DEF FF(u,v)=MIN(MaxFF,MAX(0, a*u - b*v +c) )
DEF GG(u)  =MIN(MaxGG,MAX(0, e*u       -f) )
DECLARE NUMERIC ddu,ddv, uuu, vvv
DECLARE NUMERIC t
LOCATE VALUE(1), RANGE -2*c TO 4*c, AT c : c
LOCATE VALUE(2), RANGE 0.1 TO 0.15, AT Dv: Dv
FOR t=0 TO 100000
   FOR i= 1 TO SIZE
      FOR j= 1 TO size
         LET ddu = u(i,j+1) + u(i,j-1) +u(i-1,j)+u(i+1,j)-4*u(i,j)
         LET ddv = v(i,j+1) + v(i,j-1) +v(i-1,j)+v(i+1,j)-4*v(i,j)
         LET uuu= u(i,j) + ( FF(u(i,j),v(i,j)) - d * u(i,j) + Du * ddu )
         LET vvv= v(i,j) + ( GG(u(i,j))        - g * v(i,j) + Dv * ddv )
         IF uuu<0 THEN LET uuu=0
         IF vvv<0 THEN LET vvv=0
         LET uu(i,j)=uuu
         LET vv(i,j)=vvv
         IF uuu>uMax THEN LET uMax=uuu
      NEXT j
   NEXT i
   FOR j=1 TO size
      LET uu(0,j)=uu(1,j)
      LET vv(0,j)=vv(1,j)
      LET uu(size+1,j)=uu(size,j)
      LET vv(size+1,j)=vv(size,j)
   NEXT j
   FOR i=1 TO size
      LET uu(i,0)=uu(i,1)
      LET vv(i,0)=vv(i,1)
      LET uu(i,size+1)=uu(i,size)
      LET vv(i,size+1)=vv(i,size)
   NEXT i
   MAT u=uu
   MAT v=vv
    
   IF MOD(t,100)=0 THEN CALL show
   IF MOD(t,100)=0 THEN
      LOCATE VALUE nowait(1): c
      LOCATE VALUE nowait(2): Dv
   END if

NEXT t

DIM mes$(2)
DATA "CONTINUE","ABORT"
DECLARE NUMERIC cc
SUB InitGraphics
   SET bitmap SIZE SIZE*2,SIZE*2
   SET WINDOW 0,size,0,size
   FOR i=0 TO 255
      LET cc=i/255
      SET COLOR MIX(i) cc,cc,cc
   NEXT i
   SET TEXT COLOR 255
   SET TEXT BACKGROUND "OPAQUE"
   MAT READ mes$
END SUB

SUB show
   DECLARE NUMERIC x,y,l,r
   MAT w=(255/uMax)*u
   MAT PLOT CELLS , IN -1,-1; SIZE+1,SIZE+1:w
   PLOT TEXT, AT 0,0 ,USING "t=######":t
   mouse poll x,y,l,r
   IF 0<=x AND x<=SIZE AND 0<=y AND y<=SIZE THEN
      PLOT TEXT, AT 30,00, USING "u=##.## v=##.##":u(x,y),v(x,y)
   END IF
   IF r<>0 THEN
      LOCATE choice(mes$):cc
      IF cc=2 THEN STOP
   END if
END SUB

END
